unit UTempereNote;
{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}

interface

Type
  TCorrection = Array[0..11] of Double;
  TTempereNote = Array[1..4] of Byte;

Procedure Init_Intervalles_Quintes(Q_Intervalles_Cents: TCorrection);
Function TempereNote(Note, Canal: Byte): TTempereNote;
Procedure EtenduePitch(EnCents, EnUnites: Word);

Var
  { intervalles des quintes; 0=mib, 1=sib, ..., 11=sol# }
  Q_Intervalles_Unites_MIDI: Array[0..11] of Double;
  Q_Intervalles_MIDI_LSB_MSB: Array[0..11] of TTempereNote;
  { commas }
  Comma_Pythagoricien, Comma_Syntonique: Double;
  { paramtres carte son ou instrument MIDI }
  Etendue_Pitch_Cents, Etendue_Pitch_Unites: Word;

implementation

Procedure Init_Intervalles_Quintes(Q_Intervalles_Cents: TCorrection);
Var
  Ix: Integer;
Begin
  For Ix := 0 to 11 do Begin
    Q_Intervalles_Unites_MIDI[Ix] :=
      Q_Intervalles_Cents[Ix] * Etendue_Pitch_Unites / Etendue_Pitch_Cents + Etendue_Pitch_Unites div 2;
    Q_Intervalles_MIDI_LSB_MSB[Ix, 1] := 0;
    Q_Intervalles_MIDI_LSB_MSB[Ix, 2] := $E0;
    Q_Intervalles_MIDI_LSB_MSB[Ix, 3] := Round(Q_Intervalles_Unites_MIDI[Ix]) mod 128;
    Q_Intervalles_MIDI_LSB_MSB[Ix, 4] := Round(Q_Intervalles_Unites_MIDI[Ix]) div 128;
  End;
End;

Function TempereNote(Note, Canal: Byte): TTempereNote;
{ renvoie la commande MIDI de 4 octets 0, $E0+canal, LSB, MSB }
Var
  Index: Integer;
Begin
  Index := (Note * 7 + 3) mod 12; { n de note MIDI => Index tableau Q_... }
  Result := Q_Intervalles_MIDI_LSB_MSB[Index];
  Result[2] := Result[2] or Pred(Canal);
End;

Procedure EtenduePitch(EnCents, EnUnites: Word);
Begin
  Etendue_Pitch_Cents := EnCents;
  Etendue_Pitch_Unites := EnUnites;
End;

initialization
  { ici, paramtres de ma carte son;
   remplacer plus tard par des entres dans le futur fichier INI, modifiables par menu par l'utilisateur }
  { pour ma carte son, units MIDI = cents * 40.96 + 8192 }
  { ou peut-tre par l'envoi de commandes appropries pour dfinir l'tendue du pitch }
  Etendue_Pitch_Cents := 400; { + ou - deux 1/2 tons }
  Etendue_Pitch_Unites := 128*128; { 7 bits MSB et 7 bits LSB reconnus }

  { 12 quintes - 7 octaves }
  Comma_Pythagoricien := 1200 * Ln(Exp(12*Ln(3/2)) / Exp(7*Ln(2))) / Ln(2);
  { 4 quintes - 2 octaves - une tierce majeure }
  Comma_Syntonique := 1200*( 4 * Ln(3/2)/Ln(2) - 2 - Ln(5/4)/Ln(2) );
end.
