unit ULecture;
{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}


{L'objet TChaineSource a pour seul but
  de lire un fichier au format HTML-Zarlino,
  et d'en extraire les donnes  placer dans
  une TGridZarlino, descendant de TStringGrid}
interface

Uses comctrls, Grids, Classes;

Type

  TChaineSource = Class(TObject)
    Memo : TRichEdit;
    DTable, FTable,
    DCaption, FCaption,
    DTemps, FTemps : integer;
    DVoix : Array[0..23] of integer;
    FVoix : Array[0..23] of integer;
    Constructor Create(Source : TRichEdit);
    Procedure Free;
    Function Peuple(Grille : TStringGrid) : boolean ;
    end;

implementation

Uses SysUtils, Windows, Dialogs, Forms, UInterface;

Constructor TChaineSource.Create(Source : TRichEdit);
Begin
Inherited Create;
Memo := Source;
end;

Procedure TChaineSource.Free;
Begin
Memo.Clear;
inherited Free;
end;

Function TChaineSource.Peuple(Grille : TStringGrid) : Boolean;
const
  Vide = [];
var
  D, F,
  DVoix, FVoix,
  iCol : integer;
  Caption, Chaine : String;
  LTotale : integer;
  coeff : real;

Begin
Result := False;
With Memo do
  Begin

  // longueur, jauge
  LTotale := length(Text);
  FInterface.PAvancement.Width := 1;
  Coeff := Finterface.Jauge.Width / LTotale;

  //Tempo, instrument
  Chaine := '';
  D := FindText('<DT>Tempo<DD>', 0, LTotale, Vide);
  inc(D, 14);
  if D > -1 then
    While Text[D] in ['0'..'9'] do
      Begin
      Chaine := Chaine + Text[D];
      inc(D);
      FInterface.TrackBarTempo.Position := StrToInt(Chaine);
      FInterface.TrackBarTempoChange(nil);
      end;

  Chaine := '';
  D := FindText('<DT>Instrument<DD>', 0, LTotale, Vide);
  inc(D, 19);
  if D > -1 then
    While Text[D] in ['0'..'9'] do
      Begin
      Chaine := Chaine + Text[D];
      inc(D);
      FInterface.NumEditInstr.Valeur := StrToInt(Chaine);
      end;

  // Chercher les dbuts et fin de balisage
  DTable := FindText( '<Table', 0, LTotale, Vide);
  FTable := FindText( '</Table', DTable, LTotale - DTable, vide);

  // Signature
  if (FindText('Zarlini', 0, DTable, Vide) < 0)
     and
     (MessageDlg( 'Signature introuvable. Continuer ?',
                 mtWarning, [mbYes, mbNo], 0) = TmodalResult(7))
     then exit;


  DCaption := FindText( '<Caption', DTable, FTable - DTable, vide);
  if DCaption > -1 then
    Begin
      FCaption := FindText( '</Caption', DCaption, FTable - DCaption, vide);
      D := DCaption;
      While Text[D] <> '>' do inc(D);
      inc(D);
      Caption := Copy(Text, D, FCaption - D + 1);
      FInterface.FenetreActive.LCaption.Clear;
      FInterface.FenetreActive.LCaption.Text := Caption;
    end
    else
    Begin
    FCaption := DTable;
    FInterface.FenetreActive.LCaption.Clear;
    FInterface.FenetreActive.LCaption.Lines.Add('mesure inconnue');
    end;

  // Dures
  DTemps := FindText( 'TR', FCaption, FTable - FCaption, vide);
  FTemps := FindText('/TR', DTemps, FTable - DTemps, vide);
  Grille.ColCount := 1;
  Grille.RowCount := 1;
  F := succ(DTemps);
  While True do
    begin
    D := FindText('<Th', F, FTemps - F, vide);
    if D < 0 then break;
    D := FindText('>', D, FTemps - D, vide);

    // jauge d'avancement
      FInterface.PAvancement.Width := round(coeff * D);

    F := FindText('</Th', D + 1, FTemps - D, vide);
    Grille.ColCount := Grille.ColCount + 1;
    Grille.Cells[Grille.ColCount - 2, 0] := Copy(Text, D + 2, F - D - 1);
    end;

  // voix
  FVoix := FindText( '<TR', FTemps, FTable - FTemps, vide);
  Grille.RowCount := 2;
  While true do
    Begin
    DVoix := FindText('<TR', FVoix, FTable - FVoix, vide);
    if DVoix < 0 then break;
    FVoix := FindText('</TR', DVoix, FTable - DVoix, vide);
    // notes
    F := DVoix;
    iCol := 0;
    While True do
      begin
      D := FindText('<TD', F, FVoix - F, vide);
      D := FindText('>', D, FVoix -D, vide);
      if D < 0 then break;
      F := FindText('</TD', D, FVoix - D, vide);
      Grille.Cells[iCol, Grille.RowCount - 1] := Copy(Text, D + 2, F - D - 1);
      inc(iCol);
      
      // jauge d'avancement
      FInterface.PAvancement.Width := round(coeff * D);
      end;
    Grille.RowCount := Grille.RowCount + 1;
    end;
  end;
With Grille do
  Begin
  RowCount := Grille.RowCount - 1;
  ColCount := Grille.ColCount - 1 ;
  // Align := alClient;
  Show;
  end;
Grille.UpDate;
Result := True;
end;


end.
