{$Define Debug}
unit ULectMidi;
{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}

interface

Uses
  Windows, SysUtils, Dialogs, Grids, UMidi, UEvtMidi;

Procedure PeupleAvecFichier(Var SG: TStringGrid; NomFichierMidi: ShortString; Var Resolution: Integer);

implementation

{$IfDef Debug}
// uses UIntfLec;
{$EndIf}

Procedure PeupleAvecFichier(Var SG: TStringGrid; NomFichierMidi: ShortString; Var Resolution: Integer);
Var
  LecteurMidi: TLecteurMidi;
  IxCol, Ix, Gamme, DeltaPrecedent, DeltaReduit, DeltaR, uDelta: Integer;
  GammePrecedente: Array[1..16] of ShortInt;
  EtatOff: Array[1..16] of Boolean;
  l_Note: TNotes;
  CSC, Recommencer: Boolean;

  Function CompleterSilencesColonne: Boolean;
  Var
    Ix, n: Integer;
  Begin
    Result := False;
    n := 0;
    For Ix := 1 to Pred(SG.RowCount) do
      If SG.Cells[IxCol, Ix] = '' Then Inc(n);
    If n < Pred(SG.RowCount) Then Begin
      For Ix := 1 to Pred(SG.RowCount) do
        If SG.Cells[IxCol, Ix] = '' Then Begin
          If EtatOff[Ix] Then
            SG.Cells[IxCol, Ix] := 'S'
          Else
            SG.Cells[IxCol, Ix] := '=';
        End;
      Result := True;
    End;
  End; { CompleterSilencesColonne }

  Procedure AjouterColonne;
  Begin
    IxCol := IxCol + 1;
    SG.ColCount := SG.ColCount + 1;
  End; { AjouterColonne }

  Function EnTete(Canal: Byte): ShortString;
  Var n, d, p: Integer;
  Begin
    n := DeltaReduit * uDelta;
    d := LecteurMidi.UniteDelta;
    { simplification de la fraction n/d }
    p := 2;
    Repeat
      If (n div p = n / p) and (d div p = d / p) Then Begin
        n := n div p;
        d := d div p;
      End Else
        Inc(p);
    Until (p > n) or (p > d);
    If d = 1 Then
      Result := IntToStr(n)
    Else
      Result := IntToStr(n) + '/' + IntToStr(d);
    Recommencer := (d > 32) and (Abs(n-d) = 1);
  End; { EnTete }

  Procedure Initialiser_uDelta;
  { ajustement automatique de la rsolution }
  Begin
    While LecteurMidi.UniteDelta mod Resolution <> 0 do Resolution := Resolution shr 1;
    uDelta := 0;
    While uDelta = 0 do Begin
      Resolution := Resolution shr 1;
      uDelta := LecteurMidi.UniteDelta div Resolution; { 1 = noire, 2 = croche etc. }
    End;
  End; { Initialiser_uDelta }

Begin { PeupleAvecFichier }
  If (SG = Nil) Then EXIT;
  LecteurMidi := TLecteurMidi.Create(NomFichierMidi);


{$IfDef Debug}
//  Form1.Memo1.Visible := True;
//  Form1.Memo1.Enabled := True;
//  ListeNote.NotesEnMemo(Form1.Memo1);
{$EndIf}

  With SG do Begin
    Resolution := Resolution shl 1;
    Initialiser_uDelta;
    Recommencer := True;
    While Recommencer do Begin
      For Ix := 1 to 16 do Begin
        GammePrecedente[Ix] := -10; { improbable }
        EtatOff[Ix] := True;
      End;
      RowCount := 1;
      ColCount := 1;
      IxCol := 0;
      DeltaPrecedent := 0;
      Recommencer := False;
      For Ix := 0 to Pred(ListeNote.Count) do With ListeNote.Notes(Ix) do  If EvenementNote Then Begin
        DeltaReduit := (DeltaTime + Pred(uDelta)) div uDelta;
        DeltaR := DeltaReduit;
        DeltaReduit := DeltaReduit - DeltaPrecedent;
        DeltaPrecedent := DeltaR;
        l_Note := TNotes(Note mod 12);
        Gamme := Note div 12 - 2;
        If Canal > Pred(RowCount) Then RowCount := Succ(Canal); { ici canal va de 1  16 }
        If OnOff Then Begin
          If DeltaReduit <> 0 Then Begin
            CSC := CompleterSilencesColonne;
            SG.Cells[IxCol, 0] := EnTete(Canal);
            If CSC Then AjouterColonne;
          End;
          If Gamme = GammePrecedente[Canal] Then
            SG.Cells[IxCol, Canal] := NotesLettres[l_Note]
          Else
            SG.Cells[IxCol, Canal] := IntToStr(Gamme) + NotesLettres[l_Note];
          EtatOff[Canal] := False;
        End Else Begin { note off }
          If DeltaReduit <> 0 Then Begin
            SG.Cells[IxCol, 0] := Entete(Canal);
            If SG.Cells[IxCol, Canal] = '' Then SG.Cells[IxCol, Canal] := '=';
            If CompleterSilencesColonne Then AjouterColonne;
          End;
          EtatOff[Canal] := True;
        End;
        GammePrecedente[Canal] := Gamme;
        If Recommencer Then Begin
          Initialiser_uDelta;
          BREAK;
        End;
      End;
    End; { While Recommencer }
    SG.ColCount := SG.ColCount - 1;
  End;
  LecteurMidi.Free;
End; { PeupleAvecFichier }

end.
