{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}

unit UInterface;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Grids, ComCtrls, StdCtrls, MPlayer,
  ExtCtrls, Buttons, ClipBrd, checklst, NumEdit, GridZarlino,
  UConsort, UMidi, UGrille ;

const
  VersionI = '1.0.4.2';

type
  TFInterface = class(TForm)
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    Musique1: TMenuItem;
    Aide1: TMenuItem;
    Ouvrir1: TMenuItem;
    Nouveau1: TMenuItem;
    Enregistrer1: TMenuItem;
    Enregistrersous1: TMenuItem;
    Quitter1: TMenuItem;
    Apropos1: TMenuItem;
    StatusBar: TStatusBar;
    OpenDialog: TOpenDialog;
    RichEditInvisible: TRichEdit;
    PCommande: TPanel;
    TrackBarTempo: TTrackBar;
    SpeedButtonJoue: TSpeedButton;
    SpeedButtonStop: TSpeedButton;
    SpeedButtonPrec: TSpeedButton;
    Timer1: TTimer;
    SpeedButtonDebut: TSpeedButton;
    SpeedButtonSuiv: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    SaveDialog: TSaveDialog;
    ajouter1: TMenuItem;
    insrer1: TMenuItem;
    temps1: TMenuItem;
    voix1: TMenuItem;
    temps2: TMenuItem;
    voix2: TMenuItem;
    supprimer1: TMenuItem;
    temps3: TMenuItem;
    voix3: TMenuItem;
    BoutonPi: TSpeedButton;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    MIDI1: TMenuItem;
    Ouvrir2: TMenuItem;
    Enregistrer2: TMenuItem;
    DSauveMidi: TSaveDialog;
    LGlissando: TLabel;
    SpeedButtonInvisible: TSpeedButton;
    plusieurs1: TMenuItem;
    N2: TMenuItem;
    signedanslescellulesvides1: TMenuItem;
    rsoudrelescolonnes1: TMenuItem;
    jauge: TPanel;
    Pavancement: TPanel;
    Sommaire1: TMenuItem;
    Thorie1: TMenuItem;
    Pratique1: TMenuItem;
    Syntaxe1: TMenuItem;
    Index1: TMenuItem;
    N1: TMenuItem;
    vrifierlasyntaxe1: TMenuItem;
    Fentres1: TMenuItem;
    toutrduire1: TMenuItem;
    Fermer1: TMenuItem;
    ToutFermer1: TMenuItem;
    N3: TMenuItem;
    cascade1: TMenuItem;
    mosaque1: TMenuItem;
    rorganiserlesicnes1: TMenuItem;
    NumEditGliss: TNumEdit;
    NumEditInstr: TNumEdit;
    Options1: TMenuItem;
    Barredoutilsddition1: TMenuItem;
    extensionzrl1: TMenuItem;
    tlcommandes1: TMenuItem;
    note1: TMenuItem;
    note2: TMenuItem;
    dize1: TMenuItem;
    bmol1: TMenuItem;
    comma1: TMenuItem;
    comma2: TMenuItem;
    OpenDialogMIDI: TOpenDialog;
    procedure Ouvrir1Click(Sender: TObject);
    procedure Quitter1Click(Sender: TObject);
    procedure Nouveau1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MAJMenu(Sender: TObject);
    procedure SpeedButtonJoueClick(Sender: TObject);
    procedure TrackBarTempoChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SpeedButtonStopClick(Sender: TObject);
    procedure SpeedButtonDebutClick(Sender: TObject);
    procedure SpeedButtonSuivClick(Sender: TObject);
    procedure Mesure1Click(Sender: TObject);
    procedure NumEditInstrChange(Sender: TObject);
    procedure Enregistrersous1Click(Sender: TObject);
    procedure SpeedButtonPrecClick(Sender: TObject);
    procedure Apropos1Click(Sender: TObject);
    procedure Enregistrer1Click(Sender: TObject);
    procedure voix1Click(Sender: TObject);
    procedure temps2Click(Sender: TObject);
    procedure voix2Click(Sender: TObject);
    procedure temps3Click(Sender: TObject);
    procedure voix3Click(Sender: TObject);
    procedure BoutonPiClick(Sender: TObject);
    procedure LCaptionChange(Sender: TObject);
    procedure Ouvrir2Click(Sender: TObject);
    Procedure Mesure(var Num, Den : byte);
    procedure Enregistrer2Click(Sender: TObject);
    procedure NumEditGlissChange(Sender: TObject);
    procedure signedanslescellulesvides1Click(Sender: TObject);
    procedure plusieurs1Click(Sender: TObject);
    procedure rsoudrelescolonnes1Click(Sender: TObject);
    procedure Index1Click(Sender: TObject);
    procedure Sommaire1Click(Sender: TObject);
    procedure Thorie1Click(Sender: TObject);
    procedure Syntaxe1Click(Sender: TObject);
    procedure Pratique1Click(Sender: TObject);
    procedure vrifierlasyntaxe1Click(Sender: TObject);
    procedure toutrduire1Click(Sender: TObject);
    procedure Fermer1Click(Sender: TObject);
    procedure ToutFermer1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cascade1Click(Sender: TObject);
    procedure mosaque1Click(Sender: TObject);
    procedure rorganiserlesicnes1Click(Sender: TObject);
    procedure extensionzrl1Click(Sender: TObject);
    procedure Barredoutilsddition1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure note1Click(Sender: TObject);
    procedure note2Click(Sender: TObject);
    procedure dize1Click(Sender: TObject);
    procedure comma1Click(Sender: TObject);
    procedure comma2Click(Sender: TObject);
    procedure bmol1Click(Sender: TObject);

  private
    { Dclarations prives }
    Ouverture : Boolean;
    // procedure ChequeJeu;
    Procedure Sauver(Sender : TObject);
  public
    { Dclarations publiques }
    ImportationActive : Boolean;
    Function Consort : TConsort;
    Function FenetreActive : TFGrille;
    Procedure AfficheAide(Sender : TObject);
  end;

var
  FInterface: TFInterface;

implementation

{$R *.DFM}

Uses IniFiles, Registry, UTempereNote, ULecture, APropos,
     UVxCol, UOutils, UImportMIDI, ULectMIDI;

procedure TFInterface.Ouvrir1Click(Sender: TObject);
var
  ChaineSource : TChaineSource;
  FGrille : TFGrille;
begin
With OpenDialog do
  if (Sender = nil) or Execute then
    Begin
     // A rajouter ventuellement : arrter le jeu de la fentre active.
     // ...

      // 1. Lecture
      RichEditInvisible.Lines.LoadFromFile(FileName);

      // rcuprer le contenu dans une TChaineSource.
      ChaineSource := TChaineSource.Create(RichEditInvisible);

      // Peupler la grille avec la ChaineSource,
      Jauge.Show;
      Screen.Cursor := crHourGlass;
      Refresh;

      // crer une nouvelle fentre enfant ;
      FGrille := TFGrille.Create(Self);

      if ChaineSource.Peuple( FGrille.Grille ) then
        FGrille.ChequeJeu;
      TrackBarTempoChange(Nil);
      Consort.Modified := False;
      ChaineSource.Free;
    end;
  Jauge.Hide;
  Screen.Cursor := crDefault;
end;

procedure TFInterface.Quitter1Click(Sender: TObject);
begin
Close;
end;

procedure TFInterface.Nouveau1Click(Sender: TObject);
var FGrille : TFGrille;
begin
// Dialogue d'Ajout : voix et lignes
With DVxCol do
  Begin
  Caption := 'Nouvelle tablature';
  ShowModal;
  if ModalResult <> mrOK then exit;
  end;

// crer une instance de TFGrille;
FGrille := TFGrille.Create(Self);
FGrille.Consort.Modified := true;

// Rinitialiser la grille
With FGrille, FGrille.Grille do
  begin
  Caption := 'SansNom';
  FileName := Caption;
  RowCount := Succ(DVxCol.NumEditVx.Valeur);
  ColCount := DVxCol.NumEditCols.Valeur;
  ChequeJeu;
  Show;
  end;
end;

procedure TFInterface.FormCreate(Sender: TObject);
var
  IniFile : TIniFile;
begin
  With Application do
    Begin
      ShowHint := true;
      OnHint := AfficheAide;
      HelpFile := ChangeFileExt(Paramstr(0), '.hlp');
      Screen.OnActiveFormChange := MAJMenu;
      IniFile := TIniFile.Create(ChangeFileExt(ExeName, '.ini'));
    end;
  With IniFile do
    Begin
      OpenDialog.InitialDir := ReadString('Rpertoires', 'Dernier', 'C:\Temp');
      NumEditInstr.Valeur := ReadInteger('Midi', 'instrument', 0);
      ImportationActive := ReadBool('Midi', 'importation', false);
      Top := ReadInteger('Fentre', 'Haut', Top);
      Left := ReadInteger('Fentre', 'Gauche', Left);
      Height := ReadInteger('Fentre', 'Hauteur', Height);
      Width := ReadInteger('Fentre', 'Largeur', Width);
      // lecture des options
      if Not ReadBool('Options', 'installes', false)
        then
          Begin
          // dsactivation de la ligne menu zrl
          extensionzrl1.Checked := False;
          // ractivation et association
          extensionzrl1Click(Sender);
          // enregistrement de l'installation
          WriteBool('Options', 'installes', True);
          end;
      Barredoutilsddition1.Checked :=
        ReadBool('Options', 'Barre d''outils', true);
      extensionzrl1.Checked :=
        ReadBool('Options', 'zrl', true);
      // rajouter ventuellement : lecture de l'historique
      // ...
    end;

    // Tester l'tat du priphrique MIDI
    if Midi.Etat <> 0 then
      Begin
      ShowMessage( 'Le priphrique MIDI est occup ou inutilisable. ' +
                   'Relancez Zarlino une fois le problme rsolu');
      Application.Terminate;
      end;

  Ouverture := True;
end;

procedure TFInterface.FormClose(Sender: TObject; var Action: TCloseAction);
var
  IniFile : TIniFile;
begin
  IniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  With IniFile do
    Begin
    With OpenDialog do if FileName <> '' then
      WriteString('Rpertoires', 'Dernier', ExtractFilePath(FileName));
    WriteInteger('Midi', 'instrument', NumEditInstr.valeur);
    WriteBool('Midi', 'importation', ImportationActive);

    // fentre
    WriteInteger('Fentre', 'Haut', Top);
    WriteInteger('Fentre', 'Gauche', Left);
    WriteInteger('Fentre', 'Hauteur', Height);
    WriteInteger('Fentre', 'Largeur', Width);

    //Options
    WriteBool('Options', 'Barre d''outils', Barredoutilsddition1.Checked);
    WriteBool('Options', 'zrl', extensionzrl1.Checked);
    end;
    Application.HelpCommand(HELP_Quit, 0);
end;

Function TFInterface.FenetreActive : TFGrille;
Begin
Result := TFGrille(ActiveMDIChild);
end;

Function TFInterface.Consort : TConsort;
Begin
  if ActiveMDIChild <> nil then
    Result := TFGrille(ActiveMDIChild).Consort
    else Result := nil;
end;

procedure TFInterface.MAJMenu(Sender: TObject);
begin
  Fermer1.Enabled := MDIChildCount > 0;
  ToutFermer1.Enabled := MDIChildCount > 0;

  Enregistrer1.Enabled := MDIChildCount > 0;
  Enregistrersous1.Enabled := MDIChildCount > 0;
  Cascade1.Enabled := MDIChildCount > 0;
  mosaque1.Enabled := MDIChildCount > 0;
  rorganiserlesicnes1.Enabled := MDIChildCount > 0;
  toutrduire1.Enabled := MDIChildCount > 0;
  Enregistrer2.Enabled := MDIChildCount > 0;

  Musique1.Enabled := MDiChildCount > 0;
end;


procedure TFInterface.SpeedButtonJoueClick(Sender: TObject);
begin
if (Consort = nil) then exit;
NumEditInstrChange(nil);
// TrackBarTempoChange(nil);
NumEditGlissChange(Sender);
With Consort do
  Begin
  if not Valide or not CalculsAJour then
    CalculeCellules(False);
  PasAPas := False;
  EnableTimer;
  JoueCol(PosTps);
  end;
end;

procedure TFInterface.TrackBarTempoChange(Sender: TObject);
begin
if Consort <> nil then With TrackBarTempo do
  Begin
  Consort.Tempo := 10 * (succ(Max) - Position);
  Label1.Caption := 'T ' + IntToStr(60000 div Consort.Tempo);
  Label1.Left := left + Position - 40;
  Consort.Modified := true;
  end;
end;

procedure TFInterface.Timer1Timer(Sender: TObject);
begin
With Consort do
  Begin
  if Not PasAPas then JoueColSuivante;
  end;
end;

procedure TFInterface.SpeedButtonStopClick(Sender: TObject);
begin
if Consort = nil then exit;
Consort.Stop;
end;


procedure TFInterface.SpeedButtonDebutClick(Sender: TObject);
begin           
if Consort = nil then exit;
Consort.Reprise;
With FenetreActive do
  Label3.Caption := intToStr(succ(Grille.Col)) + ' tacet';
end;


procedure TFInterface.SpeedButtonSuivClick(Sender: TObject);
begin
SpeedButtoninvisible.down := true;
if Consort = nil then exit;
NumEditGlissChange(SpeedButtonSuiv);
With Consort do
  Begin
  if Not CalculsAJour or Not Valide then
    CalculeCellules(False);
  PasAPas := True;
  DisableTimer;
  EstEditable(False);
  JoueCol(PosTps);
  if PosTps < Pred(Grille.ColCount) then inc(PosTps);
  end;
end;

procedure TFInterface.Mesure1Click(Sender: TObject);
begin
// Ajouter une colonne
With FenetreActive do
  Begin
  if Grille = nil then exit;
  With Grille do ColCount := ColCount + 1;
  With Consort do
    Begin
    CalculsAJour := False;
    Modified := true;
    Valide := False;
    end;
  ChequeJeu;
  end;
end;

procedure TFInterface.NumEditInstrChange(Sender: TObject);
begin
if Consort <> nil Then consort.ChangeInstrument(NumEditInstr.Valeur);
end;

Procedure TFInterface.Sauver(Sender : TObject);
var
  Texte : TStringList;
begin
With FenetreActive do
  Begin
  if (Consort = nil ) or
     ((Sender = Enregistrer1) and (not (Consort.Modified)))
     then exit;
  SaveDialog.FileName := FileName;
  SaveDialog.InitialDir := Chemin;

  if ((Sender = Enregistrersous1) or (FileName = 'SansNom'))
    and not SaveDialog.Execute then exit;

  // appeler Une StringList depuis ULecture
  if LCaption.Lines[0] <> '' then
    Consort.Caption := LCaption.Lines[0];
  Texte := Consort.SortieHTML;

  With SaveDialog do
    if pos('.', FileName) = 0 then
      Begin
        if FilterIndex = 1 then FileName := FileName + '.zrl'
        else FileName := FileName + '.html';
      end;

  // la Sauvegarder dans le mme fichier.
  Texte.SaveToFile(SaveDialog.FileName);
  Texte.Free;

  FileName := ExtractFileName(SaveDialog.FileName);
  Chemin := ExtractFilePath(Savedialog.FileName);
  Caption := 'Zarlino - ' + FileName;
  Consort.Modified := false;
  end;
end;

procedure TFInterface.Enregistrersous1Click(Sender: TObject);
begin
if (Consort = nil ) then exit;
With SaveDialog do
  Begin
  if Sender = EnregistrerSous1 then
      Title := 'Enregistrer sous'
      else title := 'Enregistrer';

  // Avertissement : perte d'informations ?
  if (Pos('.htm', ExtractFileExt(FenetreActive.Filename)) = 1) and
     (MessageDlg( 'Les donnes trangres  la musique seront perdues. Continuer ?'
                 , mtWarning, [mbYes, mbNo], 0) = mrNo) then exit;
    Sauver(Enregistrersous1);
  end;

end;

procedure TFInterface.Enregistrer1Click(Sender: TObject);
begin
if FenetreActive.FileName = 'SansNom' then
  EnregistrerSous1Click(Enregistrer1)
  else Sauver(Enregistrer1);
end;



procedure TFInterface.SpeedButtonPrecClick(Sender: TObject);
begin
// colonne prcdente
SpeedButtoninvisible.down := true;
if Consort = nil then exit;
With Consort do
  if PosTPs > 0 then
  Begin
  PasAPas := True;
  dec(PosTps);
  Consort.EstEditable(False);
  if Not CalculsAJour or not Valide then
    CalculeCellules(False);
  JoueCol(PosTps);
  end;
end;

procedure TFInterface.Apropos1Click(Sender: TObject);
begin
With FAPropos do
  Begin
  LVersionMIDI.Caption := VersionMidi;
  LVersionInterf.Caption := VersionI;
  ShowModal;
  end;
end;

procedure TFInterface.voix1Click(Sender: TObject);
begin
With FenetreActive do
  Begin
  if (Grille = nil) or (Grille.RowCount > 16) then exit;
  With Grille do RowCount := RowCount + 1;
  NumEditInstrChange(nil);
  With Consort do
    Begin
    CalculsAJour := False;
    Modified := true;
    Valide := False;
    end;
  ChequeJeu;
  end;
end;

procedure TFInterface.temps2Click(Sender: TObject);
var
  iCol, iLigne : integer;
begin
// insrer une colonne avant la colonne slectionne
With FenetreActive do
  Begin
  if Grille = nil then exit;
  With Grille do
    Begin
    ColCount := succ(ColCount);
    For iCol := pred(ColCount) downto succ(Selection.Left) do
      For iLigne := 0 to pred(RowCount) do
      Cells[iCol, iLigne] := Cells[pred(iCol), iLigne];
    For iLigne := 0 to pred(RowCount) do
      Cells[Col, iLigne] := '';
    end;
  With Consort do
    Begin
    CalculsAJour := False;
    Modified := true;
    Valide := False;
    end;
  ChequeJeu;
  end;
end;

procedure TFInterface.voix2Click(Sender: TObject);
var
  iCol, iLigne : integer;
begin
// insrer une voix avant la ligne slectionne
With FenetreActive do
  Begin
  if (Grille = nil) or (Grille.RowCount > 16) then exit;
  With Grille do
    Begin
    if Row = 0 then Row := 1;
    RowCount := succ(RowCount);
    For iLigne := pred(RowCount) downto succ(Row) do
      For iCol := 0 to pred(ColCount) do
      Cells[iCol, iLigne] := Cells[iCol, Pred(iLigne)];
    For iCol := 0 to pred(ColCount) do
      Cells[iCol, Row] := '';
    end;
  With Consort do
    Begin
    CalculsAJour := False;
    Modified := true;
    Valide := False;
    end;
  ChequeJeu;
  end;
end;

procedure TFInterface.temps3Click(Sender: TObject);
var
  iCol, iLigne : integer;
begin
// supprimer un temps
With FenetreActive do
  Begin
  if Grille = nil then exit;
  With Grille do
    Begin
      For iCol := Selection.Left to ColCount - 2 do
        For iLigne := 0 to RowCount - 1 do
          Cells[iCol, iLigne] := Cells[succ(iCol), iLigne];
      ColCount := pred(ColCount);
    end;
  With Consort do
    begin
    Modified := true;
    CalculsAJour := False;
    if PosTps >= Grille.ColCount then dec(PosTps);
    end;
  ChequeJeu;
  end;
end;

procedure TFInterface.voix3Click(Sender: TObject);
var
  iCol, iLigne : integer;
begin
// supprimer une Ligne;
With FenetreActive do
  Begin
  if Grille = nil then exit;
  With Grille do
    Begin
      if RowCount <= 2 then exit;
      if Selection.Top = 0 then Row := Row + 1;
      For iLigne := Selection.Top to RowCount - 2 do
        For iCol := 0 to ColCount - 2 do
          Cells[iCol, iLigne] := Cells[iCol, succ(iLigne)];
      RowCount := pred(RowCount);
    end;
  Consort.Modified := true;
  Consort.CalculsAJour := False;
  ChequeJeu;
  end;
end;

procedure TFInterface.BoutonPiClick(Sender: TObject);
begin
if Consort = nil then exit;
Consort.Pythagore := BoutonPi.Down;
Consort.CalculeCellules(False);
end;

procedure TFInterface.LCaptionChange(Sender: TObject);
begin
if Consort <> nil then Consort.Modified := true;
end;

procedure TFInterface.Ouvrir2Click(Sender: TObject);
var FGrille : TFGrille;
begin
if not ImportationActive then
  Begin
  // ouvrir la page d'aide correspondante
  Application.HelpCommand(HELP_CONTEXT, 1016);
  exit;
  end;
With DImportMidi do
  Begin
  ShowModal;
  if ModalResult <> mrOK then exit;
  if OpenDialogMidi.Execute then
    Begin
      // crer une fentre MDI
      FGrille := TFGrille.Create(Self);
      FGrille.Consort.Modified := true;

      LBResolutionClick(Nil); { rsolution maximale }
      PeupleAvecFichier(TStringGrid(FGrille.Grille), OpenDialogMidi.FileName, Resolution);
      { mise  jour ventuelle de la listbox rsolution }
      LBResolution.ItemIndex := 0;
      While Resolution > 1 do Begin
        Resolution := Resolution shr 1;
        LBResolution.ItemIndex := LBResolution.ItemIndex + 1;
      end;
    end else exit;
  end;

// Rinitialiser la grille
With FGrille, FGrille.Grille do
  begin
  Caption := ExtractFileName(ChangeFileExt(OpenDialogMidi.Filename, '.zrl'));
  FileName := Caption;
  With TrackBarTempo do Position := 100;
  TrackBarTempoChange(Nil);
  ChequeJeu;
  Show;
  end;
end;

Procedure TFInterface.Mesure(var Num, Den : byte);
{ Num = Numrateur, Den = dnominateur des indications de mesure
  dans la ligne d'dition sous le menu
  Si la mesure n'est pas lisible, 2/2 par dfaut}
var
  Texte : string;
  PBarre : byte;
Begin
Num := 2;
Den := 2;
Texte := FenetreActive.LCaption.Lines[0];
For PBarre := 1 to length(texte) do
  if not (Texte[PBarre] in ['0'..'9', '/']) then
     System.Delete(Texte, PBarre, 1);
PBarre := Pos('/', Texte);
if PBarre = 0 then exit;
Num := StrToInt(copy(Texte, 1, pred(Pbarre)));
Den := StrToInt(copy(Texte, succ(PBarre), 2));
end;

procedure TFInterface.Enregistrer2Click(Sender: TObject);
var
  Num, Den : byte;
  EnregistreurMidi : TEnregistreurMidi;
begin
if Consort = nil then exit;
// rinitialiser le dialogue :
With DSauveMidi do
  Begin
  // rpertoire
  InitialDir := FenetreActive.Chemin;

  // et nom de fichier
  FileName := ChangeFileExt(FenetreActive.FileName, '.mid');

  // tester le rsultat
  if not Execute then exit;

  // crer une instance de Enregistreur Midi
  Mesure(Num, Den);
  if Consort.Tempo = 0 then Consort.Tempo := 60; // viter la division par zro
  EnregistreurMidi := TEnregistreurMidi.Create(
    FileName, Num, Den, Round(60000 div Consort.Tempo));

  // Ajouter l'intrument et les notes
  Consort.PeupleMidi(EnregistreurMidi, NumEditInstr.Valeur);

  // enregistrer;
  EnregistreurMidi.EnregistrerFichierMidi;

  EnregistreurMidi.Free;
  // message d'enregistrement.
  ShowMessage(FileName + ' enregistr');
  end;
end;

procedure TFInterface.AfficheAide(Sender: TObject);
begin
  Statusbar.SimpleText := GetLongHint(Application.Hint);
end;

procedure TFInterface.NumEditGlissChange(Sender: TObject);
begin
// intervient sur la variable increment_glissando;
increment_glissando := NumEditGliss.valeur / 100;
end;

procedure TFInterface.signedanslescellulesvides1Click(Sender: TObject);
var ligne, colonne : integer;
begin
// crit '=' dans toutes les cellules vides
  With FenetreActive.Grille do
  for colonne := 0 to ColCount - 1 do
    for ligne :=  1 to RowCount - 1 do
    if Cells[colonne, ligne] = '' then
       Cells[colonne, ligne] := '=';
end;

procedure TFInterface.plusieurs1Click(Sender: TObject);
begin
// appeler le dialogue voix/colonnes en changeant la Caption;
With DVxCol, FenetreActive, Consort do
  begin
  DVxCol.Caption := 'Ajout de lignes et de colonnes';
  if Sender = plusieurs1 then
    begin
    NumEditCols.ValeurMin := 0;
    NumEditVx.ValeurMin := 0;
    NumEditCols.Valeur := 0;
    NumEditVx.Valeur := 0;
    end;
  DVxCol.ShowModal;
  if (DvxCol.ModalResult = mrOK) and (Sender = plusieurs1) then
    With FenetreActive, Consort do
      Begin
      Grille.RowCount := Grille.RowCount + NumEditVx.Valeur;
      Grille.ColCount := Grille.ColCount + NumEditCols.Valeur;
      CalculsAJour := False;
      Modified := true;
      Valide := False;
      ChequeJeu;
      end;
  NumEditCols.ValeurMin := 1;
  NumEditVx.ValeurMin := 1;
  end;
end;

procedure TFInterface.rsoudrelescolonnes1Click(Sender: TObject);
begin
// rsoudre les colonnes o toutes les lignes ont =
if Consort <> nil then Consort.Resoudre;
end;

procedure TFInterface.Index1Click(Sender: TObject);
begin
// aide : index
Application.HelpCommand(HELP_FINDER, 0);
end;

procedure TFInterface.Sommaire1Click(Sender: TObject);
begin
// aide : sommaire
Application.HelpCommand(HELP_CONTENTS, 1000);
end;

procedure TFInterface.Thorie1Click(Sender: TObject);
begin
// aide : thorie
Application.HelpCommand(HELP_CONTEXT, 1010);
end;

procedure TFInterface.Syntaxe1Click(Sender: TObject);
begin
// aide : syntaxe
Application.HelpCommand(HELP_CONTEXT, 1005);
end;

procedure TFInterface.Pratique1Click(Sender: TObject);
begin
// aide : pratique
Application.HelpCommand(HELP_CONTEXT, 1011);
end;

procedure TFInterface.vrifierlasyntaxe1Click(Sender: TObject);
begin
// vrification de la syntaxe
if Consort <> nil
  then consort.CalculeCellules(True);
end;

procedure TFInterface.toutrduire1Click(Sender: TObject);
var i : integer;
begin
  // minimiser toutes les fentres enfants
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TFInterface.Fermer1Click(Sender: TObject);
begin
  if (ActiveMDIChild <> nil)
    then ActiveMDIChild.Close;
end;

procedure TFInterface.ToutFermer1Click(Sender: TObject);
Var
  i : integer;
begin
For i := MDIChildCount - 1 downto 0 do
  MDIChildren[i].Close;
end;

procedure TFInterface.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TFInterface.cascade1Click(Sender: TObject);
begin
  cascade;
end;

procedure TFInterface.mosaque1Click(Sender: TObject);
begin
  tile;
end;

procedure TFInterface.rorganiserlesicnes1Click(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TFInterface.extensionzrl1Click(Sender: TObject);
var Reg : TReginiFile;
begin
extensionzrl1.Checked := not extensionzrl1.Checked;
if Extensionzrl1.Checked then
  Begin
    Reg := TRegIniFile.Create('');
    // TRegIniFile s'utilise comme TIniFile ( unit Regitry )
    Try
      Reg.RootKey := hkey_classes_root;
      Reg.WriteString('.zrl', '', 'ZarlinoFile'); // pointeur vers la description
      Reg.WriteString('ZarlinoFile', '', 'Tablature Zarlino'); // type des fichiers dans l'explorateur
      Reg.WriteString('ZarlinoFile\DefaultIcon', '', ParamStr(0)); // icne des fichiers dans l'explorateur
      Reg.WriteString('ZarlinoFile\shell\open\command', '',
        ParamStr(0) + ' %1'); // association programme
    Finally
     Reg.Free;
     End;
  end
  else
  Begin
    Reg := TRegIniFile.Create('');
    Try
      Reg.RootKey := hkey_classes_root;
      Reg.EraseSection('ZarlinoFile');
      Reg.EraseSection('.zrl');
    Finally
     Reg.Free;
    End;
  end;
end;

procedure TFInterface.Barredoutilsddition1Click(Sender: TObject);
begin
Barredoutilsddition1.Checked := not Barredoutilsddition1.Checked;
BarreDOutils.Visible := Barredoutilsddition1.Checked;
end;

procedure TFInterface.FormActivate(Sender: TObject);
begin
if Ouverture then
  Begin
   // examen du paramtre 1
  if ParamCount > 0 then With FInterface do
    Begin
    OpenDialog.FileName := Paramstr(1);
    Ouvrir1Click(nil);
    end;
  BarreDOutils.Visible := Barredoutilsddition1.Checked;
  Ouverture := False;
  end;
end;

   {*********** six raccourcis de la barre d'outils flottante **********
           repris dans l'option de menu invisible 'tlcommandes'   }

procedure TFInterface.note1Click(Sender: TObject);
begin
if FenetreActive <> nil
  then Consort.Conjoint(True);
end;

procedure TFInterface.note2Click(Sender: TObject);
begin
if FenetreActive <> nil
  then Consort.Conjoint(False);
end;

procedure TFInterface.dize1Click(Sender: TObject);
begin
  if FenetreActive <> nil then Consort.dieze;
end;

procedure TFInterface.bmol1Click(Sender: TObject);
begin
  if FenetreActive <> nil then Consort.BMol;
end;

procedure TFInterface.comma1Click(Sender: TObject);
begin
  if FenetreActive <> nil then Consort.Comma(true);
end;

procedure TFInterface.comma2Click(Sender: TObject);
begin
  if FenetreActive <> nil then Consort.Comma(False);
end;

end.

