unit UGrille;
{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, GridZarlino, ULecture, UConsort, StdCtrls, ComCtrls, checklst,
  ExtCtrls;

type
  TFGrille = class(TForm)
    Grille: TGridZarlino;
    Panel1: TPanel;
    Label3: TLabel;
    ChequeMuti: TCheckListBox;
    LCaption: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ChequeMutiClick(Sender: TObject);
    procedure GrilleKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure GrilleClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    Consort : TConsort;
    FileName, Chemin : String;
    Procedure ChequeJeu;
  end;

implementation

{$R *.DFM}
uses UInterface, UMidi;

procedure TFGrille.FormCreate(Sender: TObject);
begin
  Chemin := ExtractFilePath(FInterface.OpenDialog.FileName);
  if Sender = FInterface.Nouveau1 then
    FileName := 'SansNom'
    else
    FileName := ExtractFileName(FInterface.OpenDialog.FileName);
  Caption := 'Zarlino - '+FileName;
  Grille.Align := alClient;
  ChequeMuti.ItemHeight := Grille.DefaultRowHeight + 1;
  Consort := Nil;
end;

procedure TFGrille.FormActivate(Sender: TObject);
begin
 // seulement si Consort <> nil
 if Consort = nil then
   Begin
   // Instancier un Objet TConsort avec la Grille
   Consort := TConsort.Create(
        Grille,
        LCaption.Lines[0],
        FInterface.NumEditInstr.Valeur,
        FInterFace.Timer1);
   FInterface.BoutonPi.Down := False;
   Consort.Reprise;
   end
   else with FInterface do
   Begin
   NumEditGlissChange(self);
   With TrackBarTempo do
      Position := succ(Max) - round(Consort.Tempo / 10);
   TrackBarTempoChange(self);
   NumEditInstrChange(self);
   Consort.CalculeCellules(false);
   end;
end;

Procedure TFGrille.ChequeJeu;
var iCoche : integer;
Begin
With ChequeMuti.Items do
  Begin
  For iCoche := 0 to Grille.rowCount - 2 do
      if iCoche > count - 1
      then Add(intToStr(succ(iCoche)));
  While count + 1 > Grille.RowCount do
     Delete(Count - 1);
  end;
ChequeMuti.ItemIndex := -1;
ClientHeight :=
  Label3.height + 
  Grille.DefaultRowHeight * succ(Grille.Rowcount);
end;

procedure TFGrille.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Consort.Stop;
  Action := caFree;
end;

procedure TFGrille.ChequeMutiClick(Sender: TObject);   
var iVoix : byte;
begin
if Consort = nil then exit;
For iVoix := 1 to Grille.RowCount-1 do
  Begin
  Consort.Muti[iVoix] := ChequeMuti.Checked[pred(iVoix)];
  if ChequeMuti.Checked[pred(iVoix)] then
    Midi.AllNoteOff(iVoix);
  end;
ChequeMuti.ItemIndex := -1;
ChequeJeu;
end;

procedure TFGrille.GrilleKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
With Consort do
  begin
  Stop;
  Modified := True;
  CalculsAJour := False;
  Valide := False;
  PosTps := Grille.Col;
  end;
Label3.Caption := IntToStr(succ(Grille.Col)) + ' tacet';
end;

procedure TFGrille.GrilleClick(Sender: TObject);
begin
Label3.Caption := IntToStr(succ(Grille.Col)) + ' tacet';
Consort.PosTps := Grille.Col;
end;

procedure TFGrille.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
if Consort.Modified then
  Case
   MessageDlg('Enregistrer la tablature ' + FileName +
     ' avant de quitter ?',
        mtWarning, [mbYes, mbNo, mbCancel], 0) of
        mrYes : FInterface.Enregistrer1Click(Sender);
        mrCancel : CanClose := False;
        end;
end;

end.
