unit UEvtMidi;

interface

Uses
	SysUtils, Classes, StdCtrls, Forms;

Const
  TypeTexte: Array[1..7] of String[17] =
    ('Texte ', 'Copyright notice ', 'Nom: ', 'Instrument: ', 'Chant', 'Marqueur: ', 'Cue point');
  MineurMajeur: Array[False..True] of Char = ('M', 'm');
  Tonalite: Array[-7..10] of String[4] =
    ('Dob', 'Solb', 'Rb', 'Lab', 'Mib', 'Sib', 'Fa', 'Do', 'Sol', 'R', 'La', 'Mi', 'Si', 'Fa#', 'Do#', 'Sol#', 'R#', 'La#');
  NomNote: Array[0..11] of String[4] = ('do', 'do#', 'r', 'r#', 'mi', 'fa', 'fa#', 'sol', 'sol#', 'la', 'la#', 'si');

	K32 = 32767;

type
  TBuffer = Array[0..K32] of Byte;
	Buff = Array[0..32767] of Byte;
  TPtBuff = ^Buff;
	TEvtNote = Class(TObject)
  	DeltaTime: LongInt;
    Canal, Note, Velocite: Byte;
		OnOff, EvenementNote: Boolean;
  End;

  TListeNote = Class(TList)
  	MasterDelta: Array[0..15] of LongInt;
    Constructor Create;
    Procedure Free;
  	Procedure AjouterNote(Delta: LongInt; Piste, Hauteur, Velo: Byte; OnOf, EvtNote: Boolean);
    Function Notes(Ix: Integer): TEvtNote;
    Procedure NotesEnMemo(Memo: TMemo);
    Procedure Trier;
		procedure QuickSort(iLo, iHi: LongInt);
  End;

Var
	ListeNote: TListeNote;

implementation

Function NomDeLaNote(Note: Byte): String;
Begin
  Result := NomNote[Note mod 12] + ' ' + IntToStr(Note div 12 - 2);
End;

Constructor TListeNote.Create;
Var
	Ix: Integer;
Begin
	inHerited Create;
  For Ix := 0 to 15 do MasterDelta[Ix] := 0;
End;

Procedure TListeNote.Free;
Var
	Ix: Integer;
Begin
  For Ix := Pred(Count) downto 0 do Notes(Ix).Free;
  inherited free;
End;

Function TListeNote.Notes(Ix: Integer): TEvtNote;
Begin
	Result := TEvtNote(Items[Ix]);
End;

Procedure TListeNote.AjouterNote(Delta: LongInt; Piste, Hauteur, Velo: Byte; OnOf, EvtNote: Boolean);
Var
	Ix: Integer;
Begin
  If (Piste < 1) or (Piste > 16) Then Begin
    Piste := 1;
  End;
	Ix := Add(TEvtNote.Create);
  With Notes(Ix) do Begin
    MasterDelta[Piste] := MasterDelta[Piste] + Delta;
  	DeltaTime := MasterDelta[Piste];
    Canal := Piste;
    Note := Hauteur;
    Velocite := Velo;
		OnOff := OnOf;
    EvenementNote := EvtNote;
  End;
End;

Procedure TListeNote.NotesEnMemo(Memo: TMemo);
Var
	Ix: Integer;
  S, Sa: String;
Begin
	Memo.Clear;
	For Ix := 0 to Pred(Count) do With Notes(Ix) do Begin
  	Str(DeltaTime:12, S);
    Str(Canal, Sa);
    If Length(Sa) < 2 Then Sa := '0' + Sa;
		S := 'C' + Sa + S;
		If OnOff Then S := S + '  On ' Else S := S + ' Off ';
    S := S + NomDeLaNote(Note);
    Memo.Lines.Add(S);
    Application.ProcessMessages;
  End;
End;

procedure TListeNote.QuickSort(iLo, iHi: LongInt);
var
  Lo, Hi, Mid: LongInt;
begin
  Lo := iLo;
  Hi := iHi;
  Mid := Notes((Lo + Hi) div 2).DeltaTime;
  repeat
    while Notes(Lo).DeltaTime < Mid do Inc(Lo);
    while Notes(Hi).DeltaTime > Mid do Dec(Hi);
    if Lo <= Hi then begin
      Exchange(Lo, Hi);
      Inc(Lo);
      Dec(Hi);
    end;
  until Lo > Hi;
  if Hi > iLo then QuickSort(iLo, Hi);
  if Lo < iHi then QuickSort(Lo, iHi);
end;

Procedure TListeNote.Trier;
Begin
	QuickSort(0, Pred(Count));
End;

end.
