unit UConsort;
{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}

{Unit trs importante, le cur de Zarlino. Deux Objets principaux :
  TConsort est charg de lire les donnes de la tablature et de les stocker
  dans un tableau de TCellule. Il doit aussi pouvoir crer en sortie un fichier
  HTML-Zarlino qui stockera toutes les donnes de la tablature. Il peut enfin
  envoyer  TEnregistreurMidi les donnes qui lui permettront de crer et
  d'enregistrer un fichier au format MIDI qui sonnera comme la tablature
  en mode jeu. 
  TCellule,  partir des donnes dont il dispose, peut envoyer des ordres
   l'objet Midi : TMidi, dont les sources sont dans UMidi.}
interface

uses SysUtils, Forms, Classes, Grids, extctrls, Dialogs,
     UMidi, UTempereNote;

Type

TCorrection_lettre = Array['A'..'G'] of real;

TTableau_Corrections = Array[1..16] of real; // sert pour les glissandi

TCellule = class(TObject)
  precedente : TCellule;
  tacet,
  liee,
  tilde,
  glissando : Boolean;
  Ligne, Colonne : integer;
  note : TNotes;
  Octave,
  Ecart_Octave_Temp : integer;
  MaCorrection : Real;
  attaque : byte;
  erreur : string;
  Constructor Create(
    Pr : TCellule;
    L, C : integer;
    Texte : String);
  Function Calcule(Grille : TStringGrid ; Pythagore : Boolean) : Boolean;
  Procedure Joue;
  Procedure AfficheErreur;
  end;

TConsort = class(TObject)
  Grille : TStringGrid;
  Caption : String;
  Octaves : Array[1..16] of integer;
  // Correction : TCorrection; En variable globale de l'unit
  PosTps : integer;
  Timer : TTimer;
  Tempo : integer;
  PasAPas,
  Modified, CalculsAJour,
  Valide,
  Pythagore : Boolean;
  ErreurX, ErreurY : integer;
  Muti : Array[1..16] of Boolean;
  Constructor Create( G : TStringGrid ;
                      C : String;
                      Instr : byte ;
                      Tmer : TTimer) ;
  Procedure Free;
  Function Cellule(L, C : integer) : TCellule;
  Function CelluleActive : TCellule;
  Procedure EnableTimer;
  Procedure DisableTimer;
  Procedure Selectionne(L, C : integer);
  Procedure EstEditable(vrai : Boolean);
  Procedure JoueCol(C : integer);
  Procedure MAJCellules;
  Procedure Resoudre;
  Procedure CalculeCellules(Verifier : Boolean);
  Function  Duree(C : integer ; DMidi : Boolean) : real;
  Procedure JoueColSuivante;
  Procedure Stop;
  Procedure Reprise;
  Procedure ChangeInstrument(instr : integer);
  Function  SortieHTML : TStringList;
  Procedure PeupleMidi(Enregistreur : TEnregistreurMidi; Instr : integer);
  Procedure Glisse(C : integer);
  Procedure Conjoint(Plus : Boolean);
  Procedure Dieze;
  Procedure BMol;
  Procedure Comma(Plus : Boolean);
  Procedure UnPas(Avant : Boolean);
  Procedure ChangeVoix(Haut : Boolean);
  Procedure ChangeOctave(Haut : Boolean);
  end;

Const
  DureeMidi = True;
  DureeConsort = False;

Var
  // Consort : TConsort; // Maintenant dans chaque fiche enfant
  Apotome : double ;
  DemiTon_pythagoricien ,
  Ton_pythagoricien : double;
  Correction : TCorrection ;
  CorrLettre : TCorrection_Lettre;
  Increment_glissando : real;

implementation

Uses UInterface;

Function Trime(T : string) : String;
    var i : integer;
Begin
  Result := '';
  for i := 1 to length(T) do
    Case T[i] of
      '=', '0'..'9', 'A'..'G', 'b', 'S', '#', '+', '-', '~' :
        Result := Result + T[i];
      end;
end; // Trime

Procedure InitFraction(T : string ; var Num, Den : integer);
var PosBarre : integer;
    i : integer;
    D : String;
Begin

Num := 1;
Den := 1;

// nettoyer;
  D := '';
  For i := 1 to length(T) do
    if T[i] in ['0'..'9', '/'] then
      D := D + T[i];

if D = '' then exit;

  // recherche de /
  PosBarre := Pos('/', D);

  // numrateur
  if PosBarre = 0 then Num := StrToInt(D)
    else Num := StrToInt(Copy(D, 1, pred(PosBarre)));

  // dnominateur
  if PosBarre = 0 then Den := 1
    else
      Try
      Den := StrToInt(Copy(D, succ(PosBarre), length(D)));
      except
      Den := 1;
      end;
end;

Procedure Simplifie(var N, D : integer);
// Simplifie une fraction de numrateur N et de dnominateur D.
  const
     premiers : array[0..26] of integer =
     (2,  3,  5,  7,  11, 13, 17, 19, 23,
      29, 31, 37, 41, 43, 47, 53, 57, 59,
      61, 67, 71, 73, 79, 83, 91, 97, 101);
  var
     i : integer ;
  Begin
     i := 0;
     While (i <= high(premiers)) and
     (premiers[i] <= abs(N)) and
     (premiers[i] <= D) do
     begin
        if (N mod premiers[i] = 0)
        and (D mod premiers[i] = 0)
        then
        begin
           N := N div premiers[i];
           D := D div premiers[i];
        end
        else inc (i);
     end;
  if N = 0 then D := 1;
  end; {Simplifie}




{ Function CharToNote(C : Char) : TNotes;
    //  utiliser pour le dveloppement;
    Begin
    Case C of
      'A' : Result := la;
      'B' : Result := si;
      'C' : Result := ut;
      'D' : Result := re;
      'E' : Result := mi;
      'F' : Result := fa;
      'G' : Result := sol;
      end;
    end; }

 {Function NotetoChar(N : TNotes) : Char;
    //  utiliser pour le dveloppement;
    Begin
    Case N of
      la : Result := 'A';
      si : Result := 'B';
      ut : Result := 'C';
      re : Result := 'D';
      mi : Result := 'E';
      fa : Result := 'F';
      sol: Result := 'G';
      end;
    end;}

// 
//  TCellule 
// 

  Constructor TCellule.Create(
                 Pr : TCellule;
                 L, C : integer;
                 Texte : String) ;
    Begin
    Inherited Create;
    liee := false;
    Precedente := Pr;
    Ligne := L;
    Colonne := C;
    Octave := 0;
    MaCorrection := 0;
    attaque := 64;
    note := la;
    erreur := '';
    end;

  Function TCellule.Calcule(Grille : TStringGrid ; Pythagore : Boolean) : Boolean;
    var
        NoteTrouvee : Boolean;
        Texte : string;
  Begin
  Result := True;
  NoteTrouvee := False;  
  Erreur := '';
  Texte := Trime(Grille.Cells[colonne, ligne]);
  
  if Texte = '' then
    Begin
    Result := false;
    erreur := 'Aucune indication dans la cellule.';
    end;

  {ces deux lignes corrigent automatiquement les cellules dont le texte contient
  des erreurs de syntaxe. L'option ne parat pas utile pour l'instant.}
  // if CorrectionAuto then
  //   Grille.Cells[colonne, ligne] := Texte;

  Tacet := False;
  Ecart_octave_temp := 0;
  if Precedente <> nil then Octave := Precedente.Octave
    else Octave := 3;

  // "S" ou cellule vide, interprte comme S.
  Tacet := (Texte = '') or ( pos('S', Texte ) > 0);
  if  Tacet then exit;

   // tilde
   Tilde := Texte[length(Texte)] = '~';
   if Tilde then
     Delete(Texte, Length(Texte), 1);

   Liee := Pos('=', Texte) > 0;
   if Liee and (precedente <> nil) and
      Precedente.Tacet then
      Begin
      // tenir compte d'un = domin par une cellule S
      Tacet := true;
      exit;
      end;

   if Liee or glissando then
     Begin
     Note := Precedente.Note;
     Octave := Precedente.Octave;
     Ecart_Octave_Temp := Precedente.Ecart_Octave_Temp;
     if not glissando then
       Begin
       MaCorrection := Precedente.MaCorrection;
       exit;
       end;
     end;

  While Texte <> '' do
    begin

    // Trouver l'Octave;
    if Texte[1] in ['0'..'9'] then
      Begin
      Octave := StrToInt(Texte[1]);
      delete(Texte, 1, 1);
      Continue;
      end;

    // destruction des ~ surnumraires;
    if Texte[1] = '~' then
      Begin
        result := false;
        erreur := '~ surnumraire';
        Delete(Texte, 1, 1);
      end;

    // Lecture de la lettre;
    if Texte[1] in ['A'..'G'] then
      Begin
        if NoteTrouvee then
          Begin
          result := false;
          erreur := 'Note exprime plusieurs fois';
          end
          else
          Begin
            NoteTrouvee := true;
            MaCorrection := CorrLettre[Texte[1]];
          end;
        Delete(Texte, 1, 1);
        Continue;
      end;

    {2- Lecture des # et des b
     et ajout ou retranchement des apotomes de 113,6850061 cents}
    Case Texte[1]  of
     '#' :
        Begin
        MaCorrection := MaCorrection + Apotome;
        System.Delete(Texte, 1, 1);
        Continue;
        end;
     'b' :
        Begin
        MaCorrection := MaCorrection - Apotome;
        system.delete(Texte, 1, 1);
        Continue;
        end;
      end;

   {3- Correction syntoniques (+ ou - un certain nombre de commas syntoniques
       de 21,5062896 cents}
     if (Texte[1] in ['-', '+']) then
      Begin
      if not Pythagore then
        Try
          MaCorrection :=
              MaCorrection + Comma_syntonique * StrToInt(Texte);
          except
          result := false;
          erreur := ' correction mal exprime';
          MaCorrection := 0;
          end;
      Texte := '';
      end;
    end; {While}

  if Not NoteTrouvee then
    Begin
    Result := false;
    Erreur := 'Note non trouve';
    Note := si;
    MaCorrection := 160000;
    end;

    {5- "remise  l'octave"
     Aussi longtemps que t >= 1500, on enlve 1200 et on prend note qu'il faudra
     lever le rsultat final d'une octave, ceci en boucle, plusieurs fois si
     ncessaire.}
  Ecart_Octave_Temp := 1 ;
  While MaCorrection >= 1500  do
    Begin
    MaCorrection := MaCorrection - 1200;
    inc(Ecart_Octave_temp);
    end;
  {Aussi longtemps que t < 300, on ajoute 1200 et on prend note qu'il faudra
   abaisser le rsultat final d'une octave, ceci en boucle, plusieurs fois si
   ncessaire.}
  While MaCorrection < 300 do
    Begin
    MaCorrection := MaCorrection + 1200;
    dec(Ecart_Octave_temp);
    end;

  { On calcule partie_entire(z/100) pour obtenir la "touche de piano" :
       14	si
       13	la#
       12	la
       11	sol#
       10	sol
       9	fa#
       8	fa
       7	mi
       6	r#
       5	r
       4	do#
       3	do }

  Case Trunc(MaCorrection / 100) of
      14 : Note := si;
      13 : Note := ladiese;
      12 : Note := la;
      11 : Note := soldiese;
      10 : Note := sol;
      9  : Note := fadiese;
      8  : Note := fa;
      7  : Note := mi;
      6 : Note := rediese;
      5 : Note := re;
      4 : Note := utdiese;
      3 : Note := ut;
      end;

  { La correction en cents (toujours positive) est donne
    par la formule suivante :
    z - (partie_entire(z/100)*100).
    Cette fois, je suis presque sr de mon fait...}
  maCorrection := maCorrection - trunc(maCorrection/100)*100;

  // rattraper les correction > 50 cents;
  if maCorrection > 50 then
    Begin
    if note = si then
      Begin
      note := ut;
      inc(Ecart_Octave_Temp);
      end else inc(note);
    maCorrection := -(100 - maCorrection);
    end;

  // glissando
   glissando := (precedente <> nil) and precedente.Tilde;
   if glissando and
     ((note <> precedente.note) or
      (MaCorrection = precedente.MaCorrection)) then
      Begin
      Result := false;
      Erreur := 'glissando mal employ';
      end;

  end; // Calcule

  Procedure TCellule.Joue;
  Begin
  if Liee then exit;
  if glissando then
     Begin
       if increment_glissando = 0 then
         Begin
         Midi.Diapason(Ligne, MaCorrection)
         end;
     end
     else
     Begin
     Midi.AllNoteOff(Ligne);
     if not Tacet then
       Midi.NoteOn(Ligne, Note, Octave + Ecart_Octave_Temp, Attaque, MaCorrection);
     end;
  end;

  Procedure TCellule.AfficheErreur;
  Begin
  ShowMessage(Erreur);
  end;



// 
//  TConsort 
// 

Constructor TConsort.Create( G : TStringGrid ;
                             C : String ;
                             Instr : byte ;
                             Tmer : TTimer );
var iO,
    Linea, columna : integer;
    Pr : TCellule;
Begin
inherited Create;
Grille := G;
Caption := C;
Timer := Tmer;

// instrument
ChangeInstrument(instr);

PosTps := 0;
PasAPas := False;
CalculsAJour := False;

// initialisation des voix muettes
For iO := 1 to 16 do muti[iO] := False;

Pythagore := False;

Pr := nil;
With Grille do
  For Linea := 1 to Grille.RowCount - 1 do
    For Columna := 0 to Grille.colCount - 1 do
      Begin
      if Columna > 0 then pr := Cellule(linea, pred(columna));
      Grille.Objects[Columna, Linea] :=
        TCellule.Create(Pr, Linea, Columna, Cells[Columna, Linea]);
      end;
end;

Procedure TConsort.Free;
var
  C, L : integer ;
Begin
if Self = nil then exit;
With Grille do
  For C := 0 to ColCount - 1 do
    For L := 0 to RowCount - 1 do
      Begin
      Cells[C, L] := '';
      Cellule(L, C).Free;
      end;
inherited Free;      
end;

Function TConsort.Cellule(L, C : integer) : TCellule;
Begin
Result := TCellule(Grille.Objects[C, L]);
end;

Function TConsort.CelluleActive : TCellule;
Begin
With Grille do result := Cellule(Col, Row);
end;

Procedure TConsort.ChangeInstrument(instr : integer);
var i : integer;
Begin
For i := 0 to Grille.RowCount - 1 do
  Midi.ProgramChange(i, Instr);
end;

Procedure TConsort.EnableTimer;
Begin
Timer.Enabled := True;
end;

Procedure TConsort.DisableTimer;
Begin
Timer.Enabled := False;
end;

Procedure TConsort.Selectionne(L, C : integer);
var
  Sel : TGridRect;
Begin
with Sel do
  begin
  if L = -1 then
    Begin
    Top := 0;
    Bottom := Grille.RowCount - 1;
    end
    else
    Begin
    Top := L;
    Bottom := L;
    end;
  Left := C ;
  Right := C ;
  end;
Grille.Selection := Sel;
end;

Procedure TConsort.Glisse(C : integer);
var
  i : integer;
  termine : Boolean;
  descente : array[1..16] of Boolean;
  glissandi : array[1..16] of Boolean;
  CorrectionsD, CorrectionsF : TTableau_Corrections;
Begin
// pas de glissando dans la premire colonne
if C = 0 then exit;

//Etablir le tableau des glissandi de la colonne
For i := 1 to Grille.Rowcount-1 do
    begin
    if not Cellule(i, C).glissando or
      (increment_glissando = 0) then Glissandi[i] := false
      else
      Begin
        Glissandi[i] := true;
        correctionsD[i] := Cellule(i, C).Precedente.MaCorrection;
        correctionsF[i] := Cellule(i, C).MaCorrection;
        descente[i] := CorrectionsF[i] < CorrectionsD[i];
      end;
    end;

// jouer en ajustant selon le pas
Termine := False;
While not Termine do
  Begin
  Termine := true;
  For i := 1 to Grille.RowCount - 1 do
    if Glissandi[i] then
      Begin
      if descente[i] then
        Begin
        if CorrectionsD[i] > CorrectionsF[i] then
          Begin
          CorrectionsD[i] := CorrectionsD[i] - increment_glissando;
          Midi.Diapason(i, correctionsD[i]);
          Termine := Termine and False;
          end
          else
          Begin
          Midi.Diapason(i, CorrectionsF[i]);
          Termine := Termine and true;
          end;
        end
        else
        Begin
        if CorrectionsD[i] < CorrectionsF[i] then
          Begin
          CorrectionsD[i] := CorrectionsD[i] + increment_glissando;
          Midi.Diapason(i, correctionsD[i]);
          Termine := Termine and false;
          end
          else
          Begin
          Midi.Diapason(i, CorrectionsF[i]);
          Termine := Termine and true;
          end;
        end;
      end
      else Termine := Termine and true;
  end;
end;

Procedure TConsort.EstEditable(vrai : Boolean);
Begin
With Grille do if vrai then
  Options := Options + [goEditing] else
  Options := Options - [goEditing];
end;

Procedure TConsort.JoueCol(C : integer);
var
  Ligne : integer;
Begin
// Slection de la colonne
EstEditable(False);
Grille.Col := C;
Selectionne(-1, C);
Application.ProcessMessages;

With Grille do
  begin
    With Timer do
      Begin
      interval := Round(Duree(C, DureeConsort)); // (Cells[C, 0]);
      end;
    if
      C >= LeftCol + VisibleColCount Then LeftCol := LeftCol + 1
      else if
      (C <= LeftCol) and (C > 0) Then LeftCol := LeftCol - 1;

    // Notes
    For Ligne := 1 to RowCount -1 do
      if not muti[Ligne] then Cellule(ligne, C).Joue;
  UpDate;
  end;
  Glisse(C);
end;

Procedure TConsort.MAJCellules;
var
  linea, columna : integer;
  Pr : TCellule;
Begin
  Pr := nil;
  With Grille do
    For Linea := 1 to Grille.RowCount - 1 do
      For Columna := 0 to Grille.colCount - 1 do
        Begin
          if Columna > 0 then pr := Cellule(linea, pred(columna));
          if Cellule(linea, columna) = nil then
            Grille.Objects[Columna, Linea] :=
              TCellule.Create(Pr, Linea, Columna, Cells[Columna, Linea]);
        end;
end;

Function TConsort.Duree(C : integer ; DMidi : Boolean) : real;
var
  Num, Den : integer;
  Begin
  // Calculer Numrateur et dnominateur
  InitFraction(Grille.Cells[C, 0], Num, Den);
  Result := Tempo * Num/Den ;
  if DMidi then result := (Num / Den)
end;

Procedure TConsort.Resoudre;
var
  iCol, iLigne,
  jCol, jLigne : integer;
  egal : Boolean;
  NumPr, Num,
  DenPr, Den : integer;
Begin
// ajouter  la prcdente une colonne o toutes les lignes ont =;
iCol := 0;
With Grille do
  While ICol < ColCount - 1 do //1 parce que pas de prcdente pour 0
    Begin
    egal := True;
    For ILigne := 1 to RowCount - 1 do
      // voir si toutes les lignes ont =
      egal := egal and (Trime(Cells[ICol, ILigne][1]) = '=');
    if egal then
      Begin
      // c'est le cas :
      // Mettre le texte des 2 colonnes en fractions
      InitFraction(Cells[pred(ICol), 0], NumPr, DenPr);
      InitFraction(Cells[ICol, 0], Num, Den);

      // Additionner Dures;
      NumPr := NumPr*Den + Num  * DenPr;
      DenPr := DenPr * Den;
      Simplifie(NumPr, DenPr);

      // Mettre  jour Colonne prcdente;
      if DenPr = 1 then Cells[pred(ICol), 0] := IntToStr(NumPr)
        else
        Cells[pred(ICol), 0] := IntToStr(NumPr)+'/'+IntToStr(DenPr);

      // supprimer la colonne inutile
      For jCol := Icol to ColCount - 2 do
        For jLigne := 0 to RowCount - 1 do
          Cells[jCol, jLigne] := Cells[succ(jCol), jLigne];
      ColCount := pred(ColCount);
      end
      else inc(ICol);
    end;
end;

Procedure TConsort.CalculeCellules(verifier : Boolean);
var Linea, Columna : integer;
Begin
MAJCellules;
Valide := true;
With Grille do
  For Linea := 1 to Pred(RowCount) do
    For Columna := 0 to Pred(ColCount) do
       With   Cellule(Linea, Columna) do
       if not Calcule(Grille, Pythagore)
        then
          Begin
          Valide := False;
          CalculsAJour := False;
          if verifier then
            Begin
              Selectionne(Ligne, Colonne);
              LeftCol := Colonne;
              AfficheErreur;
            end;
          end
        else CalculsAJour := True;
end;

Procedure TConsort.JoueColSuivante;
Begin
if PosTps < Grille.ColCount - 1 then
  Begin
  inc(PosTps);
  JoueCol(PosTps);
  end
  else stop;
end;

Procedure TConsort.Stop;
var i : integer;
begin
For i := 0 to 16 do Midi.AllNoteOff(i);
DisableTimer;
{ Un peu os pour l'encapsulation, mais permet d'optenir le
  retout du bouton de jeu en vitant un message. Si tu trouves mieux... }
FInterface.SpeedButtonInvisible.Down := true;
EstEditable(True);
end;

Procedure TConsort.Reprise;
Begin
Stop;
PosTps := 0;
With Grille do
  Begin
  LeftCol := 0;
  Col := 0;
  end;
Selectionne(-1, 0);
end;

Function TConsort.SortieHTML : TStringList;
var
  iCol, iVoix : integer;
  Ligne : string;
Begin
Result := TStringList.Create;
With Result do
  begin
  Add('<HTML>');
  Add('<HEAD>');
  Add('<TITLE>Tablature Zarlino</TITLE>');
  Add('<META NAME="Zarlino" CONTENT="Zarlini">');
  // ici on peut ajouter divers paramtres
  Add('</HEAD>');

  add('<BODY>');
  add('<DL>');
  add('<DT>Tempo<DD>' + IntToStr(FInterface.TrackBarTempo.position));
  add('<DT>Instrument<DD>' + IntToStr(FInterface.NumEditInstr.Valeur));
  add('</DL>');
  add('<TABLE WIDTH="100%" BORDER=1>');
  if Caption <> '' then
    add('<CAPTION ALIGN=TOP>' + Caption + '</CAPTION>');

  // Ligne des en-ttes
  Ligne := '<TR>';
  For iCol := 0 to Grille.ColCount -1 do
    Ligne := ligne + '<TH>' + Grille.Cells[iCol, 0] + '</TH>';
  Ligne := Ligne + '</TR>';
  add(Ligne);

  // Lignes des notes
  For iVoix := 1 to Grille.RowCount - 1 do
    Begin
      Ligne := '<TR>';
      For iCol := 0 to Grille.ColCount - 1 do
        Ligne := Ligne + '<TD>' + Grille.Cells[iCol, iVoix] + '</TD>';
      Ligne := Ligne + '</TR>';
      add(Ligne);
    end;

  // fin de fichier
  add('</TABLE>');
  add('</BODY>');
  add('</HTML>');
  end;
end;

Procedure TConsort.PeupleMidi(Enregistreur : TEnregistreurMidi; Instr : integer);
var IVoix, IColonne, iGl : integer;
    CorrectionD, Pas : real;
Begin
CalculeCellules(False); // prcaution en cas de modification sans audition ;
if not Valide and
  (MessageDlg(
    'La tablature a peut-tre des fautes de syntaxe. Enregistrer quand mme ?',
    mtConfirmation,
    [mbYes, mbNo],
    0) = 7 ) then exit; {7 parce que la constante mrNo = 7 est refuse !}

// pour chaque voix;
For IVoix := 1 to Grille.RowCount - 1 do
  Begin
  Enregistreur.EnregistreInstrument(IVoix, Instr);
  For IColonne := 0 to Grille.ColCount - 1 do
    Begin
    With Cellule(iVoix, iColonne), Enregistreur do
       if Tacet then
          EnregistreSilence(IVoix, Duree(iColonne, DureeMidi))
          else
          // si glissando
          if glissando then
            begin
            // calcul de la correction de dpart
            CorrectionD := precedente.MaCorrection;
            Pas := (MaCorrection - CorrectionD) / 8;
            // glisser
            For iGl := 0 to 7 do
              EnregistreNote( IVoix, Note,
                              Octave + ecart_Octave_Temp,
                              attaque,
                              CorrectionD + Pas * iGl, 0.05, true);
            // jouer la note dfinitive, moins longtemps
            EnregistreNote( IVoix, Note,
                            Octave + ecart_Octave_Temp,
                            attaque, MaCorrection,
                            duree(iColonne, DureeMidi) - 0.4, true);
            end
          else
          EnregistreNote(
            Ivoix, // canal
            Note,
            Octave + ecart_Octave_temp,
            attaque,
            maCorrection,
            Duree(iColonne, DureeMidi),
            Liee); // lie
    end;
  end;
end;

// *****************************************************
// Modifications tlcommandes du texte de la Cellule :
// *****************************************************

Procedure TConsort.Conjoint(Plus : Boolean);
var
  Texte : string;
  i : integer;
Begin
With Grille do
  Begin
  Texte := Cells[Col, Row];
  // trouver la note;
  if Texte = '' then
    Begin
    if plus then Texte := 'G' else Texte := 'B';
    end;
  i := 1;
  While (i < length(Texte)) and not (Texte[i] in ['A'..'G']) do inc(i);
  // la modifier
  Try
    if not(Texte[i] in ['A'..'G']) then exit;
    except
    exit;
    end;
  if Plus then
    if Texte[i] = 'G' then Texte[i] := 'A'
      else Texte[i] := succ(Texte[i])
    else
    if Texte[i] = 'A' then Texte[i] := 'G'
      else Texte[i] := pred(Texte[i]);
  Cells[Col, Row] := Texte;
  end;
Modified := True;
end;

Procedure TConsort.Dieze;
var
  Texte : string;
  i : integer;
Begin
With Grille do
  Begin
    Texte := Cells[Col, Row];
    i := pos('b', Texte);
    if i > 0 then
      Begin
        Delete(Texte, i, 1);
      end
    else
      Begin
        // trouver la note;
        i := 1;
        While (i < length(Texte)) and not (Texte[i] in ['A'..'G']) do inc(i);
        // la modifier
        Insert('#', Texte, i+1);
      end;
    Cells[Col, Row] := Texte ;
  end;
Modified := True;
end;

Procedure TConsort.BMol;
var
  Texte : string;
  i : integer;
Begin
With Grille do
  Begin
    Texte := Cells[Col, Row];
    i := pos('#', Texte);
    if i > 0 then
      Begin
        Delete(Texte, i, 1);
      end
    else
      Begin
        // trouver la note;
        i := 1;
        While (i < length(Texte)) and not (Texte[i] in ['A'..'G']) do inc(i);
        // la modifier
        Insert('b', Texte, i+1);
      end;
    Cells[Col, Row] := Texte ;
  end;
Modified := True;
end;

Procedure TConsort.Comma(Plus : Boolean);
var
  Texte : string;
  i : integer;
  tilde : Boolean;
  Signe : integer;
  Valeur : integer;
Begin
With Grille do
  Begin
  Texte := Cells[Col, Row];
  // trouver la note;
  i := length(Texte);
  Try
    tilde := Texte[i] = '~';
    except
    exit;
    end;
  if tilde then delete(Texte, i, 1);
  Signe := Pos('+', Texte);
  if Signe = 0 then
    Signe := Pos('-', Texte);
  if (Signe > 0) then
    Begin
    Try
        valeur := StrToInt(copy(Texte, Signe, i));
      except
        ShowMessage('Impossible d''interprter le texte ' + Texte);
        exit;
      end;
    if plus then inc(valeur) else dec(valeur);
    if valeur = 0 then Texte := Copy(Texte, 1, pred(signe))
      else
       if valeur > 0 then
        Texte := Copy(Texte, 1, pred(signe)) + '+' + intToStr(valeur)
          else
          Texte := Copy(Texte, 1, pred(signe)) + intToStr(valeur) ;
    end
    else
    Begin
      if plus then Texte := Texte + '+1'
        else Texte := Texte + '-1';
    end;
  if Tilde then Texte := Texte + '~';
  Cells[Col, Row] := Texte;
  end;
Modified := True;
end;

Procedure TConsort.UnPas(Avant : Boolean);
Begin
With Grille do
  if Avant then
    Begin
    if (Col < ColCount -1) then Col := Col + 1
    end
  else
  if Col > 0 then Col := Col - 1;
end;

Procedure TConsort.ChangeVoix(Haut : Boolean);
Begin
With Grille do
  if Haut then
    Begin
    if (Row > 1) then Row := Row-1;
    end
  else
  if Row < RowCount - 1 then Row := Row + 1;
end;


Procedure TConsort.ChangeOctave(Haut : Boolean);
var
  Texte : String;
  Octave : integer;
Begin
// monte ou descend l'octave.
With Grille do
  Begin
  Octave := Cellule(Row, Col).Octave;
  if Haut then inc(Octave) else
    if Octave > 1 then dec(Octave);
  Try
    Texte := Cells[Col, Row];
    While Texte[1] in ['0'..'9'] do delete(Texte, 1, 1);
    Texte := intToStr(Octave) + Texte;
    Cells[Col, Row] := Texte;
    CalculeCellules(false);
    Except
    end;
  end;
end;

//****************************************************
//***************  TConsort - fin ********************
//****************************************************

Procedure Initialise_Corrections;
var
  i : integer ;
Begin
For i := 0 to 11 do
  Correction[((i+9) * 7) mod 12] := i * Comma_Pythagoricien / 12;

{Attribution de 0  la lettre A, et d'un nombre en cents aux autres lettres,
selon une chelle diatonique pythagoricienne procdant par tons de 9/8 et
demi-tons de 256/343, soit :

B	203,9100017
A	1200
G	-203,9100017
F	-407,8200035
E	-498,0449991
D	-701,9550009
C	-905,8650026}

corrLettre['B'] := Ton_pythagoricien;
corrLettre['A'] := 0; // 1200;
corrLettre['G'] := - Ton_pythagoricien;
corrLettre['F'] := - Ton_pythagoricien * 2;
corrLettre['E'] := CorrLettre['F'] - DemiTon_pythagoricien;
corrLettre['D'] := CorrLettre['E'] - Ton_pythagoricien;
corrLettre['C'] := CorrLettre['D'] - Ton_pythagoricien;
end;

Initialization

{ l'apotome est l'intervalle pythagoricien
 de sept quintes ramen  une octave }
Apotome := 1200 * ln ( 2187 / 2048 ) / ln ( 2 ) ;

DemiTon_pythagoricien := 1200 * ln(256 / 243 ) / ln ( 2 ) ;
Ton_pythagoricien := 1200 * ln( 9/8 ) / ln ( 2 );

initialise_corrections;
end.
