unit NumEdit;
{ Composant driv de TEdit
  bote d'dition numrique modifiable avec la souris,
  ventuellement entre deux bornes }

{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TNumEdit = class(TEdit)
  private
    { Dclarations prives }
    FValeurMin, FValeurMax, FValeur: Integer;
    YSouris: Integer;
    BoutonSourisEnfonce: Boolean;
    Procedure SetValeur(Value: Integer);
    Procedure SetValeurMin(Value: Integer);
    Procedure SetValeurMax(Value: Integer);
  protected
    { Dclarations protges }
    Procedure Change; override;
  public
    { Dclarations publiques }
    Constructor Create(AOwner: TComponent); override;
  published
    { Dclarations publies }
    property ValeurMin: Integer read FValeurMin write SetValeurMin;
    property ValeurMax: Integer read FValeurMax write SetValeurMax;
    property Valeur: Integer read FValeur write SetValeur;
    Procedure MDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    Procedure MUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    Procedure MMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Exemples', [TNumEdit]);
end;

Constructor TNumEdit.Create(AOwner: TComponent);
Begin
  inherited Create(AOwner);
  OnMouseDown := MDown;
  OnMouseUp := MUp;
  OnMouseMove := MMove;
  ReadOnly := False;
  FValeurMin := 0; { comme dans SpinEdit, si ValeurMin = ValeurMax, pas de test de borne }
  FValeurMax := 0;
  FValeur := 0;
  Text := IntToStr(FValeur);
  width := 35;
End;

Procedure TNumEdit.SetValeur(Value: Integer);
Begin
  FValeur := Value;
  If ValeurMin <> ValeurMax Then { contrle des bornes }
    If Value < ValeurMin Then
      FValeur := ValeurMin
    Else
      If Value > ValeurMax Then FValeur := ValeurMax;
  Text := IntToStr(FValeur);
End;

Procedure TNumEdit.SetValeurMin(Value: Integer);
Begin
  If (Value <= FValeurMax) or (FValeurMin = FValeurMax) Then FValeurMin := Value;
  If FValeurMin <> FValeurMax Then { contrle bornes }
    If Valeur < FValeurMin Then Begin
      Valeur := FValeurMin;
      Text := IntToStr(FValeur);
    End;
End;

Procedure TNumEdit.SetValeurMax(Value: Integer);
Begin
  If (Value >= FValeurMin) or (FValeurMin = FValeurMax) Then FValeurMax := Value;
  If FValeurMin <> FValeurMax Then { contrle bornes }
    If Valeur > FValeurMax Then Begin
      Valeur := FValeurMax;
      Text := IntToStr(FValeur);
    End;
End;

procedure TNumEdit.MDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  BoutonSourisEnfonce := Button = mbLeft;
  If BoutonSourisEnfonce Then YSouris := Y;
end;

procedure TNumEdit.MUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  If Button = mbLeft Then BoutonSourisEnfonce := False;
end;

procedure TNumEdit.MMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  If BoutonSourisEnfonce Then Begin
    Valeur := Valeur + (YSouris - Y);
    YSouris := Y;
  End;
end;

procedure TNumEdit.Change;
Var
  V, Code: Integer;
Begin
  Val(Text, V, Code);
  If Code = 0 Then Valeur := V;
  inherited Change;
End;

end.
