unit GridZarlino;
{Composant  installer, comme NumEdit, pour compiler
 convenablement le projet Zarlino}
{
Zarlino - application permettant d'exprimenter diverses  solutions
dans le domaine de l'intonation juste.
Copyright (C) 1998 Y. Ouvrard, J. P. Vidal, O. Bettens.
Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : zarlino@iname.com
}


interface
   
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   Grids;
   
type

   TGridZarlino = class(TStringGrid)
   private
{ Dclarations prives }
   protected
{ Dclarations protges }
      procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); override;
      procedure KeyPress(var Key: Char); override;
   public
{ Dclarations publiques }
      Constructor Create(AOwner: TComponent); override;
   published
{ Dclarations publies }
   end;

  Procedure Register;

implementation

Procedure Register;
Begin
   RegisterComponents('Exemples', [TGridZarlino]);
end;

Constructor TGridZarlino.Create(AOwner: TComponent);
Begin
   inherited Create(AOwner);
   FixedRows := 0;
   fixedcols := 0;
   Options := Options + [goEditing, goTabs];
end;

procedure TGridZarlino.DrawCell(ACol, ARow: Longint; ARect: TRect;
  AState: TGridDrawState);
Begin
   with Canvas.Font do
      if ARow = 0 then
         Style := [fsBold]
      else
         Style := [];
   inherited DrawCell(ACol, ARow, ARect, AState);
   end;

 procedure TGridZarlino.KeyPress(var Key: Char);
 var L : Char;
     Capitale : Boolean;
 Begin
   case Key of
     'a', 'c'..'g', 's' : Key := UpCase(Key);
     'b' :
       Begin
         Capitale := true;
         for L := 'A' to 'G' do
           if Pos(L, Cells[Col, Row]) > 0 then Capitale := false;
         if Capitale then Key := 'B';
       end;
     end;
 inherited KeyPress(Key);
 end;

end.
