incipit =
#(define-music-function (parser location incipit-music Y-offset) (ly:music? number?)
  #{
    \once \override Staff.InstrumentName #'self-alignment-X = #RIGHT
    \once \override Staff.InstrumentName #'self-alignment-Y = #UP
    \once \override Staff.InstrumentName #'Y-offset =
      #(lambda (grob)
         (+ Y-offset (system-start-text::calc-y-offset grob)))
    \once \override Staff.InstrumentName #'padding = #0.3
    \once \override Staff.InstrumentName #'stencil =
      #(lambda (grob)
         (let* ((instrument-name (ly:grob-property grob 'long-text))
                (layout (ly:output-def-clone (ly:grob-layout grob)))
                (music (make-sequential-music
                        (list (context-spec-music
                               (make-sequential-music
                                (list (make-property-set
                                       'instrumentName instrument-name)
                                      (make-grob-property-set
                                       'VerticalAxisGroup
                                       'Y-extent '(-4 . 4))))
                               'MensuralStaff)
                              incipit-music)))
                (score (ly:make-score music))
                (mm (ly:output-def-lookup layout 'mm))
                (indent (ly:output-def-lookup layout 'indent))
                (width (ly:output-def-lookup layout 'incipit-width))
                (incipit-width (if (number? width)
                                   (* width mm)
                                   (* indent 0.5))))

           (ly:output-def-set-variable! layout 'indent (- indent
                                                          incipit-width))
           (ly:output-def-set-variable! layout 'line-width indent)
           (ly:output-def-set-variable! layout 'ragged-right #f)
           (ly:output-def-set-variable! layout 'ragged-last #f)
           (ly:output-def-set-variable! layout 'system-count 1)
           (ly:score-add-output-def! score layout)
           (ly:grob-set-property! grob 'long-text
                                  (markup #:score score))
           (system-start-text::print grob)))
  #})