#!/usr/bin/php
<?php
$entete ='
\version "2.16.2"
\include "../include/incipit.ily"
\include "../include/variables.ily"

\pointAndClickOff

myStaffSize = #17
#(set-default-paper-size "a4")
#(set-global-staff-size myStaffSize)
\paper {
  
  
  #(define fonts
    (make-pango-font-tree "Linux Libertine O"
                          "Linux Biolinum O"
                          "Luxi Mono"
                           (/ myStaffSize 20)))
  
  print-all-headers = ##t
  %annotate-spacing = ##t
  first-page-number = 1
  print-first-page-number = ##t
  print-page-number = ##t
  left-margin = 1.5\cm
  top-margin = 1\cm
  bottom-margin = 1\cm
  line-width = 18\cm
  ragged-bottom=##f
  ragged-last-bottom=##f
  footnote-separator-markup = ##f
  markup-system-spacing #\'padding = #1
}
\header{
  tagline = ""
}
';

if (! file_exists("partSep")){
  mkdir("partSep"); 
}
$d = dir(".");
while (false !== ($entry = $d->read())){
  if (preg_match("/^[0-9]{3,3}.*\.ly$/", $entry)){
    print $entry . "\n";
    $ff = fopen($entry, 'r');
    $chaine = $entete . fread($ff, filesize($entry));
    $chaine = preg_replace("/\.\.\/include/", "../../include", $chaine);
    fclose($ff);
    $fw = fopen("partSep/" . $entry, 'w');
    fwrite($fw, $chaine);
    fclose($fw);
    passthru("cd partSep; lilypond $entry; cd ..");
  }

}

passthru("cd partSep; rm *.ly; cd ..");
$d->close();


?>