global = {
  #(set-accidental-style 'forget)
  \once \override Staff.Clef #'full-size-change = ##t
  \set Staff.forceClef = ##t
  \set Score.defaultBarType = "empty"
  \time 4/4
  \override Voice.NoteHead #'style = #'baroque
}

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-g" 
      \key f \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      f'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    s4^\markup \small "1" s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    f,4^\markup \small "1b" a g4. \m a8 \me bes4 a2 a4 d2 c r2 g4 a bes2 a4 f a g f2
    s^\markup \small "2" s s4 s2 s4 s2 s e'4 f d2 c4 f f4^\markup \bold "*" e4 f2 r
    c2^\markup \small "3" a d4 c2 a4 bes2 a s4 s s2 s4 s s s s2 s
    s4^\markup \small "4" s s2 s4 s2 s4 s2 s e'4 f d2 c4 f f e f2 r
    c4^\markup \small "5" bes a2 g4 f8 [ \m g a bes ] \me c4 d2 c s4 s s2 s4 s s4 s4 s2 s
    s4^\markup \small "6" s s2 s4 s2 s4 s s s2 c4 a bes2 a4 c d c c2 r
    f4^\markup \small "6r"  e d2 e4 c2 d4 f2 e r e4 f d2 c4 f f e f2^\fermata
    c4^\markup \small "7" a f2 bes a d c s4 s s2 s4 s s4 s4 s2 s
    s4^\markup \small "8" s s2 s4 s2 s4 s2 s bes4 f' d2 c4 bes a g f2 r
    s4^\markup \small "9" s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2
    f4^\markup \small "10" c' a2 a4 bes2 c4 d2 c r e4 f d2 c4 f f4^\markup \bold "*" e4 f2 r
    c4^\markup \small "10r" c bes2 bes4 a2 f4 f2 c' r a4 g g2 e4 c' bes g a2^\fermata
    f4^\markup \small "11" a g4. \m a8 \me bes4 a2 c4 bes8 [ \m c ] d4 \me cis2 s4 s s2 s4 s s s s2 s
    s4^\markup \small "12" s s2 s4 s2 s4 s2 s e4 f d2 c4 c bes bes a2 r
    f4^\markup \small "13" g a2 g^\markup \bold "*" a4^\markup \bold "*" c4 b2 c s4 s s2 s4 s s s s2 s
    s4^\markup \small "14" s s2 s4 s2 s4 s2 s c4 a d2 c4 f f e f2 r
    f,4^\markup \small "15" g a2 a4 bes2 c4 d2 c r d4 e f2 d4 c4^\markup \bold "*" bes4 bes4^\markup \bold "*" a2 r
    bes4^\markup \small "16" c f,2 g4 a2 c4 b2 c s4 s s2 s4 s s s s2 s
    s4^\markup \small "17" s s2 s s4 s s2 s s s4 s s2 s s4 s s2 s
    s4^\markup \small "18" s s2 s4 s2 s4 s2 s s c4 c f2 e4 c d4^\markup \bold "*" c4 a2 r
    f4^\markup \small "19" g a2 f2^\markup \bold "*" g4^\markup \bold "*" a4 bes2 g r a4 bes c2 bes4 a a g a2 r
    a4^\markup \small "20" f c'2 d4 e2 f4 g2 e r s4 s s2 s4 s s s s2 s
    f4^\markup \small "20r" e d2 e4 c2 d4 f2 e r e4 f d2 c4 f f e f2^\fermata
    s4^\markup \small "21" s s2 s s s s e4 f d2 c4 bes a4^\markup \bold "*" g4 f2 r
    f4^\markup \small "22" g a2 f c' f e s4 s s2 s4 s s s s2 s
    s4^\markup \small "23" s s2 s s4 s s2 s e4 f d2 c4 f f e f2 r
    s4^\markup \small "24" s s2 s4 s2 s4 s2 s s4 s s2 s4 s s s s2 s
    c4^\markup \small "24r" c bes2 bes4 a2 f4 f2 c' r a4 g g2 e4 c' bes g a2^\fermata
    c4^\markup \small "25" d e2 c4 d2 e4 f2 e r f4 c c2 d4 c bes bes a2 r
    bes4^\markup \small "26" f8 [ \m g ] \me a [ \m bes ] c4 \me a d2 c4 b2 c r s4 s s 2 s4 s s s s2 s
    s4^\markup \small "27" s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s2
    s4^\markup \small "28" s4 s2 s4 s2 s4 s2 s s g4 a g2 e4 f a c c2 r
    f4^\markup \small "28r" e d2 e4 c2 d4 f2 e r e4 f d2 c4 f f e f2^\fermata
    s4^\markup \small "29" s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4^\markup \small "30" s s2 s4 s2 s4 s2 s s e4 f d2 c4 f f e f2 r
    c4^\markup \small "31" c f2 e4 c2 c4 d2 c s s4 s s2 s4 s s s s2 s
    f2^\markup \small "32" c4. \m d8 \me es4 d2 g4 f2 e r f4 c d2 c4 d c bes a2 r
    d4^\markup \small "33" e f2 f4 e2 c4 d2 e r c4 a bes2 a4 a d c c2 r
    c4^\markup \small "34" c bes2 g4 a2 a4 d2 cis2 r e4 f d2 c4 f f e f2 r1
    c4^\markup \small "34r" c bes2 g4 a2 a4 d2 cis r e4 f d2 c4 f f e f\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  %{"Dè_" Diös lù -- és le gran "Diö ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Dès Siörs lù -- és le gran "Siör ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki mi -- ra -- klesÄ grans aã fèsã "söl ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki le siél a fètã de gran "sans ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki sur eôs la tèrr' é -- tan -- "dit ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{Le sù -- lè£ oã jùr ko -- man -- "dant :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É de méin fôrt' é de long "bras ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki la mèr rùÿ -- je dé -- par -- "tit :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  A tra -- vèrs de sè -- le gran "Mèr ." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  %{É a -- vè -- ke lui son ar -- "mé^."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  É le sèk de -- zèrt tra -- vèr -- "sér ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki tu -- aÿ "lè_" puis -- "san_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{É Si -- çon Rø dez a -- môr -- "røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %De ba -- saÿn ôÊ -- ge le gran "Rø ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ." %sa klé -- man -- se dur' a -- ja -- mès.
  %A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  %{A son Is -- ra -- èl le sién "sèrf ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  %{Se dé -- ña "de-" -- nùs re -- kôr -- "dér ."%} sa klé -- man -- se dur' a -- ja -- mès.
  A noz an -- ne -- mis nùÂz ô -- "ta ." %sa klé -- man -- se dur' a -- ja -- mès.
  "S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  Sa vìå -- an -- de pùr le nùr -- "rir ." sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.  
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key f \major \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      c'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    c4 f e2 d8 [ \m e ] \me f2 e4 f \m g \me a \m g8 [ f ] \me r2 e4 f d2 c4 d f e f2 %1b
    s2 s s4 s2 s4 s2 s c'4 a bes2 g4 bes a4^\markup \bold "*" g4 f2 s
    s2 s s4 s2 s4 s2 s s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s c'4 c bes2 a4 d d c8 [ \m bes ] \me a2 r
    %5
    a4 g e2 e4 c8 [ \m d16 e ] f4 \me e g4. \m f8 \me e2 s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s s s2 e4 c g'2 e4 a g g a2 r
    f4 c' g8 [ \m a bes g ] \me c4 c8 [ \m bes ] a4 \me f c'2 c r2 c4 a g2 e4 c' bes g a2^\fermata %6r
    s4 s s2 s s s s s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s g4 c, f \m e8 [ d ] \me e4 f f e f2 r
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2
    %10
    c8 [ \m d ] \me e4 f2 e8 [ \m fis ] \me g2 a4 g8 [ \m f ] g4 \me a2 r g4 c bes2 a4 d d4^\markup \bold "*" c4 c2 r
    g4 a f2 f4 f4. \m g8 \me a4 a8 [ \m bes16 c ] d4 \me g,2 r c4 c bes2 a4 a d c c2^\fermata %10r
    c,4 f e2 g4 f2 f4 f4. \m g8 \me a2 s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s c4 c bes2 a8 [ \m g ] \me f4 f e f2 r
    d4 d8 [ \m e ] \me f2 e^\markup \bold "*" c4^\markup \bold "*" g'4 g2 e s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s g4 f a2 a4 c d c a2 r
    %15
    d,4 e f2 e8 [ \m fis ] \me g2 a4 g8 [ \m f ] g4 \me a2 r b4 c c2 bes4 a4^\markup \bold "*" g4 g4^\markup \bold "*" fis2 r
    g4 e d2 d8 [ \m e ] \me f2 e4 d2 c s4 s s2 s4 s s s s2 s
    s4 s s2 s s4 s s2 s s s4 s s2 s s4 s s2 s
    s4 s s2 s4 s2 s4 s2 s s g'4 a a \m g8 [ f ] \me g4 a d,4^\markup \bold "*" g4 f2 r
    c4 e f2 f8^\markup \bold "*" [ \m e ] d4^\markup \bold "*" \me d8^\markup \bold "*" [ \m e ] \me f8 [ \m e ] \me g2 e r c4 f f8 [ \m g ] a4 \me f d e8 [ \m f ] \me g4 e2 r
    %20
    f4 c g'2 a4 c2 c4 b2 c r s4 s s2 s4 s s s s2 s
    f,4 c' g8 [ \m a bes g ] \me c4 c8 [ \m bes ] a4 \me f c'2 c r c4 a g2 e4 c' bes g a2^\fermata %20r
    s4 s s2 s s s s g4 c bes2 a4 f f4^\markup \bold "*" e4 c2 r
    c4 c c2 d g d' g, s4 s s2 s4 s s s s2 s
    s4 s s2 s s4 s s2 s c4 a bes8 [ \m a ] g4 \me a c d c c2 r
    s4 s s2 s4 s2 s4 s2 s s4 s s2 s4 s s s s2 s
    g4 a f2 f4 f4. \m g8 \me a4 a8 [ \m bes16 c ] d4 \me g,2 r c4 c bes2 a4 a d c c2^\fermata %24r
    %25
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4 s s s s s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s2
    s4 s4 s2 s4 s2 s4 s2 s s e,4 f d2 c4 c f g a2 r
    f4 c' g8 [ \m a bes g ] \me c4 c8 [ \m bes ] a4 \me f c'2 c r c4 a g2 e4 c' bes g a2^\fermata %28r
    c4 c bes4. \m a8  \me g4 f2 f4 es8 [ \m d ] c4 \me d8 [ \m e ] f4 \me r2 es4 d d2 f4 f e d cis2 r
    %30
    f4 e d2 f4 es2 #(set-accidental-style 'no-reset) es4 #(set-accidental-style 'forget) d2 g r c4 c bes2 a4 c d c a2 r
    f4 c d2 e4 f2 e4 g2 g r c4 c bes2 a8 [ \m bes ] \me c [ \m a ] \me d4 c c2 r
    f,2 f g4 g4. \m a8 \me bes4 a2 a r a4 f f2 f4 d a' d4 d2 r
    d4 g, a2 a4 a2 e4 g4. \m f8 \me e2 r e4 a d,2 a'4 c bes g a2 r
    a4 g g2 c4 c8 [ \m bes a g ] \me f4 a2 a r a4 f g2 c,4 c' bes g a2 r1
    a4 g g2 c4 c8 [ \m bes a g ] \me f4 a2 a r a4 f g2 c,4 c' bes g a\longa*1/2^\fermata %34r
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  %{"Dè_" Diös lù -- és le gran "Diö ."%} sa klé -- man -- se dur' a -- ja -- mès.
  %Dès Siörs lù -- és le gran "Siör ." sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki mi -- ra -- klesÄ grans aã fèsã "söl ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki le siél a fètã de gran "sans ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki sur eôs la tèrr' é -- tan -- "dit ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :" sa klé -- man -- se dur' a -- ja -- mès.
  %{Le sù -- lè£ oã jùr ko -- man -- "dant :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É de méin fôrt' é de long "bras ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki la mèr rùÿ -- je dé -- par -- "tit :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  A tra -- vèrs de sè -- le gran "Mèr ." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  %{É a -- vè -- ke lui son ar -- "mé^."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  É le sèk de -- zèrt tra -- vèr -- "sér ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki tu -- aÿ "lè_" puis -- "san_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{É Si -- çon Rø dez a -- môr -- "røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %De ba -- saÿn ôÊ -- ge le gran "Rø ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  %Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ." sa klé -- man -- se dur' a -- ja -- mès.
  %A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  %{A son Is -- ra -- èl le sién "sèrf ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  Se dé -- ña "de-" -- nùs re -- kôr -- "dér ." sa klé -- man -- se dur' a -- ja -- mès.
  A noz an -- ne -- mis nùÂz ô -- "ta ." sa klé -- man -- se dur' a -- ja -- mès.
  "S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  Sa vìå -- an -- de pùr le nùr -- "rir ." sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. 
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \set Staff.keySignature = #`(((-1 . 6) . ,FLAT)
                                   ((0 . 6) . ,FLAT))
      \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      a'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2 %1b
    s2 s s4 s2 s4 s2 s a'4 d, g4. \m f8 \me e4 d c4^\markup \bold "*" c4 f2 r
    e f g4 a4. \m g8 \me f [ \m e ] \me d [ \m e16 f ] g4 \me fis2 s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s g4 a f2 f8 [ \m g ] \me a4 bes g f2 r
    %5
    f4 d c2 c4 c2 c4 b2 c s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s s s2 g'4 f d2 c4 f f e f2 r
    c4 g' d2 c4 c2 bes4 c2 c r c4 d bes2 c8 [ \m d16 e ] \me f4 g c, f2\fermata %6r
    e4 f d2 d4 \m e \me f2 f4 \m g \me a2 s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2
    %10
    a,4 g d'2 cis4 d2 f4 f \m e8 [ d ] \me e2 r e4 a f2 f8 [ \m g ] \me a4 bes4^\markup \bold "*" g4 a2 r
    e4 c d2 bes4 f'8 [ \m e16 d ] c4 \me c f8 [ \m e ] d4 \me g8 [ \m f ] e4 \me r2 c4 g g2 c4 a bes8 [ \m g ] \me c4 a2^\fermata %10r
    a4 c c2 d4 d2 c4 d2 e s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s g4 a g2 e4 f d c8 [ \m bes ] \me c2 r
    bes4 bes c2 c4^\markup \bold "*" \m d8^\markup \bold "*" [ e ] \me f4^\markup \bold "*" e4 d2 g s4 s s2 s4 s s s s2 s % Attention ! . le vers n'est pas rebrisé
    s4 s s2 s4 s2 s4 s2 s c,4 c f2 e4 a g g f2 r
    %15
    a,4 c c2 c4 d2 f4 f \m e8 [ d ] \me e2 r g4 g f2 f4 f4^\markup \bold "*" d4 d4^\markup \bold "*" d2 r
    d4 c bes8 [ \m c ] d4 \me bes c2 g'4 g2 e s4 s s2 s4 s s s s2 s
    s4 s s2 s s4 s s2 s s s4 s s2 s s4 s s2 s
    s4 s s2 s4 s2 s4 s2 s s e4 f f8 [ \m g a bes ] \me c4 f, f4^\markup \bold "*" e4 c2 r
    a4 c c2 d2^\markup \bold "*" bes4^\markup \bold "*" c4 d2 c8 [ \m d ] e4 \me r2 e4 d a'8 [ \m g ] f4 \me f f e d cis2 r
    %20
    d4 a e'2 f4 e2 d8 [ \m c ] \me d2 c r s4 s s2 s4 s s s s2 s
    c4 g' d2 c4 c2 bes4 c2 c r c4 d bes2 c8 [ \m d16 e ] \me f4 g c, f2^\fermata %20r
    s4 s s2  s s s s c'4 a g2 e8 [ \m f ] \me d4 c4^\markup \bold "*" c8 [ \m bes ] \me a2 r
    a4 e' e2 d8 [ \m e ] f4 \me e2 a4 \m b \me c2 s4 s s2 s4 s s s s2 s
    s4 s s2 s s4 s s2 s g4 f f \m e8 [ d ] \me e4 a g g a2 r
    s4 s s2 s4 s2 s4 s2 s s4 s s2 s4 s s s s2 s
    e4 c d2 bes4 f'8 [ \m e16 d ] c4 \me c f \m e8 [ d ] \me g [ \m f ]e4 \me r2 c4 g g2 c4 a bes8 [ \m g ] \me c4 a2^\fermata %24r
    %25
    a'4 a g2 f4 f2 c'4  a \m g8 [ f ] \me g [ \m e ] a4 \me r2 a4 g a2 bes4 a d, g fis2 r
    g4 d f \m e \me f f2 e4 d2 c r s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s2
    s4  s4 s2 s4 s2 s4 s2 s s c4 c bes2 a4 a d e f2 r
    c4 g' d2 c4 c2 bes4 c2 c r c4 d bes2 c8 [ \m d16 e ] \me f4 g c, f2^\fermata %28r
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    %30
    s4 s s2 s4 s2 s4 s2 s s c4 c g'2 e4 a g g f2 r
    a4 g f \m e8 [ d ] \me g4 c,8 [ \m bes ] a4 \me a d \m g, \me g2 r g'4 a d,2 a'4 f bes g a2 r
    d,2 c8 [ \m d16 e ] f4 \me es8 [ \m c ] \me d2 bes4 f'2 a8 [ \m g16 f ] e4 \me r2 d4 c bes2 a4 d f bes, d2 r
    f4 e c2 f8 \m d \me e2 a4 d,8 [ \m e16 f ] g4 \me g2 r g4 c, g'2 e4 f d e c2 r
    a4 c d2 c4 c2 c4 d8 [ \m e f g ] \me a4 \m g8 [ f ] \me r2 e4 a, g2 g4 c g' c, f2 r1
    a,4 c d2 c4 c2 c4 d8 [ \m e f g ] \me a4 \m g8 [ f ] \me r2 e4 a, g2 g4 c g' c, f\longa*1/2^\fermata %34r
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  %{"Dè_" Diös lù -- és le gran "Diö ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Dès Siörs lù -- és le gran "Siör ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki mi -- ra -- klesÄ grans aã fèsã "söl ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki le siél a fètã de gran "sans ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki sur eôs la tèrr' é -- tan -- "dit ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %Le sù -- lè£ oã jùr ko -- man -- "dant :" sa klé -- man -- se dur' a -- ja -- mès.
  %É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É de méin fôrt' é de long "bras ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki la mèr rùÿ -- je dé -- par -- "tit :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  A tra -- vèrs de sè -- le gran "Mèr ." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  %{É a -- vè -- ke lui son ar -- "mé^."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  É le sèk de -- zèrt tra -- vèr -- "sér ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki tu -- aÿ "lè_" puis -- "san_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{É Si -- çon Rø dez a -- môr -- "røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %De ba -- saÿn ôÊ -- ge le gran "Rø ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ." %sa klé -- man -- se dur' a -- ja -- mès.
  %A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  %{A son Is -- ra -- èl le sién "sèrf ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  %{Se dé -- ña "de-" -- nùs re -- kôr -- "dér ."%} sa klé -- man -- se dur' a -- ja -- mès.
  A noz an -- ne -- mis nùÂz ô -- "ta ." sa klé -- man -- se dur' a -- ja -- mès.
  "S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  Sa vìå -- an -- de pùr le nùr -- "rir ." sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. 
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key f \major \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      f4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    f4 f c'2 g4 d'2 c4 bes2 a r c4 f, g2 a4 bes c c f,2 %1b
    s2 s s4 s2 s4 s2 s s4 s s2 s4 s s4 s4 s2 s
    a2 d bes4 f2 f4 g2 d'2 s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s c4 a bes2 f'8 [ \m e ] \me d [ \m c ] \me bes4 c f,2 r
    %5
    \bar "" f4 g a2 e4 f2 a4 g2 c, s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s s s2 c'4 f, g2 a4 a bes c f,2 r
    f4 g8 [ \m a ] \me bes2 c8 [ \m bes ] \me a [ \m g ] f4 \me d c2 c8 [ \m d ] e4 \me r2 e4 d d2 e4 a g g f2^\fermata %6r
    a4 f bes2 g d' bes f' s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s g,4 a bes2 a4 d c c f,2 r
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2
    %10
    f4 c d8 [ \m e f g ] \me a4 g2 f4 bes2 a r c4 f, \bar "" bes8 [ \m c d e ] \me f4 d bes4^\markup \bold "*" c4 f,2 r
    g4 f f2 f4 f2 c'4 c \m b \me c2 r c,4 c d2 a'4 a g g f2^\fermata %10r
    f4 f c2 g'4 d2 a'4 bes2 a s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s c4 f, g2 a4 a bes g f2 r
    bes4 g f2 c'^\markup \bold "*" f,4^\markup \bold "*" c4 g'2 \bar "" c,2 s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s e4 f d2 a'4 a bes c f,2 \bar "" r
    %15
    d4 c f2 a4 g2 f4 bes2 a r g4 c a2 bes4 f4^\markup \bold "*" g4 g4^\markup \bold "*" d2 r
    g4 a bes2 \bar "" g4 f2 c4 g'2 c, s4 s s2 s4 s s s s2 s
    s4 s s2 s s4 s4 s2 s s s4 s s2 s s4 s s2 s
    s4 s s2 s4 s2 s4 s2 s s c'4 f d2 c4 a bes4^\markup \bold "*" c4 f,2 r
    \bar "" f4 c f2 bes2^\markup \bold "*" bes4^\markup \bold "*" a4 g2 c r2 c4 bes f'2 d4 d c bes a2 r
    %20
    d,4 f e2 d4 a'2 \bar "" a4 g2 c, r s4 s s2 s4 s s s s2 s
    f4 g8 \m a \me bes2 c8 [ \m bes ] \me a [ \m g f e ] \me d4 c2 c8 [ \m d ] e4 \me r2 e4 d d2 e4 a g g f2^\fermata %20r
    s4 s s2 s s s s c'4 f, g2 a4 bes c4^\markup \bold "*" c,4 f2 r
    \bar "" \noPageBreak f4 c'4 a2 bes c d c s4 s s2 s4 s s s s2 s
    s4 s s2 s2 s4 s s2 s c4 d bes2 a4 a bes c f,2 r
    s4 s s2 s4 s2 s4 s2 s s4 s s2 s4 s s s s2 s
    g4 f f2 f4 f2 c'4 c \m b \me c2 r c,4 c d2 a'4 a g g f2^\fermata %24r
    %25
    f4 f c'2 \bar "" a4 bes2 c4 d2 c r d4 e f2 bes,4 f g g d'2 r
    g,4 bes f8 [ \m g ] a4 \me d bes2 c4 g2 c,2 r \bar "" s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s2
    s4 s4 s2 s4 s2 s4 s2 s s c4 f g2 a4 f d c f2 r
    f4 g8 [ \m a ] \me bes2 c8 [ \m bes ] \me a [ \m g ] f4 \me d c2 c8 [ \m d ] e4 \me r2 e4 d d2 e4 a g g f2^\fermata %28r
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    %30
    s4 s s2 s4 s2 s4 s2 s s c4 f g2 a4 a bes c f,2 r
    f4 e d2 c4 f2 a4 g2 c, s s4 s s2 s4 s s s s2 s
    s s s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s s c4 f g2 a4 a bes c f,2 r
    f4 g8 [ \m a ] \me bes2 c4 a2 a8 [ \m g ] \me f [ \m e ] d4 \me e2 r e4 d d2 e4 f d8 [ \m g ] \me e4 a2 r1
    f4 g8 [ \m a ] \me bes2 c4 a2 a8 [ \m g ] \me f [ \m e ] d4 \me e2 r e4 d d2 e4 f d8 [ \m g ] \me e4 a\longa*1/2\fermata %34r
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  %"Dè_" Diös lù -- és le gran "Diö ." sa klé -- man -- se dur' a -- ja -- mès.
  Dès Siörs lù -- és le gran "Siör ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki mi -- ra -- klesÄ grans aã fèsã "söl ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki le siél a fètã de gran "sans ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki sur eôs la tèrr' é -- tan -- "dit ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{Le sù -- lè£ oã jùr ko -- man -- "dant :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É de méin fôrt' é de long "bras ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki la mèr rùÿ -- je dé -- par -- "tit :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  A tra -- vèrs de sè -- le gran "Mèr ." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  %{É a -- vè -- ke lui son ar -- "mé^."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  É le sèk de -- zèrt tra -- vèr -- "sér ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki tu -- aÿ "lè_" puis -- "san_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{É Si -- çon Rø dez a -- môr -- "røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %De ba -- saÿn ôÊ -- ge le gran "Rø ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ." %sa klé -- man -- se dur' a -- ja -- mès.
  %A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  %{A son Is -- ra -- èl le sién "sèrf ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  %{Se dé -- ña "de-" -- nùs re -- kôr -- "dér ."%} sa klé -- man -- se dur' a -- ja -- mès.
  A noz an -- ne -- mis nùÂz ô -- "ta ." %sa klé -- man -- se dur' a -- ja -- mès.
  %"S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  %{Sa vìå -- an -- de pùr le nùr -- "rir ." %}sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. 
}
%%% SECOND CHOEUR
discantusDeuxIncipit = <<
  \new MensuralVoice = "discantusDeuxIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-g" 
      \key f \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      f'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotesDeux = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    %\once \override Staff.VerticalAxisGroup #'minimum-Y-extent = #'(0 . 30)
    \key f \major
    \clef "treble"
    f,4^\markup \small "1" a g4. \m a8 \me bes4 a2 c4 b8 [ \m a ] b4 \me c2 r g4 a bes2 a4 f a g f2
    s4^\markup \small "1b" s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    c'^\markup \small "2" a d4 c2 bes8 [ \m a ] \me bes2 a s4 s s2 s4 s s4 s4 s2 s
    s^\markup \small "3" s s4 s2 s4 s2 s c4 c f2 e4 c d c c2 r
    f,4^\markup \small "4" g a2 bes4 c2 c4 d2 c s4 s s2 s4 s s s s2 s
    s4^\markup \small "5" s s2 s4 s2 s4 s2 s e4 f d2 c4 f f4^\markup \bold "*" e4 f2 r
    f,4^\markup \small "6" g a2 bes4 c2 c4 d8 [ \m e ] f4 \me e2 s4 s s2 s4 s s s s2 s
    c4^\markup \small "6r" c bes2 g4 a2 bes4 a2 g r a4 a bes2 g4 a d c c2^\fermata
    s4^\markup \small "7" s s2 s s s s d4 f e2 d4 c c4^\markup \bold "*" b4 c2 r
    c4^\markup \small "8" f e2 d4 c2 bes8 [ \m a ] \me bes2 a s4 s s2 s4 s s s s2 s
    f4^\markup \small "9" c' a2 a4 bes2 c4 d2 c r d4 e f2 d4 c c b c2
    s4^\markup \small "10" s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s4 s4 s2 s
    e4^\markup \small "10r" f d2 d4 c2 c4 d8 [ \m e ] f4 \me e2 r f4 e d2 c4 f f e f2^\fermata
    s4^\markup \small "11" s s2 s4 s2 s4 s2 s d4 e f2 d4 c c b c2 r
    c4^\markup \small "12" bes a2 g4 c2 d8 [ \m e ] \me f2 e s4 s s2 s4 s s s s2 s
    s4^\markup \small "13" s s2 s4 s2 s4 s2 s c4 a d2 c4 f f e f2 r
    f,4^\markup \small "14" g a2 g^\markup \bold "*" a4^\markup \bold "*" c4 b2 c s4 s s2 s4 s s s s2 s
    s4^\markup \small "15" s s2 s4 s2 s4 s2 s s s4 s s2 s4 s4 s4 s4 s2 s
    s4^\markup \small "16" s s2 s4 s2 s4 s2 s e4 f4 d2 c4 f4 f e f2 r
    f4^\markup \small "17" d e2 c d4 bes c2 a r bes4 g a2 f e4 d c2 r
    d4^\markup \small "18" e f2 g4 a2 c4 b2 c r s4 s s2 s4 s s4 s4 s2 s
    s4^\markup \small "19" s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4^\markup \small "20" s4 s2 s4 s2 s4 s2 s s e4 f d2 c4 c bes bes a2 r
    c4^\markup \small "20r" c bes2 g4 a2 bes4 a2 g r a4 a bes2 g4 a d c c2^\fermata
    f,4^\markup \small "21" c' a2 bes c d c s4 s s2 s4 s s4 s4 s2 s
    s4^\markup \small "22" s s2 s s s s c4 a bes2 a4 g f e f2 r2
    c'4^\markup \small "23" f d2 e c4 c d2 c s4 s s2 s4 s s s s2 s
    c4^\markup \small "24" a a \m g8 [ f ] \me g2^\markup \bold "*" a4^\markup \bold "*" c4 b2 c s4 s s2 s4 s s s s2 s
    e4^\markup \small "24r" f d2 d4 c2 c4 d8 [ \m e ] f4 \me e2 r f4 e d2 c4 f f e f2^\fermata
    s4^\markup \small "25" s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4^\markup \small "26" s s s s s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    c4^\markup \small "27" d e2 c4 d2 e4 f2 e r f4 c c2 d4 c bes bes a2 r2^\markup \bold "*"
    bes4^\markup \small "28" f8^\markup \bold "*" [ \m g ] \me a8 [ \m bes ] c4 \me a d2 c4 b2 c r s4 s s2 s4 s s s s2 s
    c4^\markup \small "28r" c bes2 g4 a2 bes4 a2 g r a4 a bes2 g4 a d c c2^\fermata
    f4^\markup \small "29" e d2 c4 a2 bes4 c2 f, r c'4 bes a2 bes4 a g f e2 r
    f4^\markup \small "30" g8 [ \m a ] \me bes2 a4 g2 c4 b2 c2 r s4 s s2 s4 s s s s2 s
    s4^\markup \small "31" s s2 s4 s2 s4 s2 s s e4 f d2 c4 f4 f e f2 r
    bes,2^\markup \small "32" a c4 bes8 [ \m c ] d4 \me d d2 cis2 r d4 a bes2 c4 bes a g fis2 r
    a4^\markup \small "33" c c2 d4 c2 c4 b2 c r e4 f d2 c4 f f e f2 r
    f4^\markup \small "34" e d2 e4 c2 c4 f2 e r cis4 d bes2 g4 a d c c2 r1
    f4^\markup \small "34r" e d2 e4 c2 c4 f2 e r cis4 d bes2 g4 a d c c\longa*1/2^\fermata
  }
}

discantusLyricsDeux = \lyricmode {
  \override LyricText #'font-name = "baifB"
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  "Dè_" Diös lù -- és le gran "Diö ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Dès Siörs lù -- és le gran "Siör ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki mi -- ra -- klesÄ grans aã fèsã "söl ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki le siél a fètã de gran "sans .%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki sur eôs la tèrr' é -- tan -- "dit ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  Le sù -- lè£ oã jùr ko -- man -- "dant :" %sa klé -- man -- se dur' a -- ja -- mès.
  É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  %Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %}sa klé -- man -- se dur' a -- ja -- mès.
  Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{É de méin fôrt' é de long "bras ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki la mèr rùÿ -- je dé -- par -- "tit :" %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  %{A tra -- vèrs de sè -- le gran "Mèr ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  É a -- vè -- ke lui son ar -- "mé^." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  %{É le sèk de -- zèrt tra -- vèr -- "sér ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tuaÿ "lè_" puis -- "san_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É Si -- çon Rø dez a -- môr -- "røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  De ba -- saÿn ôÊ -- ge le gran "Rø ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  %Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ." sa klé -- man -- se dur' a -- ja -- mès.
  A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  A son Is -- ra -- èl le sién "sèrf ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  Se dé -- ña "de-" -- nùs re -- kôr -- "dér ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{A noz an -- ne -- mis nùÂz ô -- "ta ."%} sa klé -- man -- se dur' a -- ja -- mès.
  "S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  Sa vìå -- an -- de pùr le nùr -- "rir ." sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. 
}

altusDeuxIncipit = <<
  \new MensuralVoice = "altusDeuxIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c2" 
      \set Staff.keySignature = #`(((-1 . 6) . ,FLAT)
                                   ((0 . 6) . ,FLAT))
      \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      e'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotesDeux = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2 %1b
    e2 f f8 [ \m g ] \me a2 f4 d8 [ \m e16 f ] g4 \me fis2 s4 s s2 s4 s s4 s4 s2 s
    s2 s s4 s2 s4 s2 s g4 a a \m g8 [ f ] \me g4 a bes g a2 r
    a,4 e' e4. \m fis8 \me g4 a2 e4 g4. \m f8 \me e2 s4 s s2 s4 s s s s2 s
    %5
    s4 s s2 s4 s2 s4 s2 s c'4 c bes8 [ \m a ] g4 \me a4 c f,4^\markup \bold "*" c'4 a2 r2
    a,4 e' e4. \m fis8 \me g4 a2 a4 a4. \m b8 \me c2 s4 s s2 s4 s s s s2 s
    a4 e g2 e4 f2 f4 f \m c8 [ d ] \me e2 r e4 a, d2 g,4 c d e c2^\fermata %6r
    s4 s s2 s s s s bes'4 a c2 g4 g a4^\markup \bold "*" g8 [ \m f ] \me e2 r
    a4 a8 [ \m b ] \me c2 bes4 a8 [ \m g f e ] \me f4 es8 [ \m d ] g4 \me fis2 s4 s s2 s4 s s s s2 s
    c8 [ \m d ] \me e4 f2 e8 [ \m f ] \me g2 a4 g8 [ \m f ] g4 \me a2 r bes4 c c2 bes4 a  g g8 [ \m f ] \me e2
    %10
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s4 s4 s2 s
    c'4 f, f8 [ \m e ] d4 \me d a2 a4 d2 e r a,8 [ \m bes ] \me c [ \m g ] \me bes2 c4 c g' c, f2^\fermata %10r
    s4 s s2 s4 s2 s4 s2 s a4 c c2 bes4 g a g e2 r
    g4 g f2 g4 a2 bes4 c2 c s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s g4 f a2 a4 f f c' a2 r
    d,4 d8 [ \m e ] \me f2 e^\markup \bold "*" c4^\markup \bold "*" g'4 g2 e s4 s s2 s4 s s s s2 s
    %15
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s4 s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s c'4 c bes2 a4 a f c' c2 r
    a4 b c2 a bes4 g a2 f r g4 e f2 d c4 a a2 r
    a4 a c2 c4 f2 e4 d2 c r s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    %20
    s4 s s2 s4 s2 s4 s2 s s c'4 c bes2 a8 [ \m g ] \me f4 f e f2 r
    a4 e g2 e4 f2 f4 f \m c8 [ d ] \me e2 r e4 a, d2 g,4 c4 d e c2^\fermata %20r
    d4 e f2 d a' g a s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s s s s e4 c g'2 f4 e c c c2 r
    a'4 a bes2 g a4 e g2 e s4 s s2 s4 s s s s2 s
    c4 f d2 e2^\markup \bold "*" f4^\markup \bold "*" e4 d2 c s4 s s2 s4 s s s s2 s
    c'4 f, f8 [ \m e ] d4 \me d a2 a4 d2 e r a,8 [ \m bes ] \me c [ \m a ] \me bes2 c4 c g' c, f2^\fermata %24r
    %25
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4 s s s s s2 s4 s2 s s g4 a bes2 f4 c' bes g a2 r
    a4 f g2 a4 bes4. \m a8 \me g4 a \m d, \me g2 r f4 g a2 f8 [ \m g ] \me a4 g g fis2 r2^\markup \bold "*"
    g4 d4^\markup \bold "*" f2 f4 bes4. \m a8 \me g8 [ \m f ] \me g2 e r s4 s s2 s4 s s s s2 s
    a4 e g2 e4 f2 f4 f \m c8 [ d ] \me e2 r e4 a, d2 g,4 c d e c2^\fermata %28r
    a'4 g g2 g,4 c2 bes4 es2 d r g4 g f2 d4 c c a a2 r
    %30
    a4 c f,2 f4 g2 g'4 g2 e r s4 s s2 s4 s s s s2 r
    c8 [ \m d ] \me e4 f2 g4 a2 a4 d,2 e r e4 c f2 f4 c d e c2 r
    bes2 c c4 g8 [ \m a bes c ] \me d4 d2 e r a,4 f' d2 a'4 f f d d2 r
    d4 g f2 f4 c2 c4 g' \m g, \me g2 r g4 a d2 a4 a' g4 g f2 r
    c4 e g2 e4 f2 a4 a,2 e' r a4 d, d \m g8 [ f ] \me e4 c d e c2 r1
    c4 e g2 e4 f2 a4 a,2 e' r a4 d, d \m g8 [ f ] \me e4 c d e c\longa*1/2^\fermata %34r
  }
}

altusLyricsDeux = \lyricmode {
  \override LyricText #'font-name = "baifB"
  % LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  "Dè_" Diös lù -- és le gran "Diö ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Dès Siörs lù -- és le gran "Siör ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki mi -- ra -- klesÄ grans aã fèsã "söl ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki le siél a fètã de gran "sans .%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki sur eôs la tèrr' é -- tan -- "dit ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  Le sù -- lè£ oã jùr ko -- man -- "dant :" %sa klé -- man -- se dur' a -- ja -- mès.
  É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  %Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %}sa klé -- man -- se dur' a -- ja -- mès.
  Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{É de méin fôrt' é de long "bras ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki la mèr rùÿ -- je dé -- par -- "tit :" %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  %{A tra -- vèrs de sè -- le gran "Mèr ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  É a -- vè -- ke lui son ar -- "mé^." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  %{É le sèk de -- zèrt tra -- vèr -- "sér ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tuaÿ "lè_" puis -- "san_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É Si -- çon Rø dez a -- môr -- "røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  De ba -- saÿn ôÊ -- ge le gran "Rø ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  %{Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ."%} sa klé -- man -- se dur' a -- ja -- mès.
  A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  A son Is -- ra -- èl le sién "sèrf ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  Se dé -- ña "de-" -- nùs re -- kôr -- "dér ." %sa klé -- man -- se dur' a -- ja -- mès.
  A noz an -- ne -- mis nùÂz ô -- "ta ." sa klé -- man -- se dur' a -- ja -- mès.
  "S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  Sa vìå -- an -- de pùr le nùr -- "rir ." sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
}

tenorDeuxIncipit = <<
  \new MensuralVoice = "tenorDeuxIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key f \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      f4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotesDeux = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f  \major
    \clef "G_8"
    f,4 f c'2 d8 [ \m e ] \me f2 e4 d2 c r e4 f d2 c4 d f e f2 \bar ""
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 %1b
    a,2 d bes4 f'2 d4 \bar "" g,2 d' s4 s s2 s4 s4 s4 s4 s2 s2
    s2 s s4 s2 s4 s2 s e4 f d2 \bar "" c4 f f e f2 r
    c4 c c2 d4 f8 [ \m e d c ] \me c4 b8 [ \m a ] b4 \me c2 s4 s s2 s4 s s s s2 s
    %5
    s4 s s2 s4 s2 s4 s2 s g'4 a f \m e8 [ d ] \me e4 a4 d,4^\markup \bold "*" g4 f2 r2
    c4 c c2 d8 [ \m e ] \me f2 e4 f2 g2 s4 s s2 s4 s s s s2 s
    a,4 c d \m g, \me g f2 f4 f2 g r c4 f, g2 g4 f bes8 [ \m g ] \me c [ \m bes ] \me a2^\fermata %6r
    s4 s s2  s s s s f'4 f8 [ \m g ] \me a2 d,4 e f4^\markup \bold "*" d4 c2 r
    \bar "" f4 d c2 g4 a2 d4 g,2 d' s4 s s2 s4 s s s s2 s
    a4 g d'2 cis4 d2 f4 f \m e8 [ d ] \me e2 r g4 g a2 f4 f e d c2
    %10
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s4 s4 s2 s
    c4 a bes2 bes4 c2 a4 a \m g8 [ f ] \me g2 r f4 g d'2 a4 a' d, e c2^\fermata %10r
    s4 s s2 s4 s2 s4 s2 s f4 g a2 f4 e f d c2 r
    e4 d d8 [ \m e ] f4 \me d e2 g4 a2 g s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s c,4 c f2 e4 c d g f2 r
    bes,4 bes c2 c8^\markup \bold "*" [ \m d ] e4^\markup \bold "*" \me f4^\markup \bold "*" e4 d2 g s4 s s2 s4 s s s s2 s 
    %15
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s4 s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s g4 a g2 e4 c d g a2 r
    a4 g g2 f f4 d e2 d r d4 c8 [ \m bes ] \me c2 bes4. \m a8 \me g4 f e2 r2
    f4 c' a2 g4 d'2 g4 g2 e2 r s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    %20
    s4 s s2 s4 s2 s4 s2 s s g4 a g2 e4 f8 [ \m e ] \me d4 c8 [ \m bes ] \me c2 r
    a4 c d \m g, \me g f2 f4 f2 g r2 c4 f, g2 g4 f bes8 [ \m g ] \me c [ \m bes ] \me a2^\fermata %20r
    bes4 g d'2 f f d e s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s s s s g4 f d2 d8 [ \m c ] \me c [ \m bes ] \me a4 g a2 r 
    f'4 f g2 c, c4 c b2 c s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s c4 c f2 e8 [ \m d ] \me c [ \m bes ] \me a [ \m bes ] \me g4 f2 r
    c'4 a bes2 bes4 c2 a4 a \m g8 [ f ] \me g2 r2 f4 g d'2 a4 a' d, e c2^\fermata %24r
    %25
    s4 s s2 s4 s2 s4 s2 s s s4 s  s2 s4 s s s s2 s
    s4 s s s s s2 s4 s2 s s e4 f d2 c4 f f e f2 r
    f4 a g \m f8 [ e ] \me f4 d2 c4 bes8 [ \m a ] b4 \me c2 r a4 g c2 bes4 c8 [ \m d ] \me es4 d d2 r2^\markup \bold "*"
    d4 d4^\markup \bold "*" c2 f4 f2 e4 d2 c r s4 s s2 s4 s s s s2 s
    a4 c d g, \m g \me f2 f4 f2 g r c4 f, g2 g4 f bes8 [ \m g ] \me c [ \m bes ] \me a2^\fermata %28r
    c4 c d8 [ \m c ] bes4 \me c c8 [ \m bes a g ] \me f4 g \m a \me bes2 r g4 g a2 f8 [ \m g ] \me a [ \m bes ] \me c [ \m g ] \me d'4 e2 r
    %30
    d4 e f2 d4 bes2 c4 d \m g, \me g2 r g4 a bes2 c8 [ \m d16 e ] \me f4 d e c2 r
    f,4 g a2 c4 c2 c4 b8 [ \m a ] b4 \me c2 r c4 a f4. \m g8 \me a4 a' g4 g f2 r
    f,2 a g8 [ \m a ] \me bes [ \m a ] g4 \me g a2 a r a4 a f4. \m g8 \me a4 bes4 c g a2 r
    f4 c' a2 a4 a8 [ \m bes ] c4 \me a d2 c r c4 c bes2 c4 c g' c,8 [ \m bes ] \me a2 \bar "" r
    c4 c g2 g4 f8 [ \m g ] a4 \me a a2 a r a4 a bes2 c4 f,8 [ \m a ] \me g4 g f2 r1
    c'4 c g2 g4 f8 [ \m g ] a4 \me a a2 a r a4 a bes2 c4 f,8 [ \m a ] \me g4 g f\longa*1/2^\fermata %34r
  }
}

tenorLyricsDeux = \lyricmode {
  \override LyricText #'font-name = "baifB"
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  "Dè_" Diös lù -- és le gran "Diö ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Dès Siörs lù -- és le gran "Siör ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki mi -- ra -- klesÄ grans aã fèsã "söl ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki le siél a fètã de gran "sans .%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki sur eôs la tèrr' é -- tan -- "dit ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  Le sù -- lè£ oã jùr ko -- man -- "dant :" %sa klé -- man -- se dur' a -- ja -- mès.
  É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  %Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %}sa klé -- man -- se dur' a -- ja -- mès.
  Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{É de méin fôrt' é de long "bras ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki la mèr rùÿ -- je dé -- par -- "tit :" %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  %{A tra -- vèrs de sè -- le gran "Mèr ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  É a -- vè -- ke lui son ar -- "mé^." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  %{É le sèk de -- zèrt tra -- vèr -- "sér ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tuaÿ "lè_" puis -- "san_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É Si -- çon Rø dez a -- môr -- "røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{De ba -- saÿn ôÊ -- ge le gran "Rø ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  %{Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ."%} sa klé -- man -- se dur' a -- ja -- mès.
  A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  A son Is -- ra -- èl le sién "sèrf ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  Se dé -- ña "de-" -- nùs re -- kôr -- "dér ." sa klé -- man -- se dur' a -- ja -- mès.
  A noz an -- ne -- mis nùÂz ô -- "ta ." sa klé -- man -- se dur' a -- ja -- mès.
  "S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  Sa vìå -- an -- de pùr le nùr -- "rir ." sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
}

bassusDeuxIncipit = <<
  \new MensuralVoice = "bassusDeuxIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f3" 
      \set Staff.keySignature = #`(((-2 . 6) . ,FLAT)
                                   ((-1 . 6) . ,FLAT))
      \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      f4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

bassusNotesDeux = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "bass"
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2 %1b
    s2 s s4 s2 s4 s2 s s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s2 s2 s4 s s2 s4 s s s s2
    f4 c' a2 g4 f2 a4 g2 c, s4 s s2 s4 s s s s2 s
    %5
    s4 s s2 s4 s2 s4 s2 s c'4 a bes2 a4 f bes4^\markup \bold "*" c4 f,2 r
    f4 c' a2 g4 f2 a4 \bar "" d2 c2 s4 s s2 s4 s s s s2 s
    f,4 c g'2 c,4 f2 bes,4 f2 c' r a4 d \bar "" g,2 c4 a bes c f,2^\fermata \bar "||" \noBreak %6b
    s4 s s2 s s s s bes'4 d a2 b4 c f,4^\markup \bold "*" g4 c,2 s
    s4 s s2 s4 s2 s4 s2 s2 s4 s s2 s4 s s s s2 s2
    f4 c d2 a'4 g2 f4 \bar "" bes2 a r g4 c4 a2 bes4 f g g c,2
    %10
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s4 s4 s4 s2 s
    c4 f bes,2 bes4 f2 f'4 d2 c r f,4 c' g2 \bar "" a4 f bes c f,2^\fermata \bar "||" \noBreak %10r
    s4 s s2 s4 s2 s4 s2 s d''4 c f,2 bes4 c f, g c,2 r
    c'4 g \bar "" d'2 bes4 a2 g4 f2 c' s4 s s2 s4 s s s s2 s2
    s4 s s2 s4 s2 s4 s2 s e,4 f d2 a'4 a bes c f,2 r
    bes4 g f2 c'2^\markup \bold "*" f,4^\markup \bold "*" c4 g'2 c, s4 s s2 s4 s s s s2 s2
    %15
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s4 s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s c'4 f, g2 a4 a bes c f,2 r
    d'4 g, c2 f, bes4 bes a2 d, r g4 g \bar "" f2 bes, c4 d a2 r
    d4 a' f2 e4 d2 c4 g'2 c, r s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    %20
    s4 s s2 s4 s2 s4 s2 s s c'4 f, g2 a4 a bes g f2 r
    f4 c g'2 c,4 f2 bes,4 f2 c' \bar "" r a4 d g,2 c4 a bes c f,2^\fermata \bar "||" \noBreak %20r
    bes4 c d2 bes f' bes a s4 s s2 s4 s s4 s4 s2 s
    s4 s s2 s s s s c4 f, g2 d4 e f c f2 r
    f4 d g2 e f4 a g2 c, \bar "" s4 s s2 s4 s s s s2 s
    s4 s s2 s4 s2 s4 s2 s e4 f d2 c4 f f e \bar "" f2 r
    c4 f bes,2 bes4 f2 f'4 d2 c r f,4 c' g2 a4 a bes c f,2^\fermata \bar "||" %24r
    %25
    s4 s s2 s4 s2 s4 s2 s s s4 s s2 s4 s s s s2 s
    s4 s s s s s2 s4 s2 s s c''4 f, g2 a4 a bes c f,2 r
    f4 f c'2 a4 g4. \m f8 \me e4 d2 c r d4 e f2 bes,4 f' \bar "" g g d2 r2^\markup \bold "*"
    g4 bes4^\markup \bold "*" f8 [ \m g ] a4 \me d bes2 c4 g2 c, r s4 s s2 s4 s s s s2 s
    \bar "" \noPageBreak f4 c g'2 c,4 f2 bes,4 f2 c' r a4 d g,2 c4 a bes c f,2^\fermata \bar "||" %28r
    f'4 c g'2 \bar "" e4 f2 d4 c2 bes r c4 g' d2 d4 f c d a2 r
    d4 c bes2 d4 es2 c4 g'2 \bar "" c, r s4 s s2 s4 s s s s2 s
    %30
    s4 s s2 s4 s2 s4 s2 s s c4 f \bar "" bes,8 [ \m c d e ] \me f [ \m g ] \me a4 bes c f,2 r
    bes,2 f' c4 g'2 g,4 d'2 a r d4 f bes,2 \bar "" f'4 bes, f' g d2 r
    d4 c f2 d4 a'2 a4 g2 c,2 r s4 s s2 s4 s s s s2 s
    f4 c g'2 c,4 f2 f4 d2 a r a4 d g,2 c4 a bes c f,2 r1
    \bar "" \noPageBreak f'4 c g'2 c,4 f2 f4 d2 a r a4 d g,2 c4 a bes c f,\longa*1/2^\fermata \bar "|." %34r
  }
}

bassusLyricsDeux = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès. %1b
  %"Dè_" Diös lù -- és le gran "Diö ." sa klé -- man -- se dur' a -- ja -- mès.
  %Dès Siörs lù -- és le gran "Siör ." sa klé -- man -- se dur' a -- ja -- mès.
  Ki mi -- ra -- klesÄ grans aã fèsã "söl ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki le siél a fètã de gran "sans .%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki sur eôs la tèrr' é -- tan -- "dit ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki kré -- aÿ "lè_" -- "gran_" flan -- "beôs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  %Le sù -- lè£ oã jùr ko -- man -- "dant :" sa klé -- man -- se dur' a -- ja -- mès.
  É la luÿ -- ne pùr ko -- man -- dér, é -- klé -- rant daÂ -- me de la nuit.
  %Lez é -- tø -- lez ôs -- si dès "siös ." sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %{Ki d'ÉÂ -- jìþpt' a -- téint lez é^ -- "nés ." %}sa klé -- man -- se dur' a -- ja -- mès.
  Ki tir' Is -- ra -- èæl de -- "hôÎr_" "d'ös ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{É de méin fôrt' é de long "bras ."%} sa klé -- man -- se dur' a -- ja -- mès.
  Ki la mèr rùÿ -- je dé -- par -- "tit :" %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki fit l'aæi -- ant dé -- par -- tìî s'an a -- lér son I -- se -- ra -- èæl
  %{A tra -- vèrs de sè -- le gran "Mèr ."%} sa klé -- man -- se dur' a -- ja -- mès.
  É ki fit pèrdr' é tre -- bu^ -- çér Fa -- ra -- ôá dan sé -- te mèr
  É a -- vè -- ke lui son ar -- "mé^." %sa klé -- man -- se dur' a -- ja -- mès.
  %É ki son pö -- ple k'il éi -- møtã le me -- nant fit a -- çe -- mi -- nér,
  %{É le sèk de -- zèrt tra -- vèr -- "sér ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki fra -- paÿ "lèÿ_" "pluÿ_" "gran_" "Røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{Ki tuaÿ "lè_" puis -- "san_" "Røs :"%} sa klé -- man -- se dur' a -- ja -- mès.
  É Si -- çon Rø dez a -- môr -- "røs :" %sa klé -- man -- se dur' a -- ja -- mès.
  %{De ba -- saÿn ôÊ -- ge le gran "Rø ."%} sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  %É la tèr -- re k'il te -- nøÎt ös ko -- me lör é -- ri -- taÂ -- je sör
  %{Sé  -- le mè^ -- me tèr -- re ba£ -- "£a ."%} sa klé -- man -- se dur' a -- ja -- mès.
  A son Is -- ra -- èl la ba£ -- £a, ko -- me sién é -- ri -- taÂ -- je sör,
  A son Is -- ra -- èl le sién "sèrf ." %sa klé -- man -- se dur' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
  Ki a -- lôrs k'é -- tions a -- bès -- sés a -- ba -- tus de ka -- la -- mi -- té
  Se dé -- ña "de-" -- nùs re -- kôr -- "dér ." %sa klé -- man -- se dur' a -- ja -- mès.
  %{A noz an -- ne -- mis nùÂz ô -- "ta ."%} sa klé -- man -- se dur' a -- ja -- mès.
  "S'è^_" -- lui ki ba££' é fùr -- nìît prù -- voæi -- ant aã tùt a -- ni -- mal
  Sa vìå -- an -- de pùr le nùr -- "rir ." %sa klé -- man -- se dur' a -- ja -- mès.
  Sé -- lé -- brés du siél le gran "Diö :" sa klé -- man -- se duÂr' a -- ja -- mès.
  LE SI -- ÑÖR Lù -- "és :" il "è^_" "bon ." sa klé -- man -- se duÂr' a -- ja -- mès.
}

\score {
  <<
    \new StaffGroup = choirStaff <<
      \new Voice =
        discantusNotes << \global \incipit \discantusIncipit #4.2 \discantusNotes >>
      \new Lyrics =
        discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
      \new Voice =
        altusNotes << \global \incipit \altusIncipit #4.5 \altusNotes >>
      \new Lyrics =
       altusLyrics \lyricsto altusNotes { \altusLyrics }
      \new Voice =
        tenorNotes << \global \incipit \tenorIncipit #4.5 \tenorNotes >>
      \new Lyrics =
        tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
      \new Voice =
        bassusNotes << \global \incipit \bassusIncipit #5.2 \bassusNotes >>
      \new Lyrics =
        bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
    >>
    \new StaffGroup = choirStaff <<
      \new Voice =
        discantusNotesDeux << \global \incipit \discantusDeuxIncipit #4.1 \discantusNotesDeux >>
      \new Lyrics =
        discantusLyricsDeux \lyricsto discantusNotesDeux { \discantusLyricsDeux }
      \new Voice =
        altusNotesDeux << \global \incipit \altusDeuxIncipit #5.5 \altusNotesDeux >>
      \new Lyrics =
       altusLyricsDeux \lyricsto altusNotesDeux { \altusLyricsDeux }
      \new Voice =
        tenorNotesDeux << \global \incipit \tenorDeuxIncipit #4.7 \tenorNotesDeux >>
      \new Lyrics =
        tenorLyricsDeux \lyricsto tenorNotesDeux { \tenorLyricsDeux }
      \new Voice =
        bassusNotesDeux << \global \incipit \bassusDeuxIncipit #5.2 \bassusNotesDeux >>
      \new Lyrics =
        bassusLyricsDeux \lyricsto bassusNotesDeux { \bassusLyricsDeux }
    >>
  >>
  \midi {
    \context {
      \Score
        tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout002.ly"
  \header {
    filename =  "136leSeigneurLouez.ly"
    title = "Psaume CXXXVI"
    subtitle =	" "
    opus = " "
    composer = "Claude Le Jeune"
    poet = "Jean-Antoine de Baïf (1573)"
  }
}

