global = {
  #(set-accidental-style 'forget)
  \once \override Staff.Clef #'full-size-change = ##t
  \set Staff.forceClef = ##t
  \set Score.defaultBarType = "empty"
  \time 4/4
  \override Voice.NoteHead #'style = #'baroque
  \override Score.BarNumber #'padding = #3
}

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key f \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \cadenzaOn
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    g2^\markup \small "1" f4 d2 bes'4 a g2 g4 fis2 r4
    a2^\markup \small "2" a4 f2 g4 a bes2 bes4 a2 r4
    c2^\markup \small "3" a4 bes2 g4 fis4 g8 [ \m a ] bes4 \me a bes2 r4
    d2^\markup \small "4" c4 a2 bes4 a g2 a4 fis2 r4
    g2^\markup \small "5" f4 e2 d4 g fis2 g2 r2
    bes2^\markup \small "6" g4 d'2 c4 bes a2 g4 fis2 r4
    \bar "" bes2^\markup \small "7" a4 a4. \m g8 \me f4 d g2 f4 d2 r4
    f2^\markup \small "8" g4 a2 g4 d'4 bes2 a4 a2 r4
    bes2^\markup \small "9" a4 g2 a4 g f2 f4 e2 r4
    f2^\markup \small "10" e4 d2 g8 [ \m a ] \me bes4 a2 g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  GAR -- "DE-" -- NÙS, Sù -- ve -- réin Si -- ñör.
  An -- tre nùs ne se trö -- ve plus
  Nul kìÁ s'a -- plik' aÂ fè -- reã bién.
  An -- tre lèz o -- mez il n'i a
  Nul -- le fø ne loæ -- iô -- té.
  Par -- mi ös tù -- te fôs -- se -- "té :"
  Ôá de -- vis k'il i -- ront te -- nir
  Il fla -- gôr -- net aã lö pro -- çéin.
  Mès la lè -- vre flat' un pro -- pôs,
  Kand le kör se dùÂbl' a£ -- £örs.
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key f \major \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    d2 d4 bes4. \m c8 \me d [ \m e ] \me f4 es8 [ \m d c bes ] \me c4 d2 r4
    f2 e4 d2 d8 [ \m e ] \me f [ \m e ] \me g [ \m f e d ] \me e4 f2 r4
    g2 fis4 g4. \m f8 \me es4 d8 [ \m c ] \me bes2 f'4 f2 r4
    g2 e4 f2 f4 f e2 e4 a,2 r4
    %5
    d2 d4 cis2 d4 d d4. \m c8 \me b2 r
    g'4. \m f8 \me es4 d2 es4 d4 d \m c8 [ bes ] \me c4 d2 r4
    d2 d4 cis2 d4 d es8 [ \m d ] c4 \me c bes2 r4
    d2 d4 f2 e4 a4 g8 [ \m f ] e4 \me e fis2 r4
    g2 f4 c2 f4 e d2 d4 cis2 r4
    %10
    d2 g,8 [ \m a ] \me bes [ \m c ] d4 \me es4 d d2 b\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  GAR -- "DE-" -- NÙS, Sù -- ve -- réin Si -- ñör.
  An -- tre nùs ne se trö -- ve plus
  Nul kìÁ s'a -- plik' aÂ fè -- reã bién.
  An -- tre lèz o -- mez il n'i a
  Nul -- le fø ne loæ -- iô -- té.
  Par -- mi ös tù -- te fôs -- se -- "té :"
  Ôá de -- vis k'il i -- ront te -- nir
  Il fla -- gôr -- net aã lö pro -- çéin.
  Mès la lè -- vre flat' un pro -- pôs,
  Kand le kör se dùÂbl' a£ -- £örs.
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key f \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      bes2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    bes2 a4 g8 [ \m a ] bes4 \me bes c bes2 a8 [ \m g ] \me a2 r4
    d2 c4 bes2 bes4 c d2 c8 [ \m bes ] \me c2 r4
    es2 d4 d2 c8 [ \m bes ] \me a4 g2 c4 d2 r4
    bes2 g4 d'2 d4 c c2 cis4 d2 r4
    %5
    bes2 a4 a4. \m g8 \me f4 bes4 a2 g r2
    d'2 c4 g2 g4 g fis2 g4 a2 r4
    g2 f4 e2 d4 g bes2 a4 f2 r4
    bes2 bes4 a2 c4 d d2 cis4 d2 r4
    d2 d4 g,2 c4 c a2 a4 a2 r4
    %10
    a2 c4 bes4. \m a8 \me g4 g fis2 g\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  GAR -- "DE-" -- NÙS, Sù -- ve -- réin Si -- ñör.
  An -- tre nùs ne se trö -- ve plus
  Nul kìÁ s'a -- plik' aÂ fè -- reã bién.
  An -- tre lèz o -- mez il n'i a
  Nul -- le fø ne loæ -- iô -- té.
  Par -- mi ös tù -- te fôs -- se -- "té :"
  Ôá de -- vis k'il i -- ront te -- nir
  Il fla -- gôr -- net aã lö pro -- çéin.
  Mès la lè -- vre flat' un pro -- pôs,
  Kand le kör se dùÂbl' a£ -- £örs.

}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f" 
      \set Staff.keySignature = #`(((-2 . 6) . ,FLAT)
                                   ((-1 . 6) . ,FLAT))
      \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    g'2 d4 g,2 g'4 f g2 es4 d2 r4
    d2 a4 bes2 bes'4 a \bar "" g2 g4 f2 r4
    c2 d4 g2 c,4 d es2 f4 bes,2 r4
    g'2 c,4 d2 bes4 f'4 c2 \bar "" a4 d2 r4
    %5
    g,2 d'4 a2 bes4 g d'2 g, r
    g' c,4 b2 c4 g d'2 es4 d2 r4
    g,2 d'4 a2 bes4 bes' es,2 f4 bes,2 r4
    bes2 g4 d'2 e4 fis4 g2 a4 d,2 r4
    \bar "" g2 d4 e2 f4 c d2 d4 a2 r4
    %10
    d2 e4 g2 c,4 g d'2 g,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  GAR -- "DE-" -- NÙS, Sù -- ve -- réin Si -- ñör.
  An -- tre nùs ne se trö -- ve plus
  Nul kìÁ s'a -- plik' aÂ fè -- reã bién.
  An -- tre lèz o -- mez il n'i a
  Nul -- le fø ne loæ -- iô -- té.
  Par -- mi ös tù -- te fôs -- se -- "té :"
  Ôá de -- vis k'il i -- ront te -- nir
  Il fla -- gôr -- net aã lö pro -- çéin.
  Mès la lè -- vre flat' un pro -- pôs,
  Kand le kör se dùÂbl' a£ -- £örs.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.9 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.2 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.4 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #6.4 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001.ly"
  \header {
    filename =  "012gardeNousSouverain.ly"
    title = "Psaume XII"
    subtitle =	" "
    opus = " "
    composer = "Claude Le Jeune"
    poet = "Jean-Antoine de Baïf (1573)"
  }

}

%% Strophes 3-4

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    g2^\markup \small "11" f4 d2 bes'4 a g2 g4 fis2 r4
    a2^\markup \small "12" a4 f2 g4 a bes2 bes4 a2 r4
    c2^\markup \small "13" a4 bes2 g4 fis4 g8 [ \m a ] bes4 \me a bes2 r4
    d2^\markup \small "14" c4 a2 bes4 a g2 a4 fis2 r4
    g2^\markup \small "15" f4 e2 d4 g fis2 g2 r2
    bes2^\markup \small "16" g4 d'2 c4 bes a2 g4 fis2 r4
    bes2^\markup \small "17" a4 a4. \m g8 \me f4 d g2 f4 d2 r4
    f2^\markup \small "18" g2^\markup \bold "*" a2 g4 d'4 bes2 a4 a2 r4
    bes2^\markup \small "19" a4 g2 a4 g f2 f4 e2 r4
    f4^\markup {\small "20" \bold "*"} e2 d2 g8 [ \m a ] \me bes4 a2 g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kèl -- ke jùr le Si -- ñör tù -- bon
  Ô -- te -- ra tù -- te lèÌ -- vre, dù
  Rién ne sôrt ke pro -- pôÎs fla -- tö^s.
  Ô -- te -- ra sé -- te lan -- ge fôss'
  Ar -- ro -- gant' aã se van -- tér.
  Kand i dìî -- zet a ça^ -- ke "môtã :"
  NôÎ -- tre lan -- ge le gan -- ñe -- ra.
  Pùr gan -- ñér nùÂz a -- vons tù -- jùrs
  Lang' é bèk aã ko -- man -- de -- mant.
  Ki è^t mè^ -- tre de -- sur nùs ?
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    d2 d4 bes4. \m c8 \me d [ \m e ] \me f4 es8 [ \m d c bes ] \me c4 d2 r4
    f2 e4 d2 d8 [ \m e ] \me f [ \m e ] \me g [ \m f e d ] \me e4 f2 r4
    g2 fis4 g4. \m f8 \me es4 d8 [ \m c ] \me bes2 f'4 f2 r4
    g2 e4 f2 f4 f e2 e4 a,2 r4
    %15
    d2 d4 cis2 d4 d d4. \m c8 \me b2 r
    g'4. \m f8 \me es4 d2 es4 d4 d \m c8 [ bes ] \me c4 d2 r4
    d2 d4 cis2 d4 d es8 [ \m d ] c4 \me c bes2 r4
    d2 d2^\markup \bold "*" f2 e4 a4 g8 [ \m f ] e4 \me e fis2 r4
    g2 f4 c2 f4 e d2 d4 cis2 r4
    %20
    d4^\markup {\small "   " \bold "*"} g,4 \m a \me bes8 [ \m c ] d4 \me es4 d d2 b\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kèl -- ke jùr le Si -- ñör tù -- bon
  Ô -- te -- ra tù -- te lèÌ -- vre, dù
  Rién ne sôrt ke pro -- pôÎs fla -- tö^s.
  Ô -- te -- ra sé -- te lan -- ge fôss'
  Ar -- ro -- gant' aã se van -- tér.
  Kand i dìî -- zet a ça^ -- ke "môtã :"
  NôÎ -- tre lan -- ge le gan -- ñe -- ra.
  Pùr gan -- ñér nùÂz a -- vons tù -- jùrs
  Lang' é bèk aã ko -- man -- de -- mant.
  Ki è^t mè^ -- tre de -- sur nùs ?
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    bes2 a4 g8 [ \m a ] bes4 \me bes c bes2 a8 [ \m g ] \me a2 r4
    d2 c4 bes2 bes4 c d2 c8 [ \m bes ] \me c2 r4
    es2 d4 d2 c8 [ \m bes ] \me a4 g2 c4 d2 r4
    bes2 g4 d'2 d4 c c2 cis4 d2 r4
    %15
    bes2 a4 a4. \m g8 \me f4 bes4 a2 g r2
    d'2 c4 g2 g4 g fis2 g4 a2 r4
    g2 f4 e2 d4 g bes2 a4 f2 r4
    bes2 bes^\markup \bold "*" a2 c4 d d2 cis4 d2 r4
    d2 d4 g,2 c4 c a2 a4 a2 r4
    %20
    a4^\markup {\small "   " \bold "*"} c2 bes4. \m a8 \me g4 g fis2 g\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kèl -- ke jùr le Si -- ñör tù -- bon
  Ô -- te -- ra tù -- te lèÌ -- vre, dù
  Rién ne sôrt ke pro -- pôÎs fla -- tö^s.
  Ô -- te -- ra sé -- te lan -- ge fôss'
  Ar -- ro -- gant' aã se van -- tér.
  Kand i dìî -- zet a ça^ -- ke "môtã :"
  NôÎ -- tre lan -- ge le gan -- ñe -- ra.
  Pùr gan -- ñér nùÂz a -- vons tù -- jùrs
  Lang' é bèk aã ko -- man -- de -- mant.
  Ki è^t mè^ -- tre de -- sur nùs ?
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    g'2 d4 g,2 g'4 f g2 es4 d2 r4
    d2 a4 bes2 bes'4 a g2 g4 f2 r4
    c2 d4 g2 c,4 \bar "" d es2 f4 bes,2 r4
    g'2 c,4 d2 bes4 f'4 c2 a4 d2 r4
    %15
    g,2 d'4 a2 bes4 g d'2 g, r
    g' c,4 \bar "" b2 c4 g d'2 es4 d2 r4
    g,2 d'4 a2 bes4 bes' es,2 f4 bes,2 r4
    bes2 g2^\markup \bold "*" d'2 e4 fis4 g2 \bar "" a4 d,2 r4
    g2 d4 e2 f4 c d2 d4 a2 r4
    %20
    d4^\markup {\small "   " \bold "*"} e2 g2 c,4 g d'2 g,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kèl -- ke jùr le Si -- ñör tù -- bon
  Ô -- te -- ra tù -- te lèÌ -- vre, dù
  Rién ne sôrt ke pro -- pôÎs fla -- tö^s.
  Ô -- te -- ra sé -- te lan -- ge fôss'
  Ar -- ro -- gant' aã se van -- tér.
  Kand i dìî -- zet a ça^ -- ke "môtã :"
  NôÎ -- tre lan -- ge le gan -- ñe -- ra.
  Pùr gan -- ñér nùÂz a -- vons tù -- jùrs
  Lang' é bèk aã ko -- man -- de -- mant.
  Ki è^t mè^ -- tre de -- sur nùs ?
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 5-6

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    g2^\markup \small "21" f4 d2 bes'4 a g2 g4 fis2 r4
    a2^\markup \small "22" a4 f2 g4 a bes2 bes4 a2 r4
    c2^\markup \small "23" a4 bes2 g4 fis4 g8 [ \m a ] bes4 \me a bes2 r4
    d2^\markup \small "24" c4 a2 bes4 a g2 a4 fis2 r4
    g2^\markup \small "25" f4 e2 d4 g fis2 g2 r2
    bes2^\markup \small "26" g4 d'2 c4 bes a2 g4 fis2 r4
    bes2^\markup \small "27" a4 a4. \m g8 \me f4 d g2 f4 d2 r4
    f2^\markup \small "28" g4 a2 g4 d'4 bes2 a4 a2 r4
    bes2^\markup \small "29" a4 g2 a4 g f2 f4 e2 r4
    f2^\markup \small "30" e4 d2 g8 [ \m a ] \me bes4 a2 g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Ôá re -- bùrs le Si -- ñör a dit.
  Pùr la sù -- fré -- te dès fù -- lés,
  Sur la pléin -- te dez a -- fli -- jés,
  Méin -- te -- nant je me va^ le -- vér
  Ôá se -- kùrs du tra -- va£ -- £é.
  A dé -- li -- vre mé -- trè, se -- lui
  Kon -- tre kìþ le mé -- çant a -- vøt
  Tréi -- tre -- mant le fi -- lèt la -- "sé :"
  Rés -- pi -- rér le fe -- rè de mal
  Séin é sôÎ -- ve le gar -- dant.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    d2 d4 bes4. \m c8 \me d [ \m e ] \me f4 es8 [ \m d c bes ] \me c4 d2 r4
    f2 e4 d2 d8 [ \m e ] \me f [ \m e ] \me g [ \m f e d ] \me e4 f2 r4
    g2 fis4 g4. \m f8 \me es4 d8 [ \m c ] \me bes2 f'4 f2 r4
    g2 e4 f2 f4 f e2 e4 a,2 r4
    %25
    d2 d4 cis2 d4 d d4. \m c8 \me b2 r
    g'4. \m f8 \me es4 d2 es4 d4 d \m c8 [ bes ] \me c4 d2 r4
    d2 d4 cis2 d4 d es8 [ \m d ] c4 \me c bes2 r4
    d2 d4 f2 e4 a4 g8 [ \m f ] e4 \me e fis2 r4
    g2 f4 c2 f4 e d2 d4 cis2 r4
    %30
    d2 g,8 [ \m a ]\me bes [ \m c ] d4 \me es4 d d2 b\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Ôá re -- bùrs le Si -- ñör a dit.
  Pùr la sù -- fré -- te dès fù -- lés,
  Sur la pléin -- te dez a -- fli -- jés,
  Méin -- te -- nant je me va^ le -- vér
  Ôá se -- kùrs du tra -- va£ -- £é.
  A dé -- li -- vre mé -- trè, se -- lui
  Kon -- tre kìþ le mé -- çant a -- vøt
  Tréi -- tre -- mant le fi -- lèt la -- "sé :"
  Rés -- pi -- rér le fe -- rè de mal
  Séin é sôÎ -- ve le gar -- dant.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    bes2 a4 g8 [ \m a ] bes4 \me bes c bes2 a8 [ \m g ] \me a2 r4
    d2 c4 bes2 bes4 c d2 c8 [ \m bes ] \me c2 r4
    es2 d4 d2 c8 [ \m bes ] \me a4 g2 c4 d2 r4
    bes2 g4 d'2 d4 c c2 cis4 d2 r4
    %25
    \bar "" bes2 a4 a4. \m g8 \me f4 bes4 a2 g r2
    d'2 c4 g2 g4 g fis2 g4 a2 r4
    g2 f4 e2 d4 g bes2 a4 f2 r4
    bes2 bes4 a2 c4 d d2 cis4 d2 r4
    d2 d4 g,2 c4 c a2 a4 a2 r4
    %30
    a2 c4 bes4. \m a8 \me g4 g fis2 g\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Ôá re -- bùrs le Si -- ñör a dit.
  Pùr la sù -- fré -- te dès fù -- lés,
  Sur la pléin -- te dez a -- fli -- jés,
  Méin -- te -- nant je me va^ le -- vér
  Ôá se -- kùrs du tra -- va£ -- £é.
  A dé -- li -- vre mé -- trè, se -- lui
  Kon -- tre kìþ le mé -- çant a -- vøt
  Tréi -- tre -- mant le fi -- lèt la -- "sé :"
  Rés -- pi -- rér le fe -- rè de mal
  Séin é sôÎ -- ve le gar -- dant.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    g'2 d4 g,2 g'4 f g2 es4 d2 r4
    d2 a4 bes2 bes'4 a g2 g4 f2 \bar "" r4
    c2 d4 g2 c,4 d es2 f4 bes,2 r4
    g'2 c,4 d2 bes4 f'4 c2 a4 d2 r4
    %25
    g,2 d'4 a2 bes4 g d'2 g, r
    g' c,4 b2 c4 g d'2 es4 d2 r4
    g,2 \bar "" d'4 a2 bes4 bes' es,2 f4 bes,2 r4
    bes2 g4 d'2 e4 fis4 g2 a4 d,2 r4
    g2 d4 e2 \bar "" f4 c d2 d4 a2 r4
    %30
    d2 e4 g2 c,4 g d'2 g,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Ôá re -- bùrs le Si -- ñör a dit.
  Pùr la sù -- fré -- te dès fù -- lés,
  Sur la pléin -- te dez a -- fli -- jés,
  Méin -- te -- nant je me va^ le -- vér
  Ôá se -- kùrs du tra -- va£ -- £é.
  A dé -- li -- vre mé -- trè, se -- lui
  Kon -- tre kìþ le mé -- çant a -- vøt
  Tréi -- tre -- mant le fi -- lèt la -- "sé :"
  Rés -- pi -- rér le fe -- rè de mal
  Séin é sôÎ -- ve le gar -- dant.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 7-8

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    g2^\markup \small "31" f4 d2 bes'4 a g2 g4 fis2 r4
    a2^\markup \small "32" a4 f2 g4 a bes2 bes4 a2 r4
    c2^\markup \small "33" a4 bes2 g4 fis4 g8 [ \m a ] bes4 \me a bes2 r4
    d2^\markup \small "34" c4 a2 bes4 a g2 a4 fis2 r4
    g2^\markup \small "35" f4 e2 d4 g fis2 g2 r2
    bes2^\markup \small "36" g4 d'2 c4 bes a2 g4 fis2 r4
    bes2^\markup \small "37" a4 a4. \m g8 \me f4 d g2 f4 d2 r4
    f2^\markup \small "38" g4 a2 g4 d'4 bes2 a4 a2 r4
    bes2^\markup \small "39" a4 g2 a4 g f2 f4 e2 r4
    f2^\markup \small "40" e4 d2 g8 [ \m a ] \me bes4 a2 g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  La pro -- mès -- se de Diö re -- luit,
  Puÿ -- re plus ke le pur mé -- ta£,
  Nètã, re -- kuit é re -- kuit sù -- vant,
  Kand a -- près la sé -- tié -- me føsã
  On le tìþ -- re duÂ krö -- zètã.
  Don -- kez ôÎ gra -- si -- öæs Si -- ñör,
  Vö -- £e "lè_" méÂtr' aÂ sô -- ve -- té.
  Gar -- de ça^ -- kun aã tùt ja -- mès
  Kon -- tre tèl ma -- lu -- rös ha -- ras
  Pléin de frôÎd' é de tréi -- zon.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    d2 d4 bes4. \m c8 \me d [ \m e ] \me f4 es8 [ \m d c bes ] \me c4 d2 r4
    f2 e4 d2 d8 [ \m e ] \me f [ \m e ] \me g [ \m f e d ] \me e4 f2 r4
    g2 fis4 g4. \m f8 \me es4 d8 [ \m c ] \me bes2 f'4 f2 r4
    g2 e4 f2 f4 f e2 e4 a,2 r4
    %35
    d2 d4 cis2 d4 d d4. \m c8 \me b2 r
    g'4. \m f8 \me es4 d2 es4 d4 d \m c8 [ bes ] \me c4 d2 r4
    d2 d4 cis2 d4 d es8 [ \m d ] c4 \me c bes2 r4
    d2 d4 f2 e4 a4 g8 [ \m f ] e4 \me e fis2 r4
    g2 f4 c2 f4 e d2 d4 cis2 r4
    %40
    d2 g,8 [ \m a ] \me bes [ \m c ] d4 \me es4 d d2 b\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  La pro -- mès -- se de Diö re -- luit,
  Puÿ -- re plus ke le pur mé -- ta£,
  Nètã, re -- kuit é re -- kuit sù -- vant,
  Kand a -- près la sé -- tié -- me føsã
  On le tìþ -- re duÂ krö -- zètã.
  Don -- kez ôÎ gra -- si -- öæs Si -- ñör,
  Vö -- £e "lè_" méÂtr' aÂ sô -- ve -- té.
  Gar -- de ça^ -- kun aã tùt ja -- mès
  Kon -- tre tèl ma -- lu -- rös ha -- ras
  Pléin de frôÎd' é de tréi -- zon.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    bes2 a4 g8 [ \m a ] bes4 \me bes c bes2 a8 [ \m g ] \me a2 r4
    d2 c4 bes2 bes4 c d2 c8 [ \m bes ] \me c2 r4
    es2 d4 d2 c8 [ \m bes ] \me a4 g2 c4 d2 r4
    bes2 g4 d'2 d4 c c2 cis4 d2 r4
    %35
    bes2 a4 a4. \m g8 \me f4 bes4 a2 g r2
    d'2 c4 g2 g4 g fis2 g4 a2 r4
    g2 f4 e2 d4 g bes2 a4 f2 r4
    bes2 bes4 a2 c4 d d2 cis4 d2 r4
    d2 d4 g,2 c4 c a2 a4 a2 r4
    %40
    a2 c4 bes4. \m a8 \me g4 g fis2 g\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  La pro -- mès -- se de Diö re -- luit,
  Puÿ -- re plus ke le pur mé -- ta£,
  Nètã, re -- kuit é re -- kuit sù -- vant,
  Kand a -- près la sé -- tié -- me føsã
  On le tìþ -- re duÂ krö -- zètã.
  Don -- kez ôÎ gra -- si -- öæs Si -- ñör,
  Vö -- £e "lè_" méÂtr' aÂ sô -- ve -- té.
  Gar -- de ça^ -- kun aã tùt ja -- mès
  Kon -- tre tèl ma -- lu -- rös ha -- ras
  Pléin de frôÎd' é de tréi -- zon.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    g'2 d4 g,2 g'4 f g2 es4 d2 r4
    d2 a4 bes2 bes'4 a g2 g4 f2 \bar "" r4
    c2 d4 g2 c,4 d es2 f4 bes,2 r4
    g'2 c,4 d2 bes4 f'4 c2 a4 d2 r4
    %35
    \bar "" g,2 d'4 a2 bes4 g d'2 g, r
    g' c,4 b2 c4 g d'2 es4 d2 r4
    g,2 \bar "" d'4 a2 bes4 bes' es,2 f4 bes,2 r4
    bes2 g4 d'2 e4 fis4 g2 a4 d,2 r4
    g2 d4 e2 \bar "" f4 c d2 d4 a2 r4
    %40
    d2 e4 g2 c,4 g d'2 g,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  La pro -- mès -- se de Diö re -- luit,
  Puÿ -- re plus ke le pur mé -- ta£,
  Nètã, re -- kuit é re -- kuit sù -- vant,
  Kand a -- près la sé -- tié -- me føsã
  On le tìþ -- re duÂ krö -- zètã.
  Don -- kez ôÎ gra -- si -- öæs Si -- ñör,
  Vö -- £e "lè_" méÂtr' aÂ sô -- ve -- té.
  Gar -- de ça^ -- kun aã tùt ja -- mès
  Kon -- tre tèl ma -- lu -- rös ha -- ras
  Pléin de frôÎd' é de tréi -- zon.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophe 9

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    bes2^\markup \small "41" g4 d'2 c4 bes a2 g4 fis2 r4
    bes2^\markup \small "42" a4 a4. \m g8 \me f4 d g2 f4 d2 r4
    f2^\markup \small "43" g4 a2 g4 d'4 bes2 a4 a2 r4
    bes2^\markup \small "44" a4 g2 a4 g f2 f4 e2 r4
    f2^\markup \small "45" e4 d2 g8 [ \m a ] \me bes4 a2 g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  On ne vøtã ke mé -- çans kù -- rir
  Par tùt an -- tre -- pre -- nörs de mal.
  Kand tù -- "lè_" pìÁ -- rez éÿ -- le -- vés
  Vont te -- nant le de -- gré d'o -- nör,
  Tùt l'o -- nör s'a -- néaæn -- tìît.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    g'4. \m f8 \me es4 d2 es4 d4 d \m c8 [ bes ] \me c4 d2 r4
    d2 d4 cis2 d4 d es8 [ \m d ] c4 \me c bes2 r4
    d2 d4 f2 e4 a4 g8 [ \m f ] e4 \me e fis2 r4
    g2 f4 c2 f4 e d2 d4 cis2 r4
    %45
    d2 g,8 [ \m a ] \me bes [ \m c ] d4 \me es4 d d2 b\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  On ne vøtã ke mé -- çans kù -- rir
  Par tùt an -- tre -- pre -- nörs de mal.
  Kand tù -- "lè_" pìÁ -- rez éÿ -- le -- vés
  Vont te -- nant le de -- gré d'o -- nör,
  Tùt l'o -- nör s'a -- néaæn -- tìît.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    d2 c4 g2 g4 g fis2 g4 a2 r4
    g2 f4 e2 d4 g bes2 a4 f2 r4
    bes2 bes4 a2 c4 d d2 cis4 d2 r4
    d2 d4 g,2 c4 c a2 a4 a2 r4
    %45
    a2 c4 bes4. \m a8 \me g4 g fis2 g\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  On ne vøtã ke mé -- çans kù -- rir
  Par tùt an -- tre -- pre -- nörs de mal.
  Kand tù -- "lè_" pìÁ -- rez éÿ -- le -- vés
  Vont te -- nant le de -- gré d'o -- nör,
  Tùt l'o -- nör s'a -- néaæn -- tìît.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    g'2 c,4 b2 c4 g d'2 es4 d2 r4
    g,2 d'4 a2 bes4 bes' es,2 f4 bes,2 r4
    bes2 g4 d'2 e4 \bar "" fis4 g2 a4 d,2 r4
    g2 d4 e2 f4 c d2 d4 a2 r4
    %45
    d2 e4 g2 c,4 g d'2 g,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  On ne vøtã ke mé -- çans kù -- rir
  Par tùt an -- tre -- pre -- nörs de mal.
  Kand tù -- "lè_" pìÁ -- rez éÿ -- le -- vés
  Vont te -- nant le de -- gré d'o -- nör,
  Tùt l'o -- nör s'a -- néaæn -- tìît.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
} 