
global = {
  #(set-accidental-style 'forget)
  % main
  \once \override Staff.Clef #'full-size-change = ##t
  \set Staff.forceClef = ##t
  \set Score.defaultBarType = "empty"
  \time 4/4
  \override Voice.NoteHead #'style = #'baroque
  \override Score.BarNumber #'padding = #3
}

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key c \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key c \major
    \clef "treble"
    \cadenzaOn
    d,2^\markup \small "1" g a4 b2 g4 c2 b4 a2 g a r4 a2 b
    cis4^\markup \small "2" d4. \m c8 \me b4 g2 g4 c2 b4 a2 g2^\markup \bold "*" a4 \m g8 [ a ] \me bes2 a r4
    a4^\markup \small "3" bes g2 g4 a2 g fis g4 a2 c4 b2 a g r
    d4^\markup \small "4" g2 f4 e2 f d e4 f2 g4 a4. \m b8 \me c2 b r
    a4^\markup \small "5" d2 c4 b2 c4 a a4. \m g8 \me f4 e2 f4 d2 g fis r
    a4^\markup \small "6" bes g2 g4 a2 c4 b2 c4 d2 g,4 g2 d' b r
    b^\markup \small "7" a g4 c2 b c d4 e8 [ \m d c b ] \me a4 d2 cis d s
    s^\markup \small "8" s s4 s2 s s s4 s2 s4 s2 s s s1
    b2^\markup \small "9" g g4 c2 a bes2 a8 [ \m g ] \me f2 g4 a2 bes4 \m a \me a2 s
    s^\markup \small "10" s s4 s2 s s s4 s2 s4 s2 s s s1 
    d4^\markup \small "11" b2 g4 c2 b4 a2 f4 bes2 a4 g2 a2  #(set-accidental-style 'no-reset) fis2
    \saon f4^\markup \small "12" \saof #(set-accidental-style 'forget)g2 f4 e2 d r4 g2 a4 c2 b a d g, r4
    f^\markup \small "13" e2 d4 g2 fis g a4 d,2 e4 g2 fis g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pùr kø te "tién_" tu lûiñ de nùs, Séi -- "ñör ?" Pùr kø
  Ka -- çé te "tién_" -- tu ôá be -- zûiñ ôá mè^m' an -- "nui ?"
  Le mé -- çant par ôr -- gö£ fiér le sùÿ -- fre -- tös pùr -- suit.
  Ke "søÎt_" i prins dan "lè_" fi -- nés -- sesÄ k'il son -- "jøÎt !"
  Kar ôá de -- zir de son a^m' ìÁ s'è^t lù -- éæ pèr -- "vèrs :"
  É bé -- nìît l'a -- vaÿ -- re mô -- gré -- ant le Diö Van -- jör.
  Pôr -- tant le né^s hôÎt il ne çèr -- çe pûint son "Diö :"
  "Lè_" vøÎi -- esÄ k'il tiént sont tù -- jùrs dé -- séins fa^ -- çö^s.
  É pùr -- se kon -- tre tùs sez an -- ne -- mis sùÿ -- flant,
  De -- dans le kör "dit : " Rién ne pùr -- røt m'é -- bran -- "lér :"
  Ja -- mès ne çè^ -- rè non ja -- mès an ô -- kun mal.
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key c \major \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "G_8"
    d2 e d4 g4. \m f8 \me e [ \m d ] \me c [ \m b ] a4 \me g d'8 [ \m e ] f4 \me e2 d r4 \bar "" fis2 g4. \m f8 \me
    e4 d8 [ \m e ] fis4  \me g e2 d4 e \m d8 [ c ] \me d [ \m e ] \me f [ \m e d c ] \me b4^\markup \bold "*" \m c \me c8 [ \m d  e  f ] \me e [ \m d ] g4 \me fis2 r4
    fis4 g e2 e4 d2 d d e4 f2 g4 g2 fis d r
    d4 e2 c4 c2 a g8 [ \m a ] b4 \me b c4. \m d8 \me e4 f2 g g r
    %5
    fis4 g4. \m f8 \me e4 d2 e4 d cis8 [ \m d ] e4 \me a, a2 a4 b8 [ \m c ] d4 \me cis8 [ \m b ] cis4 \me d2 r
    fis4 g e2 e4 f2 g4 g2 g4 g4. \m f8 \me e4 b2 fis'2 g r
    g f e8 [ \m d ] \me e4 \m fis \me g2 e d4 g2 fis4 g8 [ \m f e d ] \me e2 d r
    e d c4 f2 e f g4 a8 [ \m g f e ] \me d4 g2 fis g r1
    g2 e d4 e2 fis g4. \m f8 \me e4 d2 e4 f2 g4 \m e \me fis2 \nr r
    %10
    \saon f \saof \fo e d4 g2 d e d8 [ \m c ] \me b2 c4 d2 e4 \m d \me d2 r1
    fis4 g2 e4 a2 g4 fis2 d4 g2 f4 e2 e a,
    d4 d2 d4 c2 b r4 d4. \m e8 \me f4 e4. \m fis8 \me g2 f f e r4
    d cis2 d4 d2 d b a4 g8 [ \m a ] b4 \me b e2 d b\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pùr kø te "tién_" tu lûiñ de nùs, Séi -- "ñör ?" Pùr kø
  Ka -- çé te "tién_" -- tu ôá be -- zûiñ ôá mè^m' an -- "nui ?"
  Le mé -- çant par ôr -- gö£ fiér le sùÿ -- fre -- tös pùr -- suit.
  Ke "søÎt_" i prins dan "lè_" fi -- nés -- sesÄ k'il son -- "jøÎt !"
  Kar ôá de -- zir de son a^m' ìÁ s'è^t lù -- éæ pèr -- "vèrs :"
  É bé -- nìît l'a -- vaÿ -- re mô -- gré -- ant le Diö Van -- jör.
  Pôr -- tant le né^s hôÎt il ne çèr -- çe pûint son "Diö :"
  Mè^ tùt se k'il pans' an son a^ -- me, Diö n'è^_ pûint.
  "Lè_" vøÎi -- esÄ k'il tiént sont tù -- jùrs dé -- séins fa^ -- çö^s.
  "Tè_" "juÿ" -- je -- mans Diö sont tro -- hôÎs da -- vant sèz "iös !"
  É pùr -- se kon -- tre tùs sez an -- ne -- mis sùÿ -- flant,
  De -- dans le kör "dit : " Rién ne pùr -- røt m'é -- bran -- "lér :"
  Ja -- mès ne çè^ -- rè non ja -- mès an ô -- kun mal.
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key c \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "G_8"
    s2 s s4 s2 s4 s2 s4 s2 s s s4 d,2 g
    a4 b2 g4 c2 b4 a2 g4 d2 e2^\markup \bold "*" f4 \m e8 [ d ] \me g2 d' r4 
    d d c2 c4 a2 bes a c4 c4. \m d8 \me e4 d2 d b r
    b4 c2 a4 g2 d' b g4 a2 b4 d2 e d r
    %5
    d4 g,2 g4 g2 g4 f e \m a \me d cis2 d4 d8 [ \m c b a ] \me g2 a r2
    d4 d c2 b4 d2 e4 d2 g,4 g2 g4 g2 a g r
    g d'4. \m c8 \me b4 a2 g a b4 \bar "" c2 d4 bes2 a d, r
    c' b a8 [ \m g ] \me a4 \m b \me c2 a g4 c2 b4 c8 [ \m b a g ] \me a2 g r1
    g2 c b4 a2 d g, a4 bes2 a8 [ \m g ] \me f [ \m d ] d'4 \me d \m cis \me d2 r
    %10
    d c b8 [ \m a ] \me b4 \m c \me b2 c4. \m b8 \me a4 g2 a4 b2 c4 \m a \me b2 r1
    a4 g8 [ \m a ] b4 \me c c \m b8 [ a ] \me d4 d8 [ \m c16 b ] a4 \me bes \nr bes \fo \m a8 [ g ] \me c4 c2 cis d
    a4 g2 d4 g2 g r4 b2 d4 c8 [ \m d ] e4 \me e4. \m d8 \me c2 b8 [ \m a ] b4 \me c2 r4
    a4 a2 f4 bes2 a g d'4 b2 g4 c2 a g\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pùr kø
  Ka -- çé te "tién_" -- tu ôá be -- zûiñ ôá mè^m' an -- "nui ?"
  Le mé -- çant par ôr -- gö£ fiér le sùÿ -- fre -- tös pùr -- suit.
  Ke "søÎt_" i prins dan "lè_" fi -- nés -- sesÄ k'il son -- "jøÎt !"
  Kar ôá de -- zir de son a^m' ìÁ s'è^t lù -- éæ pèr -- "vèrs :"
  É bé -- nìît l'a -- vaÿ -- re mô -- gré -- ant le Diö Van -- jör.
  Pôr -- tant le né^s hôÎt il ne çèr -- çe pûint son "Diö :"
  Mè^ tùt se k'il pans' an son a^ -- me, Diö n'è^_ pûint.
  "Lè_" vøÎi -- esÄ k'il tiént sont tù -- jùrs dé -- séins fa^ -- çö^s.
  "Tè_" "juÿ" -- je -- mans Diö sont tro -- hôÎs da -- vant sèz "iös !"
  É pùr -- se kon -- tre tùs sez an -- ne -- mis sùÿ -- flant,
  De -- dans le kör "dit : " Rién ne pùr -- røt m'é -- bran -- "lér :"
  Ja -- mès ne çè^ -- rè non ja -- mès an ô -- kun mal.
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f" 
      \key c \major \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "bass"
    s2 s  s4 s2 s4 s2 s4 s2 s s s4 s2 s
    s4 s2 s4 s2 s4 s2 s4 s2 s2 s2 s2 s s4
    d g c,2 e4 fis2 g \bar "" d c4 f2 c4 g'2 d g, r
    g'4 e2 f4 c2 d g g4 f2 e4 d2 c \bar "" g' r
    %5
    d4 b2 c4 g2 c4 d a8 [ \m b ] cis4 \me d a'2 d,4 g2 e d r
    d4 g \bar "" c,2 e4 d2 c4 g'2 e4 b2 c4 e2 d g,2 r
    s s s4 s2 s s  s4 s2 s4 s2 s s s
    c g'4. \m f8 \me e4 d2 c d e4 f2 g4 e2 \bar "" d g, s1
    s2 s s4 s2 s s s4 s2 s4 s2 s s s
    %10
    d' \bar "" a' f4 e2 g c, d4 e2 d8 [ \m c ] \me b [ \m g ] g'4 \me g \m fis \me g2 r1
    d4 e2 e4 \bar "" f2 g4 d2 d4 es2 f4 c2 a d
    d4 b2 b4 c2 g r4 g'2 d4 a'2 \bar "" e f d c r4 
    d a2 bes4 g2 d' e fis4 g2 e4 c2 d g,\longa*1/2^\fermata \bar "||"
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Le mé -- çant par ôr -- gö£ fiér le sùÿ -- fre -- tös pùr -- suit.
  Ke "søÎt_" i prins dan "lè_" fi -- nés -- sesÄ k'il son -- "jøÎt !"
  Kar ôá de -- zir de son a^m' ìÁ s'è^t lù -- éæ pèr -- "vèrs :"
  É bé -- nìît l'a -- vaÿ -- re mô -- gré -- ant le Diö Van -- jör.
  Mè^ tùt se k'il pans' an son a^ -- me, Diö n'è^_ pûint.
  "Tè_" "juÿ" -- je -- mans Diö sont tro -- hôÎs da -- vant sèz "iös !"
  É pùr -- se kon -- tre tùs sez an -- ne -- mis sùÿ -- flant,
  De -- dans le kör "dit : " Rién ne pùr -- røt m'é -- bran -- "lér :"
  Ja -- mès ne çè^ -- rè non ja -- mès an ô -- kun mal.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.3 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.2 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.4 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #5.6 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001.ly"
  \header {
    filename =  "010pourquoyTeTiens.ly"
    title = "Psaume X"
    subtitle =	" "
    opus = " "
    composer = "Claude Le Jeune"
    poet = "Jean-Antoine de Baïf (1573)"
  }

}

%% Seconde partie

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key c \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key c \major
    \clef "treble"
    \cadenzaOn
    d,2^\markup \small "14" g a4 b2 g4 c2 b4 a2 g b a g
    s4^\markup \small "15" s2 s4 s2 s s s4 s2 s s s s s
    g4^\markup \small "16" f2 d4 e2 d g f4 e2 g4 a2 c b r4
    c4^\markup \small "17" a2 d4 g,2 c a bes4 a2 fis4 g2 a d, r4
    d'4^\markup \small "18" c2 b4 a2 c4 b2 a4 g2 bes4 a2 g fis r4
    g4^\markup \small "19" e2 e4 f2 d a' b4 c2 d4 g,2 a g 
    f4^\markup \small "20" e2 d4 c2 b c d4 e2 f4 d2 a' fis
    g^\markup \small "21" f e4 d2 e g g4 a2 b4 c2 a g r1
    d'4^\markup \small "22" c2 b4 a2 c4 b2 a4 g2 bes4 a2 g fis 
    g^\markup \small "23" e d4 g2 a4 b2 g4 a2 g4 g2 fis g r
    fis^\markup \small "24" g f4 e2 d r4 g2 a4 c2 b4 a2 d g, r4
    f4^\markup \small "25" e2 d4 g2 fis g a4 d,2 e4 g2 fis g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pléin' è^t saÂ bùÿ -- çe d'in -- juÂr' ùÿ -- traj' éÿ tréi -- zon.
  Il è^t an an -- bu^ç' ôá çe -- "mins :" é viént mör -- triér
  Kù -- rant d'a -- gètã sur l'in -- no -- sant. I sont ôá gètã
  Sez iö^s ka -- çés de -- sus le sù -- fre -- tös pas -- sant.
  Kù -- vèrt an an -- bu^ç' éin -- si k'un lìå -- on jìî -- zant
  De -- dans sa taÿ -- niér' il se tiént vé -- £ant ôá gètã
  Pùr l'a -- fli -- jé prandr' a -- tra -- pé de -- dans "sè_" rès.
  Se sèrr' é tréìÎn' é fètã le dùs, a -- fin k'il vøÎ
  "Dè_" pôÎ -- vresÄ çør la ban -- de dans la méin "dè_" fôrs.
  Puis dans le kör dit, Diö ne s'an sù -- vién -- "dra-" -- "pas :"
  É son re -- gard kaç', éÿ ja -- mès n'i vién -- dra vør.
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key c \major \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "G_8"
    d2 b4. \m c8 \me a4 g2 c4 a2 g4 d'2 e e8 [ \m d ] g4 \me fis8 [ \m e ] fis4 \me g2
    %15
    s4 s2 s4 s2 s s s4 s2 s s s s s
    e4 d2 b4 b2 b e d4 cis2 e4 f2 e8 [ \m f16 g ] a4 \me gis2 r4
    a4 f2 d4 e2 e c g'4 e2 d4 c \m b \me a2 g8 [ \m a b c ] \me r4
    d4 e2 e4 c2 a4 d2 d4 b2 g4 a2 d d r4
    d4 c2 cis4 d2 b c b4 e2 d4 e2 a, d
    %20
    d4 c2 g4 a2 d, e b'4 b \m cis \me d b2 cis d
    d d c4 g2 c d d4 d2 d4 e2 d b r1
    g'4 e2 e4 c2 a4 d2 d4 b2 g4 a2 d d
    d c b4 e2 fis4 g2 e4 f2 e4 e8 [ \m d ] cis4 \me d2 b r
    d d d4 c2 b r4 d4. \m e8 \me f4 e4. \m f8 \me g4 f2 f e r4
    %25
    d4 cis2 d4 d2 d b a4 g8 [ \m a ] b4 \me c b2 d d\longa*1/2^\fermata 
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pléin' è^t saÂ bùÿ -- çe d'in -- juÂr' ùÿ -- traj' éÿ tréi -- zon.
  %De sùs sa lang' è^t tùt pro -- pôs véin éÿ pèr -- vèrs.
  Il è^t an an -- bu^ç' ôá çe -- "mins :" é viént mör -- triér
  Kù -- rant d'a -- gètã sur l'in -- no -- sant. I sont ôá gètã
  Sez iö^s ka -- çés de -- sus le sù -- fre -- tös pas -- sant.
  Kù -- vèrt an an -- bu^ç' éin -- si k'un lìå -- on jìî -- zant
  De -- dans sa taÿ -- niér' il se tiént vé -- £ant ôá gètã
  Pùr l'a -- fli -- jé prandr' a -- tra -- pé de -- dans "sè_" rès.
  Se sèrr' é tréìÎn' é fètã le dùs, a -- fin k'il vøÎ
  "Dè_" pôÎ -- vresÄ çør la ban -- de dans la méin "dè_" fôrs.
  Puis dans le kör dit, Diö ne s'an sù -- vién -- "dra-" -- "pas :"
  É son re -- gard kaç', éÿ ja -- mès n'i vién -- dra vør.
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key c \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c  \major
    \clef "G_8"
    s2 s s4 s2 s4 s2 s4 s2 s s s s
    %15
    g4 c2 d4 e2 c f e4 d2 c e d c r
    c4 a2 g4 g2 g g8 [ \m f ] e4 \me a a2 b4 d2 c8 [ \m d ] e4 \me e2 r4
    e4 d2 g,4 g2 a a d4 cis2 a4 e'2 d4 \m c \me b2 r4
    b4 g2 g4 e2 e4 g2 f4 d2 d4 d2 bes' a r4
    b4 g2 a4 a2 g e g4 g2 b4 b2 fis g
    %20
    d4 g2 d4 e \m fis \me g2 g2 g4 g2 a4 g4. \m f8 \me e2 d
    bes' a a4 d,2 g4 \m a \me bes2 #(set-accidental-style 'no-reset) bes4 #(set-accidental-style 'forget)a2 g4 g2 fis g r1
    b4 g2 g4 e2 e4 g2 f4 d2 d4 d2 bes' a
    b g4. \m a8 \me b4 b2 d4 d2 c8 \m b \me c2 c4 b \m a8 [ g ] \me a2 g r
    a g d4 g2 g r4 b2 d4 c8 [ \m d ] e4 \me e c \m b8 [ a ] \me b2 c2 r4
    %25
    a4 a2 f4 bes2 a g d'4 b2 g4 g2 a b\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De sùs sa lang' è^t tùt pro -- pôs véin éÿ pèr -- vèrs.
  Il è^t an an -- bu^ç' ôá çe -- "mins :" é viént mör -- triér
  Kù -- rant d'a -- gètã sur l'in -- no -- sant. I sont ôá gètã
  Sez iö^s ka -- çés de -- sus le sù -- fre -- tös pas -- sant.
  Kù -- vèrt an an -- bu^ç' éin -- si k'un lìå -- on jìî -- zant
  De -- dans sa taÿ -- niér' il se tiént vé -- £ant ôá gètã
  Pùr l'a -- fli -- jé prandr' a -- tra -- pé de -- dans "sè_" rès.
  Se sèrr' é tréìÎn' é fètã le dùs, a -- fin k'il vøÎ
  "Dè_" pôÎ -- vresÄ çør la ban -- de dans la méin "dè_" fôrs.
  Puis dans le kör dit, Diö ne s'an sù -- vién -- "dra-" -- "pas :"
  É son re -- gard kaç', éÿ ja -- mès n'i vién -- dra vør.
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f" 
      \key c \major \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "bass"
    s2 s s4 s2 s4 s2  s4 s2 s s s s 
    %15
    g'4 e4. \m f8 \me d4 c2 f \bar "" d c4 g'2 a a8 [ \m g ] c4 \me b8 [ \m a ] b4 \me c2 r
    c,4 d2 g4 e2 b c d4 a2 e'4 d2 \bar "" a' e r4
    a,4 d2 b4 c2 a f' g4 a2 d,4 e2 fis g r4
    g4 c,2 e4 a,2 \bar "" a4 b2 d4 g,2 g4 fis2 g d' r4
    g4 c,2 a4 d2 g, a e'4 c2 g'4 e2 d b
    %20
    b4 c2 \bar "" b4 a2 g c g'4 e2 d4 g,2 a a'
    g d a4 b2 c g g'4 fis2 \bar "" g4 c,2 d g, r1
    g'4 c,2 e4 a,2 a4 b2 d4 g,2 g4 fis2 g d'
    g c, g'4 e2 \bar "" d4 g2 g4 f2 c4 e2 d g, r
    d' b b4 c2 g r4 g'2 d4 a'2 e4 \bar "" f2 d c r4
    %25
    d4 a2 bes4 g2 d' e fis4 g2 c,4 e2 d g,\longa*1/2^\fermata \bar"||"
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %Pléin' è^t saÂ bùÿ -- çe d'in -- juÂr' ùÿ -- traj' éÿ tréi -- zon.
  De sùs sa lang' è^t tùt pro -- pôs véin éÿ pèr -- vèrs.
  Il è^t an an -- bu^ç' ôá çe -- "mins :" é viént mör -- triér
  Kù -- rant d'a -- gètã sur l'in -- no -- sant. I sont ôá gètã
  Sez iö^s ka -- çés de -- sus le sù -- fre -- tös pas -- sant.
  Kù -- vèrt an an -- bu^ç' éin -- si k'un lìå -- on jìî -- zant
  De -- dans sa taÿ -- niér' il se tiént vé -- £ant ôá gètã
  Pùr l'a -- fli -- jé prandr' a -- tra -- pé de -- dans "sè_" rès.
  Se sèrr' é tréìÎn' é fètã le dùs, a -- fin k'il vøÎ
  "Dè_" pôÎ -- vresÄ çør la ban -- de dans la méin "dè_" fôrs.
  Puis dans le kör dit, Diö ne s'an sù -- vién -- "dra-" -- "pas :"
  É son re -- gard kaç', éÿ ja -- mès n'i vién -- dra vør.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.3 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.2 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.4 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #5.6 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
  \include "../include/layout001.ly"
  \header {
    piece = \markup \bold "Seconde partie"
  }
}


% Troisieme partie

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key c \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d''4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key c \major
    \clef "treble"
    \cadenzaOn
    d4^\markup \small "26" c b2 g4 bes2 a r4 b2 c4 d2 c4 a2 bes g r4
    a2^\markup \small "27" f g4 e2 d2 r4 d2 g4 e2 a4 g2 a b r1
    d2^\markup \small "28" d cis4 d2 b g g4 c2 b4 a2 a fis r4
    a2^\markup \small "29" g f4 e2 d g2 f4 e2 d4 g2 a b r4
    d,2^\markup \small "30" g a4 b2 g c b4 a2 g4 f2 bes a r4
    d4^\markup \small "31" b2 d4 c2 a4 b2 c4 d8 [ \m c b a ] \me g4 b2 a g r1
    g4^\markup \small "32" f2 d4 e2 d a' g4 f2 e4 d2 g fis r4
    g2^\markup \small "33" a c4 b2 d4 c2 b4 a2 b4 c2 d g, r4
    g4^\markup \small "34" f2 e4 d2 d'4 c2 b4 a2 g4 b2 a g\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Le -- ve tø Si -- ñör "Diö ." éÿ le -- vant ta méin, n'ù -- bli
  Lès pôÎ -- vresÄ vék -- "sés ." kar le fôsã mé -- çant, pùr -- "kø ?"
  Pùr kø le pèr -- vèrs Diö mé -- "tra-" -- "t-il" an kùr -- rùs
  Ôá kör se Di -- "zant ?" Tuÿ ne vös t'an an -- kè^ -- "tér ?"
  Pùr -- vrè tu "l'a^_" "vu ." kar tu vøs é lör fôr -- fèt
  É lör ù -- tra -- je, pùr le mè -- treã dan "tè_" "méins ."
  Le pôÎ -- vre tan -- dis tùt se lès -- se tùt sur "tø :"
  Sur tø ki prans de l'ôr -- fe -- lin la gard' an méin.
  É tø tu ès de l'ôr -- fe -- lin le pront éi -- dör.
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key c \major \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "G_8"
    d4 e g4. \m f8 \me e4 d8 [ \m e16 f ] g4 \me fis2 r4 d2 a'4 g2 e4 f2 d e r4
    c4 \m b8 [ a ] \me d2 d4 cis2 d r4 g,4. \m a8 \me b4 c2 d4 e2 d g r1
    fis2 d a'4 fis2 g e4. \m f8 \me g4 a2 g4 f2 e d r4
    a2 d d4 c2 b  d d4 e8 [ \m d ] c4 \me d4 e2 fis g r4
    %30
    b,2 e fis4 g2 e a d,8 [ \m e ] \me f2 e8 [ \m d ] \me c2 g' e r4
    fis4 g2 g4 e2 f4 d \m e \me e g4. \m f8 \me e4 d2 d b r1
    d4 d2 b4 c2 b c b4 a2 g8 [ \m a ] \me b [ \m c ] d4 \me cis2 d r4
    d2 f e4 e2 d4 e2 g4 fis2 g4 a2 f e r4
    e4 c2 c4 b2 d4 e2 g4 f2 e4 d2 d d\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Le -- ve tø Si -- ñör "Diö ." éÿ le -- vant ta méin, n'ù -- bli
  Lès pôÎ -- vresÄ vék -- "sés ." kar le fôsã mé -- çant, pùr -- "kø ?"
  Pùr kø le pèr -- vèrs Diö mé -- "tra-" -- "t-il" an kùr -- rùs
  Ôá kör se Di -- "zant ?" Tuÿ ne vös t'an an -- kè^ -- "tér ?"
  Pùr -- vrè tu "l'a^_" "vu ." kar tu vøs é lör fôr -- fèt
  É lör ù -- tra -- je, pùr le mè -- treã dan "tè_" "méins ."
  Le pôÎ -- vre tan -- dis tùt se lès -- se tùt sur "tø :"
  Sur tø ki prans de l'ôr -- fe -- lin la gard' an méin.
  É tø tu ès de l'ôr -- fe -- lin le pront éi -- dör.
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key c \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      c'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c  \major
    \clef "G_8"
    s4 s s2 c4  g2 d' r4 g,2 a4 b2 c4 d2 g, c r4
    f,2 bes g4 \bar "" a2 d,2 s4 s2 s4 s2 s4 s2 s s s1
    a'2 b e4 d2 d c8 [ \m d ] e4 \me d e2 e4 c8 [ \m a ] d4 \me cis2 a r4
    fis2 g d4 g2 g b a8 [ \m b ] \me c2 b8 [ \m a ] \me b2 d d r4
    %30
    g,2 b d4 d2 c e,4. \m f8 \me g4 a4. \m b8 \me c4 a2 d cis r4
    a4 e'2 d4 g,2 d'8 [ \m c ] \me b [ \m a ] g4 \me g d2 e4 g2 fis g r1
    b4 a2 g4 g2 g e4. \m fis8 \me g4 c2 c4 b2 e2 a, r4
    b2 a a4 g2 g4 g2 d'4 d2 d4 a8 [ \m b ] c4 \me b8 [ \m a ] b4 \me c2 r4
    b4 a2 g4 g2 g4 g2 d'4 d8 [ \m c a b ] \me c4 b \m a8 [ g ] \me a2 b\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Si -- ñör "Diö ." éÿ le -- vant ta méin, n'ù -- bli
  Lès pôÎ -- vresÄ vék -- "sés ."
  Pùr kø le pèr -- vèrs Diö mé -- "tra-" -- "t-il" an kùr -- rùs
  Ôá kör se Di -- "zant ?" Tuÿ ne vös t'an an -- kè^ -- "tér ?"
  Pùr -- vrè tu "l'a^_" "vu ." kar tu vøs é lör fôr -- fèt
  É lör ù -- tra -- je, pùr le mè -- treã dan "tè_" "méins ."
  Le pôÎ -- vre tan -- dis tùt se lès -- se tùt sur "tø :"
  Sur tø ki prans de l'ôr -- fe -- lin la gard' an méin.
  É tø tu ès de l'ôr -- fe -- lin le pront éi -- dör.
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f" 
      \key c \major \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "bass"
    s4 s s2 s4 s2 s2 s4 s2 s4 s2 s4 s2 s s s4
    s2 s s4 s2 s s4 s2 s4 s2 s4 s2 s s s1
    d2 g a4 b2 g c b4 a2 e4 \bar "" f4. \m g8 \me a2 d, r4
    d2 b b4 c2 g g' d4 a'2 f4 e2 d g r4
    %30
    g2 e d4 g2 \bar "" c, a g4 d'2 e4 f2 g a r4
    d,4 e2 b4 c2 d4 g8 [ \m f e d ] \me c4 b2 c4 g8 [ \m a b c ] \me d2 \bar "" g, r1
    g'4 d2 g,4 c2 g a e'4 f2 c4 g'2 e d r4
    g2 d a4 e'2 b4 c2 \bar "" g4 d'2 g4 f4. \m e8 \me d2 c r4
    e4 f2 c4 g2 b4 c2 g4 d'2 e4 g2 fis g\longa*1/2^\fermata \bar "||"
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pùr kø le pèr -- vèrs Diö mé -- "tra-" -- "t-il" an kùr -- rùs
  Ôá kör se Di -- "zant ?" Tuÿ ne vös t'an an -- kè^ -- "tér ?"
  Pùr -- vrè tu "l'a^_" "vu ." kar tu vøs é lör fôr -- fèt
  É lör ù -- tra -- je, pùr le mè -- treã dan "tè_" "méins ."
  Le pôÎ -- vre tan -- dis tùt se lès -- se tùt sur "tø :"
  Sur tø ki prans de l'ôr -- fe -- lin la gard' an méin.
  É tø tu ès de l'ôr -- fe -- lin le pront éi -- dör.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.3 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.2 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.5 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #5.6 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001.ly"
  \header {
    piece = \markup \bold "Troisieme partie"
  }
}

% Dernière partie


discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key c \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d''2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key c \major
    \clef "treble"
    \cadenzaOn
    d2^\markup \small "35" b c4 d2 g,8 [ \m a b c ] \me b2 a4 g2 e4 d2 g fis r4
    g4^\markup \small "36" a2 g4 c2 b4^\markup \bold "*" c2 a4 d2 g,4 b2 a g r4
    g4^\markup \small "37" f2 d4 e2 d a' g4 f2 e4 d2 g fis r4
    a2^\markup \small "38" a g4 f2 f e a4 g2 g4 e2 a d,2 r1
    b'2^\markup \small "39" a g4 c2 b c d4 e2 a,4 d2 cis d s4
    s2^\markup \small "40" s s4 s2 s s s4 s2 s4 s2 s s s1
    d2^\markup \small "41" c b4 a2 c b a4 g2 g4 a2 bes a r4
    d,4^\markup \small "42" g4^\markup \bold "*" f4 d e2 d4 f2 g4 a2 g b a g r4
    f4^\markup \small "42b" d8^\markup \bold "*" [ \m e8 ] \me f4 g a2 f4 a2 c4 c2 c d d b\longa*1/2^\fermata
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Ôá fôsã é pèr -- vèrs ron le bras. Si son fôr -- fèt
  Tu vas re -- çèr -- çér il ne kon -- pa -- rø -- "tra-" -- pas.
  Il è^t le Séi -- ñör pùr ja -- mès é Rø san "fin :"
  É lès pa -- iéns sont môrs "de-" -- sur la tèrr' ô -- "tés :"
  "Dè_" pô -- vresÄ Séi -- ñör lès sù -- hès, tu lèz or -- "ras :"
  Pùr fè -- re drøtã ôz ôr -- fe -- lins é "ô_" vék -- sés,
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér.
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér. 
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key c \major \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "G_8"
    %35
    d2 g e4 f2 e d8 [ \m e fis g ] \me fis4 g2 g,4 b2 b4 \m cis \me d2 r4
    e4 c4. \m d8 \me e4 f8 [ \m e ] a4 \me gis^\markup \bold "*" a2 fis4 g4. \m f8 \me e4 d8 [ \m e16 f ] g4 \me fis2 g r4
    d4 d2 b4 c2 b c b4 a2 g8 [ \m a ] \me b [ \m c ] d4 \me cis8 [ \m b ] cis4 \me d2 r4
    f2 e e4 c2 d g, e'4 e2 d4 c2 c b r1
    g'2 f d4 e \m fis \me g2 e d4 g2 f4 f \m e8 [ d ] \me e2 d r4
    %40
    f2 d c4 f2 e f g4 a2 d,4 g2 fis g r1
    d2 e g4 fis2 a g f4 e2 d4 d2 g fis r4
    b,4 b8^\markup \bold "*" [ \m cis8 ] \me d4 b c2 b4 d2 c4 f2 e g fis d r4
    d4 bes4^\markup \bold "*" a4 d cis2 d4 d2 e4 f2 e d8 [ \m e16 f ] g4 \me fis2 g\longa*1/2^\fermata %42b
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Ôá fôsã é pèr -- vèrs ron le bras. Si son fôr -- fèt
  Tu vas re -- çèr -- çér il ne kon -- pa -- rø -- "tra-" -- pas.
  Il è^t le Séi -- ñör pùr ja -- mès é Rø san "fin :"
  É lès pa -- iéns sont môrs "de-" -- sur la tèrr' ô -- "tés :"
  "Dè_" pô -- vresÄ Séi -- ñör lès sù -- hès, tu lèz or -- "ras :"
  Lö^ körs a -- prè -- tras, éÿ l'o -- rè -- £e lör tan -- dras,
  Pùr fè -- re drøtã ôz ôr -- fe -- lins é "ô_" vék -- sés,
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér.
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér. 
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key c \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      c4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c  \major
    \clef "G_8"
    %35
    s2 s s4 s2 s s s4 s2 c,4 g'2 e d r4
    c f2 c'4 a2 \bar "" e'4^\markup \bold "*" a,2 d4 b2 c4 g2 d' g, r4
    b a2 g4 g2 g e4. \m fis8 \me g4 c2 c4 b2 e a, r4
    d2 c b4 a2 b c c4 b2 b4 g8 [ \m a ] g4 \me fis8 [ \m e ] fis4 \me g2 r1
    g2 d'4. \m c8 \me \bar "" b4 a2 g a b4 c2 d4 bes2 a d, r4
    %40
    a'2 b g4 a \m b \me c2 a g4 c2 b4 b \m a8 [ g ] \me a2 g r1
    b2 g d'4 d2 e e c4 c2 b4 a2 d d r4
    g,4 g4^\markup \bold "*" a4 g g2 g4 a2 g4 c2 c d d b r4
    a4 g4^\markup \bold "*" f4 d e2 d4 f2  g4 a2 g bes a g\longa*1/2^\fermata %42b
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Si son fôr -- fèt
  Tu vas re -- çèr -- çér il ne kon -- pa -- rø -- "tra-" -- pas.
  Il è^t le Séi -- ñör pùr ja -- mès é Rø san "fin :"
  É lès pa -- iéns sont môrs "de-" -- sur la tèrr' ô -- "tés :"
  "Dè_" pô -- vresÄ Séi -- ñör lès sù -- hès, tu lèz or -- "ras :"
  Lö^ körs a -- prè -- tras, éÿ l'o -- rè -- £e lör tan -- dras,
  Pùr fè -- re drøtã ôz ôr -- fe -- lins é "ô_" vék -- sés,
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér.
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér. 
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f" 
      \key c \major \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key c \major
    \clef "bass"
    %35
    s2 s s4 s2 s s s4 s2 s4 s2 s s s4
    s4 s2 s4 s2 s4 s2 s4 s2 s4 s2 s s s4
    g'4 d2 g,4 c2 g a e'4 f2 c4 g'2 e \bar "" d r4
    d2 a' e4 f2 d c a4 e'2 b4 c2 a g s1
    s2 s s4 s2 s s s4 s2 s4 s2 s s s4
    %40
    d'2 g4. \m f8 \me e4 d2 c d e4 f2 \bar "" g4 e2 d g, r1
    g'2 c, g4 d'2 a e' f4 c2 g'4 fis2 g d r4
    g4 e4^\markup \bold "*" d4 g, c2 g4 \bar "" d'2 e4 f2 c g' d g, r4
    d'4 g,^\markup \bold "*" d'4 bes a2 a'4 d,2 c4 f2 c g' d g,\longa*1/2^\fermata \bar "|." %42b
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Il è^t le Séi -- ñör pùr ja -- mès é Rø san "fin :"
  É lès pa -- iéns sont môrs "de-" -- sur la tèrr' ô -- "tés :"
  Lö^ körs a -- prè -- tras, éÿ l'o -- rè -- £e lör tan -- dras,
  Pùr fè -- re drøtã ôz ôr -- fe -- lins é "ô_" vék -- sés,
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér.
  Ke l'o -- me de tèr -- re plus ne lès puiss' é -- frûi -- ér. 
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.3 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.1 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.4 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #5.5 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001.ly"
  \header {
    piece = \markup \bold "Derniere partie"
  }
}
