global = {
  #(set-accidental-style 'forget)
  \once \override Staff.Clef #'full-size-change = ##t
  \set Staff.forceClef = ##t
  \set Score.defaultBarType = "empty"
  \time 4/4
  \override Voice.NoteHead #'style = #'baroque
  \override Score.BarNumber #'padding = #3
}

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-g" 
      \key f \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      c''2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c2^\markup \small "1" a4 a f2 g8 [ \m a ] bes4 \me a2 c4 bes bes2 a4 g2 r4
    a2^\markup \small "2" a4 f8 [ \m g a g ] \me a [ \m bes ] \me c2 c r
    f,^\markup \small "3" a c bes4 a g2 a4 d c2 bes 4 a2 r4
    bes2^\markup \small "4" c4 d4. \m c8 \me c4 b2 c r1
    c2^\markup \small "5" a4 a4 g2 a4 f c'4. \m d8 \me e4 f8 [ \m e ] \me d [ \m c ] d4 \me c b2 r4
    c2^\markup \small "6" c4 d4. \m e8 \me f4 e8 [ \m d ] e4 \me f2 r
    c4^\markup \small "7" \m d8 [ e ] \me f2 e2 f4 e d2 c4 bes a2 d4 cis2 r4
    d2^\markup \small "8" bes4 g2 c4 bes2 a r1
    f'2^\markup \small "9" d4 d c2 d8 [ \m e ] \me f4 e2 f4 c d2 c4 b2 r4
    c2^\markup \small "10" a4 f2 g4 d'2 g,2 r
    \repeat volta 2 {
      f2^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "11"} a4 bes g2 a4 a f2 a4 c c2 d4 e2 r4 
      f2^\markup \small "12" d4 c2 b4 c2 a\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  FÔÎT KE de tùt mon kör le Si -- ñör je "lù^ :"
  Il me fôÎt le çan -- tér.
  Tùs tès tèr -- ri -- blesÄ fès je dé -- non -- bre -- rè
  Tès mi -- ra^ -- klesÄ kon -- tant.
  Gran -- de fe -- rè l'a -- lé -- gréss', é m'é -- gèi -- e -- rè
  Sô -- te -- lant tùt an "tø :"
  ÔÎ "Trè_" hôÎt, so -- ne -- rè ké -- ke jö ga -- £ard
  An l'o -- nör de ton nom.
  Éin -- si ke mèz a -- ne -- mis s'an i -- ront ça -- sés,
  Kul -- bu -- tés an ar -- riér',
  Ös s'an i -- ront tre -- bu -- "çant :" é da -- vant ta fass'
  Il se -- ront dé -- kon -- fis.
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c2" 
      \set Staff.keySignature = #`(((-1 . 6) . ,FLAT)
                                   ((0 . 6) . ,FLAT))
      \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    g2 f4 c d2 d4. \m e8 \me f2 g4 f g2 f4 e2 r4
    f2 c4 d8 [ \m e ] f4 \me f g2 a r
    d, f e g4 c, c8 [ \m d ] e4 \me f4 a a2 g4 e2 r4
    g2 a4 a2 g4 g2 e r1
    %5
    g2 f4 f e2 f4 d a'2 bes4 c bes4. \m a8 \me g [ \m f ] \me g2 r4
    g2 f4 bes2 a8 [ \m bes ] \me c2 c r
    f,8 [ \m g ] a4 \me a4. \m bes8 \me c2 c4 c bes2 a4 f f2 a4 a2 r4
    a2 g4 e2 a4 g2 fis r1
    a2 bes4 f8 [ \m g ] \me a2 bes4 c c2 a4 a bes2 g4 g2 r4
    %10
    e2 f4 c2 c4 f2 e r
    \repeat volta 2 {
      c^\markup \musicglyph #"scripts.usignumcongruentiae" f4 g e2 f4 f d2 f4 g a2 a8 [ \m b ] \me c2 r4
      c2 bes4 a4. \m g8 \me f4 e2 c\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  FÔÎT KE de tùt mon kör le Si -- ñör je "lù^ :"
  Il me fôÎt le çan -- tér.
  Tùs tès tèr -- ri -- blesÄ fès je dé -- non -- bre -- rè
  Tès mi -- ra^ -- klesÄ kon -- tant.
  Gran -- de fe -- rè l'a -- lé -- gréss', é m'é -- gèi -- e -- rè
  Sô -- te -- lant tùt an "tø :"
  ÔÎ "Trè_" hôÎt, so -- ne -- rè ké -- ke jö ga -- £ard
  An l'o -- nör de ton nom.
  Éin -- si ke mèz a -- ne -- mis s'an i -- ront ça -- sés,
  Kul -- bu -- tés an ar -- riér',
  Ös s'an i -- ront tre -- bu -- "çant :" é da -- vant ta fass'
  Il se -- ront dé -- kon -- fis.
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key f \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      e'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    e2 c4 f8 [ \m e ] \me d [ \m c ] bes4 \me bes2 c4. \m d8 \me es4 d8 [ \m c ] \me bes [ \m a ] g4 \me c c2 r4
    c2 a4 bes8 [ \m a16 g ] f4 \me f' e8 [ \m d ] e4 \me f2 r
    bes,8 [ \m c ] d4 \me c2 c d8 [ \m e ] \me f4 e2 c4 f f4. \m e8 \me d4 cis2 r4
    d2 f4 f2 e4 d2 c r1
    %5
    e2 c4 c c2 c4 d e4. \m f8 \me g4 a f2 e4 d2 r4
    e2 c4 f2 f4 g2 a r
    a4. \m g8 \me f2 g a4 g g4. \m f8 \me e4 d c2 f4 e2 r4
    f2 d4 c8 [ \m d ] e4 \me f d2 d r1
    d8 [ \m e ] f4 \me f d e2 g4 a g2 f4 f f2 e4 d2 r4
    %10
    c2 c4 a2 g4 a \m b \me c2 r
    \repeat volta 2 {
      a2^\markup \musicglyph #"scripts.usignumcongruentiae" d4 d c2 c4 d a2 d4 e f2 f4 e2 r4
      a2 g4 e2 f4 g2 f\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  FÔÎT KE de tùt mon kör le Si -- ñör je "lù^ :"
  Il me fôÎt le çan -- tér.
  Tùs tès tèr -- ri -- blesÄ fès je dé -- non -- bre -- rè
  Tès mi -- ra^ -- klesÄ kon -- tant.
  Gran -- de fe -- rè l'a -- lé -- gréss', é m'é -- gèi -- e -- rè
  Sô -- te -- lant tùt an "tø :"
  ÔÎ "Trè_" hôÎt, so -- ne -- rè ké -- ke jö ga -- £ard
  An l'o -- nör de ton nom.
  Éin -- si ke mèz a -- ne -- mis s'an i -- ront ça -- sés,
  Kul -- bu -- tés an ar -- riér',
  Ös s'an i -- ront tre -- bu -- "çant :" é da -- vant ta fass'
  Il se -- ront dé -- kon -- fis.
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key f \major \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      c'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    c'2 f,4 a bes4. \m a8 \me g [ \m f ] g4 \me f4 \m e8 [ d ] \me c4 d es2 f4 c2 r4
    f2 f4 d2 \bar "" d'4 c2 f, r
    bes f a g4 f c'2 f,4 d f2 g4 a2 r4
    g2 f4 d8 [ \m e ] f4 \me c g'2 \bar "" c, r1
    %5
    c'2 f,4 f c2 f4 bes a2 g4 f bes2 c4 g2 r4
    c2 a4 bes2 d4 c2 f, r \bar ""
    f'4. \m e8 \me d [ \m c ] d4 \me c2 f,4 c' g2 a4 bes f2 d4 a'2 r4
    d2 g,4 c2 f,4 g2 d r1
    d'2 \bar "" bes4 bes a2 g4 f c'2 d8 [ \m e ] \me f4 bes,2 c4 g2 r4
    %10
    a2 f4 f2 e4 d2 c2 r 
    \repeat volta 2 {
      f^\markup \musicglyph #"scripts.usignumcongruentiae" d4 g c,2 f4 d d2 d4 c f2 d4 a'2 r4
      f2 g4 a8 [ \m bes ] c4 \me d c2 f,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  FÔÎT KE de tùt mon kör le Si -- ñör je "lù^ :"
  Il me fôÎt le çan -- tér.
  Tùs tès tèr -- ri -- blesÄ fès je dé -- non -- bre -- rè
  Tès mi -- ra^ -- klesÄ kon -- tant.
  Gran -- de fe -- rè l'a -- lé -- gréss', é m'é -- gèi -- e -- rè
  Sô -- te -- lant tùt an "tø :"
  ÔÎ "Trè_" hôÎt, so -- ne -- rè ké -- ke jö ga -- £ard
  An l'o -- nör de ton nom.
  Éin -- si ke mèz a -- ne -- mis s'an i -- ront ça -- sés,
  Kul -- bu -- tés an ar -- riér',
  Ös s'an i -- ront tre -- bu -- "çant :" é da -- vant ta fass'
  Il se -- ront dé -- kon -- fis.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.8 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.8 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.2 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #5.4 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001.ly"
   \header {
     filename =  "009fautQueDeTout.ly"
     title = "Psaume IX"
     subtitle =	" "
     opus = " "
     composer = "Claude Le Jeune"
     poet = "Jean-Antoine de Baïf (1573)"
   }
}

%% Strophes 3-4

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c2^\markup \small "13" a4 a f2 g8 [ \m a ] \me bes4 a2 c4 bes bes2 a4 g2 r4
    a2^\markup \small "14" a4 f8 [ \m g a g ] \me a [ \m bes ] \me c2 c r
    f,^\markup \small "15" a c bes4 a g2 a4 d c2 bes 4 a2 r4
    bes2^\markup \small "16" c4 d4. \m c8 \me c4 b2 c r1
    c2^\markup \small "17" a4 a4 g2 a4 f c'4. \m d8 \me e4 f8 [ \m e ] \me d [ \m c  ]d4 \me c b2 r4
    c2^\markup \small "18" c4 d4. \m e8 \me f4 e8 [ \m d ] e4 \me f2 r
    c4^\markup \small "19" \m d8 [ e ] \me f4^\markup \bold "*" f e2 f4 e d2 c4 bes a2 d4 cis2 r4
    d2^\markup \small "20" bes4 g2 c4 bes2 a r1
    f'2^\markup \small "21" d4 d c2 d8 [ \m e ] \me f4 e2 f4 c d2 c4 b2 r4
    c2^\markup \small "22" a4 f2 g4 d'2 g,2 r
    \repeat volta 2 {
      f2^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "23"} a4 bes g2 a4 a f2 a4 c c2 d4 e2 r4 
      f2^\markup \small "24" d4 c2 b4 c2 a\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar de ma kôÎ -- ze le drøt tu ju -- jas, séæ -- ant
  Jus -- te juÿ -- je sur nùs.
  Tan -- sas lès na -- si -- "ons :" é le fôÊs mé -- çant
  Sus -- de -- sùs dé -- trui -- "zis :"
  Vø -- re tu as a -- ja -- mès a -- bo -- li du -- tùt
  Lör mé -- mør' é lör nom.
  ÔÎ a -- ne -- mi, tù -- le ga^t a -- ja -- mès a pris
  Tè -- le fin kom' ont pris
  Lès vi -- lesÄ k'a^s ru -- ìå -- né^s. La mé -- mø -- re d'ös
  È^t pé -- rìî' a -- vèk ös.
  Mèsã le Si -- ñör a -- ja -- mès i de -- mö -- "rera :"
  Son si -- èæj' i tiént "prè^t :"
}

altusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    g2 f4 c d2 d4^\markup \bold "*" d8 [ \m e8 ] \me f2 g4 f g2 f4 e2 r4
    f2 c4 d8 [ \m e ] f4 \me f g2 a r
    %15
    d, f e g4 c, c8 [ \m d ] e4 \me f4 a a2 g4 e2 r4
    g2 a4 a2 g4 g2 e r1
    g2 f4 f e2 f4 d a'2 bes4 c bes4. \m a8 \me g [ \m f ] \me g2 r4
    g2 f4 bes2 a8 [ \m bes ] \me c2 c r
    f,8 [ \m g ] a4 \me a4^\markup \bold "*" a8 [ \m bes8 ] \me c2 c4 c bes2 a4 f f2 a4 a2 r4
    %20
    a2 g4 e2 a4 g2 fis r1
    a2 bes4 f8 [ \m g ] \me a2 bes4 c c2 a4 a bes2 g4 g2 r4
    e2 f4 c2 c4 f2 e r
    \repeat volta 2 {
      c^\markup \musicglyph #"scripts.usignumcongruentiae" f4 g e2 f4 f d2 f4 g a2 a8 [ \m b ] \me c2 r4
      c2 bes4 a4. \m g8 \me f4 e2 c\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar de ma kôÎ -- ze le drøt tu ju -- jas, séæ -- ant
  Jus -- te juÿ -- je sur nùs.
  Tan -- sas lès na -- si -- "ons :" é le fôÊs mé -- çant
  Sus -- de -- sùs dé -- trui -- "zis :"
  Vø -- re tu as a -- ja -- mès a -- bo -- li du -- tùt
  Lör mé -- mør' é lör nom.
  ÔÎ a -- ne -- mi, tù -- le ga^t a -- ja -- mès a pris
  Tè -- le fin kom' ont pris
  Lès vi -- lesÄ k'a^s ru -- ìå -- né^s. La mé -- mø -- re d'ös
  È^t pé -- rìî' a -- vèk ös.
  Mèsã le Si -- ñör a -- ja -- mès i de -- mö -- "rera :"
  Son si -- èæj' i tiént "prè^t :"
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    e2 c4 f8 [ \m e ] \me d [ \m c ] bes4 \me bes^\markup \bold "*" bes c4. \m d8 \me es4 d8 [ \m c ] \me bes [ \m a ] g4 \me c c2 r4
    c2 a4 bes8 [ \m a16 g ] f4 \me f' e8 [ \m d ] e4 \me f2 r
    %15
    bes,8 [ \m c ] d4 \me c2 c d8 [ \m e ] \me f4 e2 c4 f f4. \m e8 \me d4 cis2 r4
    d2 f4 f2 e4 d2 c r1
    e2 c4 c c2 c4 d e4. \m f8 \me g4 a f2 e4 d2 r4
    e2 c4 f2 f4 g2 a r
    a4. \m g8 \me f4^\markup \bold "*" f g2 a4 g g4. \m f8 \me e4 d c2 f4 e2 r4
    %20
    f2 d4 c8 [ \m d ] e4 \me f d2 d r1
    d8 [ \m e ] f4 \me f d e2 g4 a g2 f4 f f2 e4 d2 r4
    c2 c4 a2 g4 a \m b \me c2 r
    \repeat volta 2 {
      a2^\markup \musicglyph #"scripts.usignumcongruentiae" d4 d c2 c4 d a2 d4 e f2 f4 e2 r4
      a2 g4 e2 f4 g2 f\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar de ma kôÎ -- ze le drøt tu ju -- jas, séæ -- ant
  Jus -- te juÿ -- je sur nùs.
  Tan -- sas lès na -- si -- "ons :" é le fôÊs mé -- çant
  Sus -- de -- sùs dé -- trui -- "zis :"
  Vø -- re tu as a -- ja -- mès a -- bo -- li du -- tùt
  Lör mé -- mør' é lör nom.
  ÔÎ a -- ne -- mi, tù -- le ga^t a -- ja -- mès a pris
  Tè -- le fin kom' ont pris
  Lès vi -- lesÄ k'a^s ru -- ìå -- né^s. La mé -- mø -- re d'ös
  È^t pé -- rìî' a -- vèk ös.
  Mèsã le Si -- ñör a -- ja -- mès i de -- mö -- "rera :"
  Son si -- èæj' i tiént "prè^t :"
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    c'2 f,4 a bes4. \m a8 \me g [ \m f ] \me g4 f4 \m e8 [ d ] \me c4 d es2 f4 c2 r4
    f2 f4 d2 \bar "" d'4 c2 f, r
    %15
    bes f a g4 f c'2 f,4 d f2 g4 a2 r4
    g2 f4 d8 [ \m e ] f4 \me c g'2 \bar "" c, r1
    c'2 f,4 f c2 f4 bes a2 g4 f bes2 c4 g2 r4
    c2 a4 bes2 d4 c2 f, r \bar "" 
    f'4. \m e8 \me d [ \m c ] \me d4 c2 f,4 c' g2 a4 bes f2 d4 a'2 r4
    %20
    d2 g,4 c2 f,4 g2 d r1
    d'2 \bar "" bes4 bes a2 g4 f c'2 d8 [ \m e ] \me f4 bes,2 c4 g2 r4
    a2 f4 f2 e4 d2 c2 r \bar "|:"
    \repeat volta 2 {
      f^\markup \musicglyph #"scripts.usignumcongruentiae" d4 g c,2 f4 d d2 d4 c f2 d4 a'2 r4
      f2 g4 a8 [ \m bes ] c4 \me d c2 f,\longa*1/2^\fermata \bar ":|"
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar de ma kôÎ -- ze le drøt tu ju -- jas, séæ -- ant
  Jus -- te juÿ -- je sur nùs.
  Tan -- sas lès na -- si -- "ons :" é le fôÊs mé -- çant
  Sus -- de -- sùs dé -- trui -- "zis :"
  Vø -- re tu as a -- ja -- mès a -- bo -- li du -- tùt
  Lör mé -- mør' é lör nom.
  ÔÎ a -- ne -- mi, tù -- le ga^t a -- ja -- mès a pris
  Tè -- le fin kom' ont pris
  Lès vi -- lesÄ k'a^s ru -- ìå -- né^s. La mé -- mø -- re d'ös
  È^t pé -- rìî' a -- vèk ös.
  Mèsã le Si -- ñör a -- ja -- mès i de -- mö -- "rera :"
  Son si -- èæj' i tiént "prè^t :"
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}

%% Strophes 5-6
discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c2^\markup \small "25" a4 a f2 g8 [ \m a ] \me bes4 a2 c4 bes bes2 a4 g2 r4
    a2^\markup \small "26" a4 f8 [ \m g a g ] \me a [ \m bes ] \me c2 c r
    f,^\markup \small "27" a c bes4 a g2 a4 d c2 bes 4 a2 r4
    bes2^\markup \small "28" c4 d4. \m c8 \me c4 b2 c r1
    c2^\markup \small "29" a4 a4 g2 a4 f c'4. \m d8 \me e4 f8 [ \m e ] \me d [ \m c ] d4 \me c b2 r4
    c2^\markup \small "30" c4 d4. \m e8 \me f4 e8 [ \m d ] e4 \me f2 r
    c4^\markup \small "31" \m d8 [ e ] \me f4 f^\markup \bold "*" e2 f4 e d2 c4 bes a2 d4 cis2 r4
    d2^\markup \small "32" bes4 g2 c4 bes2 a r1
    f'2^\markup \small "33" d^\markup \bold "*" c2 d8 [ \m e ] \me f4 e2 f4 c d2 c4 b2 r4
    c2^\markup \small "34" a4 f2 g4 d'2 g,2 r
    \repeat volta 2 {
      f2^\markup{\musicglyph #"scripts.usignumcongruentiae"\small "35"} a4 bes g2 a2^\markup \bold "*" f2 a4 c c2 d4 e2 r4 
      f2^\markup \small "36" d4 c2 b4 c2 a\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Par -- se ke lui ju -- je -- ra se -- lon éÿ -- ki -- té
  Tùt le mond' a -- san -- blé.
  É "lè_" pö -- plez ù -- ìås ju -- je -- ra d'a -- rè^s
  Drû -- tu -- riérs é an -- tiérs.
  Vør' i se -- ra le Si -- ñör aã l'om' aÿ -- fli -- jé
  Son re -- fuÿ -- je sèr -- téin,
  "Dìî_" je re -- fuÿj' a pro -- pôs, si le tans le kiért,
  Ôá mi -- liö de l'an -- nui.
  É sur tø se fi -- ans se re -- pô -- ze -- ront
  Sös ki saÿ -- vetÄ ton nom.
  Ôs -- si ja -- mès, Séi -- ñör, tu n'a -- ban -- do -- nas
  Sös ki vont te çèr -- çér.
}

altusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    %25
    g2 f4 c d2 d4 d8^\markup \bold "*" [ \m e8 ]\me f2 g4 f g2 f4 e2 r4
    f2 c4 d8 [ \m e ] f4 \me f g2 a r
    d, f e g4 c, c8 [ \m d ] e4 \me f4 a a2 g4 e2 r4
    g2 a4 a2 g4 g2 e r1
    g2 f4 f e2 f4 d a'2 bes4 c bes4. \m a8 \me g [ \m f ] \me g2 r4
    %30
    g2 f4 bes2 a8 [ \m bes ] \me c2 c r
    f,8 [ \m g ] a4 \me a4 a8^\markup \bold "*" [ \m bes8 ] \me c2 c4 c bes2 a4 f f2 a4 a2 r4
    a2 g4 e2 a4 g2 fis r1
    a2 bes4 \m f8 [ g ] \me a2 bes4 c c2 a4 a bes2 g4 g2 r4
    e2 f4 c2 c4 f2 e r
    %35
    \repeat volta 2 {
      c^\markup \musicglyph #"scripts.usignumcongruentiae" f4 g e2 f2^\markup \bold "*" d2 f4 g a2 a8 [ \m b ] \me c2 r4
      c2 bes4 a4. \m g8 \me f4 e2 c\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Par -- se ke lui ju -- je -- ra se -- lon éÿ -- ki -- té
  Tùt le mond' a -- san -- blé.
  É "lè_" pö -- plez ù -- ìås ju -- je -- ra d'a -- rè^s
  Drû -- tu -- riérs é an -- tiérs.
  Vør' i se -- ra le Si -- ñör aã l'om' aÿ -- fli -- jé
  Son re -- fuÿ -- je sèr -- téin,
  "Dìî_" je re -- fuÿj' a pro -- pôs, si le tans le kiért,
  Ôá mi -- liö de l'an -- nui.
  É sur tø se fi -- ans se re -- pô -- ze -- ront
  Sös ki saÿ -- vetÄ ton nom.
  Ôs -- si ja -- mès, Séi -- ñör, tu n'a -- ban -- do -- nas
  Sös ki vont te çèr -- çér.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    %25
    e2 c4 f8 [ \m e ] \me d [ \m c ] bes4 \me bes4 bes^\markup \bold "*" c4. \m d8 \me es4 d8 [ \m c ] \me bes [ \m a ] g4 \me c c2 r4
    c2 a4 bes8 [ \m a16 g ] f4 \me f' e8 [ \m d ] e4 \me f2 r
    bes,8 [ \m c ] d4 \me c2 c d8 [ \m e ] \me f4 e2 c4 f f4. \m e8 \me d4 cis2 r4
    d2 f4 f2 e4 d2 c r1
    e2 c4 c c2 c4 d e4. \m f8 \me g4 a f2 e4 d2 r4
    %30
    e2 c4 f2 f4 g2 a r
    a4. \m g8 \me f4 f^\markup \bold "*" g2 a4 g g4. \m f8 \me e4 d c2 f4 e2 r4
    f2 d4 c8 [ \m d ] e4 \me f d2 d r1
    d8 [ \m e ] f4 \me f \m d \me e2 g4 a g2 f4 f f2 e4 d2 r4
    c2 c4 a2 g4 a \m b \me c2 r
    %35
    \repeat volta 2 {
      a2^\markup \musicglyph #"scripts.usignumcongruentiae" d4 d c2 c4 \m d \me a2 d4 e f2 f4 e2 r4
      a2 g4 e2 f4 g2 f\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Par -- se ke lui ju -- je -- ra se -- lon éÿ -- ki -- té
  Tùt le mond' a -- san -- blé.
  É "lè_" pö -- plez ù -- ìås ju -- je -- ra d'a -- rè^s
  Drû -- tu -- riérs é an -- tiérs.
  Vør' i se -- ra le Si -- ñör aã l'om' aÿ -- fli -- jé
  Son re -- fuÿ -- je sèr -- téin,
  "Dìî_" je re -- fuÿj' a pro -- pôs, si le tans le kiért,
  Ôá mi -- liö de l'an -- nui.
  É sur tø se fi -- ans se re -- pô -- ze -- ront
  Sös ki saÿ -- vetÄ ton nom.
  Ôs -- si ja -- mès, Séi -- ñör, tu n'a -- ban -- do -- nas
  Sös ki vont te çèr -- çér.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    %25
    c'2 f,4 a bes4. \m a8 \me g [ \m f ] \me g4 f4 \m e8 d \me c4 d es2 f4 c2 r4
    f2 f4 d2 \bar "" d'4 c2 f, r
    bes f a g4 f c'2 f,4 d f2 g4 a2 r4
    g2 f4 d8 [ \m e ] f4 \me c g'2 \bar "" c, r1
    c'2 f,4 f c2 f4 bes a2 g4 f bes2 c4 g2 r4
    %30
    c2 a4 bes2 d4 c2 f, r \bar "" 
    f'4. \m e8 \me d [ \m c ] \me d4 c2 f,4 c' g2 a4 bes f2 d4 a'2 r4
    d2 g,4 c2 f,4 g2 d r1
    d'2 \bar "" bes^\markup \bold "*" a2 g4 f c'2 d8 [ \m e ] \me f4 bes,2 c4 g2 r4
    a2 f4 f2 e4 d2 c2 r
    %35
    \repeat volta 2 {
      f^\markup \musicglyph #"scripts.usignumcongruentiae" d4 g c,2 f4 \m d \me d2 d4 c f2 d4 a'2 r4
      f2 g4 a8 [ \m bes ] c4 \me d c2 f,\longa*1/2^\fermata 
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Par -- se ke lui ju -- je -- ra se -- lon éÿ -- ki -- té
  Tùt le mond' a -- san -- blé.
  É "lè_" pö -- plez ù -- ìås ju -- je -- ra d'a -- rè^s
  Drû -- tu -- riérs é an -- tiérs.
  Vør' i se -- ra le Si -- ñör aã l'om' aÿ -- fli -- jé
  Son re -- fuÿ -- je sèr -- téin,
  "Dìî_" je re -- fuÿj' a pro -- pôs, si le tans le kiért,
  Ôá mi -- liö de l'an -- nui.
  É sur tø se fi -- ans se re -- pô -- ze -- ront
  Sös ki saÿ -- vetÄ ton nom.
  Ôs -- si ja -- mès, Séi -- ñör, tu n'a -- ban -- do -- nas
  Sös ki vont te çèr -- çér.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}
%% Strophes 7-8
discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c2^\markup \small "37" a2^\markup \bold "*" f2 g8 [ \m a ] \me bes4 a2 c4 bes bes2 a4 g2 r4
    a2^\markup \small "38" a4 f8 [ \m g a g ] \me a [ \m bes ] \me c2 c r
    f,^\markup \small "39" a c bes4 a g2 a4 d c2 bes 4 a2 r4
    bes2^\markup \small "40" c4 d4. \m c8 \me c4 b2 c r1
    c2^\markup \small "41" a4 a4 g2 a4 f c'4. \m d8 \me e4 f8 [ \m e ] \me d [ \m c ] d4 \me c b2 r4
    c2^\markup \small "42" c4 d4. \m e8 \me f4 e8 [ \m d ] e4 \me f2 r
    c4^\markup \small "43" \m d8 [ e ] \me f2 e2 f4 e d2 c4 \m bes \me a2 d4 cis2 r4
    d2^\markup \small "44" bes4 g2 c4 bes2 a r1
    f'2^\markup \small "45" d2^\markup \bold "*" c2 d8 [ \m e ] \me f4 e2 f4 c d2 c4 b2 r4
    c2^\markup \small "46" a4 f2 g4 d'2 g,2 r
    \repeat volta 2 {
      f2^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "47"} a4 \m bes \me g2 a4 a f2 a4 c c2 d4 e2 r4 
      f2^\markup \small "48" d4 c2 b4 c2 a\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Çan -- "té_" donk a se Diö ki se tiént lo -- jé
  Sur le mont de Sì -- îon.
  Vùs ôÎ pö -- plez a -- lés ré -- si -- tér de lui
  Lèz ùÂ -- vraÿ -- jez és -- kìîs.
  Kar çé -- ke -- føs k'i re -- çèr -- çe le jus -- te sang,
  An mé -- mø -- re lèz "a :"
  É "dè_" pôÎ -- vresÄ ki sont an grand mé -- çèf
  "Lè_" pro -- pôÎs n'ùÂ -- blìî pas.
  Pran donk mìþ -- zé -- ri -- kor -- de de mø, Si -- "ñör :"
  Vi -- ze bién mon an -- nui,
  K'ô -- jùr -- dui je re -- sø de la part de sös
  Dont je san la ran -- kör.
}

altusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    g2 f4 \m c \me d2 d4^\markup \bold "*" d8 [ \m e8 ] \me f2 g4 f g2 f4 e2 r4
    f2 c4 d8 [ \m e ] f4 \me f g2 a r
    d, f e g4 c, c8 [ \m d ] e4 \me f4 a a2 g4 e2 r4
    %40
    g2 a4 a2 g4 g2 e r1
    g2 f4 f e2 f4 d a'2 bes4 c bes4. \m a8 \me g [ \m f ] \me g2 r4
    g2 f4 bes2 a8 [ \m bes ] \me c2 c r
    f,8 [ \m g ] a4 \me a4. \m bes8 \me c2 c4 c bes2 a4 \m f \me f2 a4 a2 r4
    a2 g4 e2 a4 g2 fis r1
    %45
    a2 bes4 \m f8 [ g ] \me a2 bes4 c c2 a4 a bes2 g4 g2 r4
    e2 f4 c2 c4 f2 e r
    \repeat volta 2 {
      c^\markup \musicglyph #"scripts.usignumcongruentiae" f4 \m g \me e2 f4 f d2 f4 g a2 a8 [ \m b ] \me c2 r4
      c2 bes4 a4. \m g8 \me f4 e2 c\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Çan -- "té_" donk a se Diö ki se tiént lo -- jé
  Sur le mont de Sì -- îon.
  Vùs ôÎ pö -- plez a -- lés ré -- si -- tér de lui
  Lèz ùÂ -- vraÿ -- jez és -- kìîs.
  Kar çé -- ke -- føs k'i re -- çèr -- çe le jus -- te sang,
  An mé -- mø -- re lèz "a :"
  É "dè_" pôÎ -- vresÄ ki sont an grand mé -- çèf
  "Lè_" pro -- pôÎs n'ùÂ -- blìî pas.
  Pran donk mìþ -- zé -- ri -- kor -- de de mø, Si -- "ñör :"
  Vi -- ze bién mon an -- nui,
  K'ô -- jùr -- dui je re -- sø de la part de sös
  Dont je san la ran -- kör.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    e2 c4 \m f8 [ e ] \me d [\m c ] bes4 \me bes4^\markup \bold "*" bes c4. \m d8 \me es4 d8 [ \m c ] \me bes [ \m a ] g4 \me c c2 r4
    c2 a4 bes8 [ \m a16 g ] f4 \me f' e8 [ \m d ] e4 \me f2 r
    bes,8 [ \m c ] d4 \me c2 c d8 [ \m e ] \me f4 e2 c4 f f4. \m e8 \me d4 cis2 r4
    %40
    d2 f4 f2 e4 d2 c r1
    e2 c4 c c2 c4 d e4. \m f8 \me g4 a f2 e4 d2 r4
    e2 c4 f2 f4 g2 a r
    a4. \m g8 \me f2 g a4 g g4. \m f8 \me e4 \m d \me c2 f4 e2 r4
    f2 d4 c8 [ \m d ] e4 \me f d2 d r1
    %45
    d8 [ \m e ] f4 \me f \m d \me e2 g4 a g2 f4 f f2 e4 d2 r4
    c2 c4 a2 g4 a \m b \me c2 r
    \repeat volta 2 {
      a2^\markup \musicglyph #"scripts.usignumcongruentiae" d^\markup \bold "*" c2 c4 d a2 d4 e f2 f4 e2 r4
      a2 g4 e2 f4 g2 f\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Çan -- "té_" donk a se Diö ki se tiént lo -- jé
  Sur le mont de Sì -- îon.
  Vùs ôÎ pö -- plez a -- lés ré -- si -- tér de lui
  Lèz ùÂ -- vraÿ -- jez és -- kìîs.
  Kar çé -- ke -- føs k'i re -- çèr -- çe le jus -- te sang,
  An mé -- mø -- re lèz "a :"
  É "dè_" pôÎ -- vresÄ ki sont an grand mé -- çèf
  "Lè_" pro -- pôÎs n'ùÂ -- blìî pas.
  Pran donk mìþ -- zé -- ri -- kor -- de de mø, Si -- "ñör :"
  Vi -- ze bién mon an -- nui,
  K'ô -- jùr -- dui je re -- sø de la part de sös
  Dont je san la ran -- kör.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    c'2 f,4 \m a \me bes4. \m a8 \me g [ \m f ] \me g4 f4 \m e8 [ d ] \me c4 d es2 f4 c2 r4
    f2 f4 d2 \bar "" d'4 c2 f, r
    bes f a g4 f c'2 f,4 d f2 g4 a2 r4
    %40
    g2 f4 d8 [ \m e ] f4 \me c g'2 \bar "" c, r1
    c'2 f,4 f c2 f4 bes a2 g4 f bes2 c4 g2 r4
    c2 a4 bes2 d4 c2 f, r \bar "" 
    f'4. \m e8 \me d [ \m c ] d4 \me c2 f,4 c' g2 a4 \m bes \me f2 d4 a'2 r4
    d2 g,4 c2 f,4 g2 d r1
    %45
    d'2 \bar "" bes2^\markup \bold "*" a2 g4 f c'2 d8 [ \m e ] \me f4 bes,2 c4 g2 r4
    a2 f4 f2 e4 d2 c2 r 
    \repeat volta 2 {
      f^\markup \musicglyph #"scripts.usignumcongruentiae" d4 \m g \me c,2 f4 d d2 d4 c f2 d4 a'2 r4
      f2 g4 a8 [ \m bes ] c4 \me d c2 f,\longa*1/2^\fermata 
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Çan -- "té_" donk a se Diö ki se tiént lo -- jé
  Sur le mont de Sì -- îon.
  Vùs ôÎ pö -- plez a -- lés ré -- si -- tér de lui
  Lèz ùÂ -- vraÿ -- jez és -- kìîs.
  Kar çé -- ke -- føs k'i re -- çèr -- çe le jus -- te sang,
  An mé -- mø -- re lèz "a :"
  É "dè_" pôÎ -- vresÄ ki sont an grand mé -- çèf
  "Lè_" pro -- pôÎs n'ùÂ -- blìî pas.
  Pran donk mìþ -- zé -- ri -- kor -- de de mø, Si -- "ñör :"
  Vi -- ze bién mon an -- nui,
  K'ô -- jùr -- dui je re -- sø de la part de sös
  Dont je san la ran -- kör.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}
%% Strohpes 9-10
discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c2^\markup \small "49" a4 a f2 g8 [ \m a ] \me bes4 a2 c4 bes bes2 a4 g2 r4
    a2^\markup \small "50" a4 f8 [ \m g a g ] \me a [ \m bes ] \me c2 c r
    f,^\markup \small "51" a4^\markup \bold "*" a c2 bes4 a g2 a4 d c2 bes 4 a2 r4
    bes2^\markup \small "52" c4 d4. \m c8 \me c4 b2 c r1
    c2^\markup \small "53" a4 a4 g2 a4 f c'4. \m d8 \me e4 f8 [ \m e ] \me d [ \m c ] d4 \me c b2 r4
    c2^\markup \small "54" c4 d4. \m e8 \me f4 e8 [ \m d ] e4 \me f2 r
    c4^\markup \small "55" \m d8 [ e ] \me f4^\markup \bold "*" f e2 f4 \m e \me d2 c4 bes a2 d4 cis2 r4
    d2^\markup \small "56" bes4 g2 c4 bes2 a r1
    f'2^\markup \small "57" d4 d c2 d8 [ \m e ] \me f4 e2 f4 c d2 c4 b2 r4
    c2^\markup \small "58" a4 f2 g4 d'2 g,2 r
    \repeat volta 2 {
      f2^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "59"} a4 bes g2 a2^\markup \bold "*" f2 a4 c c2 d4 e2 r4 
      f2^\markup \small "60" d4 c2 b4 c2 a\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Vién de la pôr -- te hi -- dö -- ze du nør tré -- pas,
  "Vién-" -- me tôÎt le -- vér sus.
  Pùr de la fìþ -- £e SÍÝ -- onn' a la por -- te, tùs
  "Tèz_" -- o -- nörs ra -- kon -- tér.
  D'è^ -- ze j'ìÁ sô -- té -- le -- rè, j'i a -- rè sù -- las,
  Ton se -- kùrs ra -- man -- tant.
  Lès na -- si -- ons ont fètã sé -- le fôÊs -- se mè^m'
  An la kèl' i sont çus.
  Dans le pi -- èæ -- je kù -- vèrt k'il a -- vøÎt ka -- çé
  Par le pié se sont pris.
  Ôr le Si -- ñör "s'è^_" fètã a -- ko -- nøÎ -- tre Diö,
  An ju -- jant se -- lon drøtã.
}

altusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    g2 f4 c d2 d4^\markup \bold "*" d8 [ \m e8 ] \me f2 g4 f g2 f4 e2 r4
    %50
    f2 c4 d8 [ \m e ] f4 \me f g2 a r
    d, f4^\markup \bold "*" f e2 g4 c, c8 [ \m d ] e4 \me f4 a a2 g4 e2 r4
    g2 a4 a2 g4 g2 e r1
    g2 f4 f e2 f4 d a'2 bes4 c bes4. \m a8 \me g [ \m f ] \me g2 r4
    g2 f4 bes2 a8 [ \m bes ] \me c2 c r
    %55
    f,8 [ \m g ] a4 \me a4^\markup \bold "*" a8 [ \m bes8 ] \me c2 c^\markup \bold "*" bes2 a4 f f2 a4 a2 r4
    a2 g4 e2 a4 g2 fis r1
    a2 bes4 f8 [ \m g ] \me a2 bes4 c c2 a4 a bes2 g4 g2 r4
    e2 f4 c2 c4 f2 e r
    \repeat volta 2 {
      c^\markup \musicglyph #"scripts.usignumcongruentiae" f4 g e2 f4 f d2 f4 \m g \me a2 a8 [ \m b ] \me c2 r4
      %60
      c2 bes4 a4. \m g8 \me f4 e2 c\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Vién de la pôr -- te hi -- dö -- ze du nør tré -- pas,
  "Vién-" -- me tôÎt le -- vér sus.
  Pùr de la fìþ -- £e SÍÝ -- onn' a la por -- te, tùs
  "Tèz_" -- o -- nörs ra -- kon -- tér.
  D'è^ -- ze j'ìÁ sô -- té -- le -- rè, j'i a -- rè sù -- las,
  Ton se -- kùrs ra -- man -- tant.
  Lès na -- si -- ons ont fètã sé -- le fôÊs -- se mè^m'
  An la kèl' i sont çus.
  Dans le pi -- èæ -- je kù -- vèrt k'il a -- vøÎt ka -- çé
  Par le pié se sont pris.
  Ôr le Si -- ñör "s'è^_" fètã a -- ko -- nøÎ -- tre Diö,
  An ju -- jant se -- lon drøtã.
}



tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    e2 c4 f8 [ \m e ] \me d [ \m c ] bes4 \me bes4^\markup \bold "*" bes c4. \m d8 \me es4 d8 [ \m c ] \me bes [ \m a ] g4 \me c c2 r4
    %50
    c2 a4 bes8 [ \m a16 g ] f4 \me f' e8 [ \m d ] e4 \me f2 r
    bes,8 [ \m c ] d4 \me c4^\markup \bold "*" c c2 d8 [ \m e ] \me f4 e2 c4 f f4. \m e8 \me d4 cis2 r4
    d2 f4 f2 e4 d2 c r1
    e2 c4 c c2 c4 d e4. \m f8 \me g4 a f2 e4 d2 r4
    e2 c4 f2 f4 g2 a r
    %55
    a4. \m g8 \me f4^\markup \bold "*" f g2 a4 \m g \me g4. \m f8 \me e4 d c2 f4 e2 r4
    f2 d4 c8 [ \m d ] e4 \me f d2 d r1
    d8 [ \m e ] f4 \me f d e2 g4 a g2 f4 f f2 e4 d2 r4
    c2 c4 a2 g4 a \m b \me c2 r
    \repeat volta 2 {
      a2^\markup \musicglyph #"scripts.usignumcongruentiae" d4 d c2 c4 \m d \me a2 d4 e f2 f4 e2 r4
      %60
      a2 g4 e2 f4 g2 f\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Vién de la pôr -- te hi -- dö -- ze du nør tré -- pas,
  "Vién-" -- me tôÎt le -- vér sus.
  Pùr de la fìþ -- £e SÍÝ -- onn' a la por -- te, tùs
  "Tèz_" -- o -- nörs ra -- kon -- tér.
  D'è^ -- ze j'ìÁ sô -- té -- le -- rè, j'i a -- rè sù -- las,
  Ton se -- kùrs ra -- man -- tant.
  Lès na -- si -- ons ont fètã sé -- le fôÊs -- se mè^m'
  An la kèl' i sont çus.
  Dans le pi -- èæ -- je kù -- vèrt k'il a -- vøÎt ka -- çé
  Par le pié se sont pris.
  Ôr le Si -- ñör "s'è^_" fètã a -- ko -- nøÎ -- tre Diö,
  An ju -- jant se -- lon drøtã.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    c'2 f,4 a bes4. \m a8 \me g [ \m f ] \me g4 f4 \m e8 [ d ] \me c4 d es2 f4 c2 r4
    %50
    f2 f4 d2 \bar "" d'4 c2 f, r
    bes f4^\markup \bold "*" f a2 g4 f c'2 f,4 d f2 g4 a2 r4
    g2 f4 d8 [ \m e ] f4 \me c g'2 \bar "" c, r1
    c'2 f,4 f c2 f4 bes a2 g4 f bes2 c4 g2 r4
    c2 a4 bes2 d4 c2 f, r \bar "" 
    %55
    f'4. \m e8 \me d [ \m c ] \me d4 c2 f,4 \m c' \me g2 a4 bes f2 d4 a'2 r4
    d2 g,4 c2 f,4 g2 d r1
    d'2 \bar "" bes4 bes a2 g4 f c'2 d8 [ \m e ] \me f4 bes,2 c4 g2 r4
    a2 f4 f2 e4 d2 c2 r
    \repeat volta 2 {
      f^\markup \musicglyph #"scripts.usignumcongruentiae" d4 g c,2 f4 \m d \me d2 d4 c f2 d4 a'2 r4
      %60
      f2 g4 a8 [ \m bes ] c4 \me d c2 f,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Vién de la pôr -- te hi -- dö -- ze du nør tré -- pas,
  "Vién-" -- me tôÎt le -- vér sus.
  Pùr de la fìþ -- £e SÍÝ -- onn' a la por -- te, tùs
  "Tèz_" -- o -- nörs ra -- kon -- tér.
  D'è^ -- ze j'ìÁ sô -- té -- le -- rè, j'i a -- rè sù -- las,
  Ton se -- kùrs ra -- man -- tant.
  Lès na -- si -- ons ont fètã sé -- le fôÊs -- se mè^m'
  An la kèl' i sont çus.
  Dans le pi -- èæ -- je kù -- vèrt k'il a -- vøÎt ka -- çé
  Par le pié se sont pris.
  Ôr le Si -- ñör "s'è^_" fètã a -- ko -- nøÎ -- tre Diö,
  An ju -- jant se -- lon drøtã.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}
%% Strohpes 11-12
discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c2^\markup \small "61" a2^\markup \bold "*" f2 g8 [ \m a ] \me bes4 a2 c4 bes bes2 a4 g2 r4
    a2^\markup \small "62" a4 f8 [ \m g a g ] \me a [ \m bes ] \me c2 c r
    f,^\markup \small "63" a4^\markup \bold "*" a c2 bes4 \m a \me g2 a4 \m d \me c2 bes 4 a2 r4
    bes2^\markup \small "64" c4 d4. \m c8 \me c4 b2 c r1
    c2^\markup \small "65" a4 a4 g2 a4 f c'4. \m d8 \me e4 f8 [ \m e ] \me d [ \m c ] d4 \me c b2 r4
    c2^\markup \small "66" c4 d4. \m e8 \me f4 e8 [ \m d ] e4 \me f2 r
    c4^\markup \small "67" \m d8 [ e ] \me f4^\markup \bold "*" f e2 f4 e d2 c4 bes a2 d4 cis2 r4
    d2^\markup \small "68" bes4 g2 c4 bes2 a r1
    f'2^\markup \small "69" d2^\markup \bold "*" c2 d8 [ \m e ] \me f4 e2 f4 c d2 c4 b2 r4
    c2^\markup \small "70" a4 f2 g4 d'2 g,2 r
    \repeat volta 2 {
      f2^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "71"} a4 bes g2 a2^\markup \bold "*" f2 a4 c c2 d4 e2 r4 
      f2^\markup \small "72" d4 c2 b4 c2 a\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An -- pè -- tré de l'ùÂ -- vra -- je ke fit sa méin,
  Jus -- te -- mant le pèr -- vèrs
  S'an -- ve -- lo -- pa. K'éin -- sin tùs fôr -- fé -- törs
  SøÎt je -- tés an an -- fèr,
  É tù -- tesÄ lès na -- si -- ons, ki le Diö vi -- vant
  Ùÿ -- blìå -- éÿ de -- lè^ -- ront.
  Mès l'o -- me bon sù -- fre -- tös ne se -- ra je -- té
  Pùr -- ja -- mès an ù -- "bli :"
  É dèz un -- blesÄ l'a -- tant' a -- su -- ré^, de -- su^
  Pùr ja -- mès ne mùr -- ra.
  Sus le -- ve tø Séi -- ñör, ke l'u -- méin flù -- ètã
  Pûint ne braÿ -- ve "pluÿ_" -- fôrt.
}

altusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    g2 f4 \m c \me d2 d4^\markup \bold "*" d8 [ \m e8 ] \me f2 g4 f g2 f4 e2 r4
    f2 c4 d8 [ \m e ] f4 \me f g2 a r
    d, f4^\markup \bold "*" f e2 g4 \m c, \me c8 [ \m d ] e4 \me f4 \m a \me a2 g4 e2 r4
    g2 a4 a2 g4 g2 e r1
    %65
    g2 f4 f e2 f4 d a'2 bes4 c bes4. \m a8 \me g [ \m f ] \me g2 r4
    g2 f4 bes2 a8 [ \m bes ] \me c2 c r
    f,8 [ \m g ] a4 \me a4^\markup \bold "*" a8 [ \m bes8 ] \me c2 c4 c bes2 a4 f f2 a4 a2 r4
    a2 g4 e2 a4 g2 fis r1
    a2bes4 \m f8 [ g ] \me a2 bes4 c c2 a4 a bes2 g4 g2 r4
    %70
    e2 f4 c2 c4 f2 e r
    \repeat volta 2 {
      c^\markup \musicglyph #"scripts.usignumcongruentiae" f4 g e2 f2^\markup \bold "*" d2 f4 g a2 a8 [ \m b ] \me c2 r4
      c2 bes4 a4. \m g8 \me f4 e2 c\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An -- pè -- tré de l'ùÂ -- vra -- je ke fit sa méin,
  Jus -- te -- mant le pèr -- vèrs
  S'an -- ve -- lo -- pa. K'éin -- sin tùs fôr -- fé -- törs
  SøÎt je -- tés an an -- fèr,
  É tù -- tesÄ lès na -- si -- ons, ki le Diö vi -- vant
  Ùÿ -- blìå -- éÿ de -- lè^ -- ront.
  Mès l'o -- me bon sù -- fre -- tös ne se -- ra je -- té
  Pùr -- ja -- mès an ù -- "bli :"
  É dèz un -- blesÄ l'a -- tant' a -- su -- ré^, de -- su^
  Pùr ja -- mès ne mùr -- ra.
  Sus le -- ve tø Séi -- ñör, ke l'u -- méin flù -- ètã
  Pûint ne braÿ -- ve "pluÿ_" -- fôrt.
}



tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    e2 c4 \m f8 [ e ] \me d [ \m c ] bes4 \me bes4^\markup \bold "*" bes c4. \m d8 \me es4 d8 [ \m c ] \me bes [ \m a ] g4 \me c c2 r4
    c2 a4 bes8 [ \m a16 g ] f4 \me f' e8 [ \m d ] e4 \me f2 r
    bes,8 [ \m c ] d4 \me c4^\markup \bold "*" c  c2 d8 [ \m e ] f4 \me e2 c4 \m f \me f4. \m e8 \me d4 cis2 r4
    d2 f4 f2 e4 d2 c r1
    %65
    e2 c4 c c2 c4 d e4. \m f8 \me g4 a f2 e4 d2 r4
    e2 c4 f2 f4 g2 a r
    a4. \m g8 \me f4^\markup \bold "*" f g2 a4 g g4. \m f8 \me e4 d c2 f4 e2 r4
    f2 d4 c8 [ \m d ] e4 \me f d2 d r1
    d8 [ \m e ] f4 \me f \m d \me e2 g4 a g2 f4 f f2 e4 d2 r4
    %70
    c2 c4 a2 g4 a \m b \me c2 r
    \repeat volta 2 {
      a2^\markup \musicglyph #"scripts.usignumcongruentiae" d4 d c2 c4 \m d \me a2 d4 e f2 f4 e2 r4
      a2 g4 e2 f4 g2 f\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An -- pè -- tré de l'ùÂ -- vra -- je ke fit sa méin,
  Jus -- te -- mant le pèr -- vèrs
  S'an -- ve -- lo -- pa. K'éin -- sin tùs fôr -- fé -- törs
  SøÎt je -- tés an an -- fèr,
  É tù -- tesÄ lès na -- si -- ons, ki le Diö vi -- vant
  Ùÿ -- blìå -- éÿ de -- lè^ -- ront.
  Mès l'o -- me bon sù -- fre -- tös ne se -- ra je -- té
  Pùr -- ja -- mès an ù -- "bli :"
  É dèz un -- blesÄ l'a -- tant' a -- su -- ré^, de -- su^
  Pùr ja -- mès ne mùr -- ra.
  Sus le -- ve tø Séi -- ñör, ke l'u -- méin flù -- ètã
  Pûint ne braÿ -- ve "pluÿ_" -- fôrt.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    c'2 f,4 \m a \me bes4. \m a8 \me g [ \m f ] \me g4 f4 \m e8 [ d ] \me c4 d es2 f4 c2 r4
    f2 f4 d2 \bar "" d'4 c2 f, r
    bes f4^\markup \bold "*" f a2 g4 \m f \me c'2 f,4 \m d \me f2 g4 a2 r4
    g2 f4 d8 [ \m e ] f4 \me c g'2 \bar "" c, r1
    %65
    c'2 f,4 f c2 f4 bes a2 g4 f bes2 c4 g2 r4
    c2 a4 bes2 d4 c2 f, r \bar ""
    f'4. \m e8 \me d [ \m c ] \me d4 c2 f,4 c' g2 a4 bes f2 d4 a'2 r4
    d2 g,4 c2 f,4 g2 d r1
    d'2 \bar "" bes2^\markup \bold "*" a2 g4 f c'2 d8 [ \m e ] \me f4 bes,2 c4 g2 r4
    %70
    a2 f4 f2 e4 d2 c2 r
    \repeat volta 2 {
      f^\markup \musicglyph #"scripts.usignumcongruentiae" d4 g c,2 f4 \m d \me d2 d4 c f2 d4 a'2 r4
      f2 g4 a8 [ \m bes ] c4 \me d c2 f,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An -- pè -- tré de l'ùÂ -- vra -- je ke fit sa méin,
  Jus -- te -- mant le pèr -- vèrs
  S'an -- ve -- lo -- pa. K'éin -- sin tùs fôr -- fé -- törs
  SøÎt je -- tés an an -- fèr,
  É tù -- tesÄ lès na -- si -- ons, ki le Diö vi -- vant
  Ùÿ -- blìå -- éÿ de -- lè^ -- ront.
  Mès l'o -- me bon sù -- fre -- tös ne se -- ra je -- té
  Pùr -- ja -- mès an ù -- "bli :"
  É dèz un -- blesÄ l'a -- tant' a -- su -- ré^, de -- su^
  Pùr ja -- mès ne mùr -- ra.
  Sus le -- ve tø Séi -- ñör, ke l'u -- méin flù -- ètã
  Pûint ne braÿ -- ve "pluÿ_" -- fôrt.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}

%% Strophe 13

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c4^\markup \small "73" \m d8 [ e ] \me f4^\markup \bold "*" f e2 f4 e d2 c4 \m bes \me a2 d4 cis2 r4
    d2^\markup \small "74" bes4 g2 c4 bes2 a r1
    f'2^\markup \small "75" d4 d c2 d8 [ \m e ] \me f4 e2 f4 c d2 c4 b2 r4
    c2^\markup \small "76" a4 f2 g4 d'2 g,2 r
    \repeat volta 2 {
      f2^\markup {\musicglyph #"scripts.usignumcongruentiae" \small "77"} a4 \m bes \me g2 a4 a f2 a4 c c2 d4 e2 r4 
      f2^\markup \small "78" d4 c2 b4 c2 a\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An ta pré -- zan -- se me -- né^s lès nas -- si -- oæns
  SøÎt ju -- jé^s da -- vant tø.
  Mèã de -- sur è -- lesÄ de tøý uÂ -- ne tè -- le pör,
  K'an se bién ko -- nø -- sant
  "Lè_" jan -- tìîs é pa -- iéns saÂ -- çeÂtÄ bién k'i sont
  Dèz u -- méins, é rién plus.
}

altusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    f,8 [ \m g ] a4 \me a4^\markup \bold "*" a8 [ \m bes8 ] \me c2 c4 c bes2 a4 \m f \me f2 a4 a2 r4
    a2 g4 e2 a4 g2 fis r1
    %75
    a2 bes4 f8 [ \m g ] \me a2 bes4 c c2 a4 a bes2 g4 g2 r4
    e2 f4 c2 c4 f2 e r
    \repeat volta 2 {
      c^\markup \musicglyph #"scripts.usignumcongruentiae" f4 \m g \me e2 f4 f d2 f4 g a2 a8 [ \m b ] \me c2 r4
      c2 bes4 a4. \m g8 \me f4 e2 c\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An ta pré -- zan -- se me -- né^s lès nas -- si -- oæns
  SøÎt ju -- jé^s da -- vant tø.
  Mèã de -- sur è -- lesÄ de tøý uÂ -- ne tè -- le pör,
  K'an se bién ko -- nø -- sant
  "Lè_" jan -- tìîs é pa -- iéns saÂ -- çeÂtÄ bién k'i sont
  Dèz u -- méins, é rién plus.
}



tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    a'4. \m g8 \me f4^\markup \bold "*" f g2 a4 g g4. \m f8 \me e4 \m d \me c2 f4 e2 r4
    f2 d4 c8 [ \m d ] e4 \me f d2 d r1
    %75
    d8 [ \m e ] f4 \me f d e2 g4 a g2 f4 f f2 e4 d2 r4
    c2 c4 a2 g4 a \m b \me c2 r
    \repeat volta 2 {
      a2^\markup \musicglyph #"scripts.usignumcongruentiae" d2^\markup \bold "*" c2 c4 d a2 d4 e f2 f4 e2 r4
      a2 g4 e2 f4 g2 f\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An ta pré -- zan -- se me -- né^s lès nas -- si -- oæns
  SøÎt ju -- jé^s da -- vant tø.
  Mèã de -- sur è -- lesÄ de tøý uÂ -- ne tè -- le pör,
  K'an se bién ko -- nø -- sant
  "Lè_" jan -- tìîs é pa -- iéns saÂ -- çeÂtÄ bién k'i sont
  Dèz u -- méins, é rién plus.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f'4. \m e8 \me d [ \m c ] \me d4 c2 f,4 c' g2 a4 \m bes \me f2 d4 a'2 r4
    d2 g,4 c2 f,4 g2 d r1 \bar "" 
    %75
    d'2 bes4 bes a2 g4 f c'2 d8 [ \m e ] \me f4 bes,2 c4 g2 r4
    a2 f4 f2 e4 d2 c2 r
    \repeat volta 2 {
      f^\markup \musicglyph #"scripts.usignumcongruentiae" d4 \m g \me c,2 f4 d d2 d4 c f2 d4 a'2 r4
      f2 g4 a8 [ \m bes ] c4 \me d c2 f,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  An ta pré -- zan -- se me -- né^s lès nas -- si -- oæns
  SøÎt ju -- jé^s da -- vant tø.
  Mèã de -- sur è -- lesÄ de tøý uÂ -- ne tè -- le pör,
  K'an se bién ko -- nø -- sant
  "Lè_" jan -- tìîs é pa -- iéns saÂ -- çeÂtÄ bién k'i sont
  Dèz u -- méins, é rién plus.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}