global = {
  #(set-accidental-style 'forget)
  \once \override Staff.Clef #'full-size-change = ##t
  \set Staff.forceClef = ##t
  \set Score.defaultBarType = "empty"
  \time 4/4
  \override Voice.NoteHead #'style = #'baroque
  \override Score.BarNumber #'padding = #3
}

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key f \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      f'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    f,2^\markup \small "1" a g c4 bes a2 d c4 a bes2 a4 g2 r4
    f2^\markup \small "2" d f e4 d cis2 d8 [ \m e ] f4 \me g8 [ \m a ] \me bes4 a2 g4 a2 r4
    c2^\markup \small "3" bes c g4 a f2 e2 r4
    c2^\markup \small "4" f d c4 f f2 e4 f2 r
    f^\markup \small "5" g a g4 bes a2 c d4 c bes2 c4 c2 r4
    g2^\markup \small "6" a f g4 f e2 f c4 d f8 [ \m g ] a4 \me g a2 r4
    bes2^\markup \small "7" g a g4 c, f2 e r4
    e4^\markup \small "8" \m f \me g2 a g4 f f2 e4 f\longa*1/2^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ SÉI -- ÑÖR sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  An tø j'és -- pé -- re "söl :" SôÎ -- ve dé -- li -- "vre-" -- "mø ;"
  Mon Diö, sôÎ -- ve ré -- "kù^_" mø
  Sur tùs sös ki me vont kù -- rant.
  K'il n'a££', éin -- si ke fèt un li -- oæn aÿ -- fa -- mé,
  Ma çiér' a^ -- me ra -- vir, kant i se trö -- ve -- ra
  "Pluÿ_" fôrt pùr me dé -- man -- "brér :"
  Mèsã nul pùr me ré -- kùr -- re d'ös.
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key f \major \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      c'2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    c2 f e f4 d c2 bes c4 f g2 f4 e2 r4
    c2 bes c c4 a a2 a e'4 f f4. \m e8 \me d4 cis2 r4
    a'2 g e c4 c d2 g, r4
    a2 d bes g4 a d2 c4 a2 r
    %5
    d e f e4 d c2 c f4 f f4. \m g8 \me a4 g2 r4
    e2 f d d4 d cis2 d a4 bes c8 [ \m d16 e ] f4 \me d fis2 r4
    g2 e f c4 f,8 [ \m g ] \me a4 \m b \me c2 r4
    c2 bes a8 [ \m bes c d ] \me e4 c d2 c4 a\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ SÉI -- ÑÖR sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  An tø j'és -- pé -- re "söl :" SôÎ -- ve dé -- li -- "vre-" -- "mø ;"
  Mon Diö, sôÎ -- ve ré -- "kù^_" mø
  Sur tùs sös ki me vont kù -- rant.
  K'il n'a££', éin -- si ke fèt un li -- oæn aÿ -- fa -- mé,
  Ma çiér' a^ -- me ra -- vir, kant i se trö -- ve -- ra
  "Pluÿ_" fôrt pùr me dé -- man -- "brér :"
  Mèsã nul pùr me ré -- kùr -- re d'ös.
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c4" 
      \key f \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      a2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    a2 c c f,4 f f2 f4 \m g \me a c g8 [ \m a bes g ] \me c4 c2 r4
    a2 f a g4 f e2 f c'4 d c2 d4 e2 r4
    f2 d c c8 [ \m bes ] \me a4 bes \m a8 [ b ] \me c2 r4
    f,8 [ \m g ] a4 \me a2 g e4 c' \m bes8 [ a ] \me g4 g f2 r
    %5
    a c c c4 f, f2 a a4 \footnote #'(0.5 . 1.5) \markup{"Do dièse dans l'original."} c d2 f4 e2 r4 %do # dans l'original
    \footnote #'(0.5 . 1.5) \markup{"Ré dans l'original."} c2 c bes bes4 a a2 a a4 f8 [ \m g ] \me a [ \m bes ] c4 \me bes a2 r4 %Première note du vers est un ré dans l'original
    d2 c c c8 [ \m bes ] \me a [ \m g ] \me f2 g r4
    c,2 d4 \m e \me f2 g4 a bes8 [ \m a ] g4 \me g f\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ SÉI -- ÑÖR sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  An tø j'és -- pé -- re "söl :" SôÎ -- ve dé -- li -- "vre-" -- "mø ;"
  Mon Diö, sôÎ -- ve ré -- "kù^_" mø
  Sur tùs sös ki me vont kù -- rant.
  K'il n'a££', éin -- si ke fèt un li -- oæn aÿ -- fa -- mé,
  Ma çiér' a^ -- me ra -- vir, kant i se trö -- ve -- ra
  "Pluÿ_" fôrt pùr me dé -- man -- "brér :"
  Mèsã nul pùr me ré -- kùr -- re d'ös.
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f" 
      \set Staff.keySignature = #`(((-2 . 6) . ,FLAT)
                                   ((-1 . 6) . ,FLAT))
      \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      f2
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f2 f c a4 bes f2 bes f'4 f es2 f4 c2 r4
    f2 bes, f' c4 d a2 d \bar "" c4 bes f'8 [ \m g ] a4 \me bes a2 r4
    f2 g a4 \m g8 [ f ] \me e4 f d2 c r4
    f2 d g, c4 a bes2 c4 \bar "" f,2 r
    %5
    d' c f c4 bes f2 f' d4 a' bes2 f4 c'2 r4
    c,2 f bes, g4 d' a2 d f4 bes, f2 \bar "" g4 d'2 r4
    g2 c, f e4 f d2 c r4
    a2 g f c'4 f bes,2 c4 f,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ SÉI -- ÑÖR sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  An tø j'és -- pé -- re "söl :" SôÎ -- ve dé -- li -- "vre-" -- "mø ;"
  Mon Diö, sôÎ -- ve ré -- "kù^_" mø
  Sur tùs sös ki me vont kù -- rant.
  K'il n'a££', éin -- si ke fèt un li -- oæn aÿ -- fa -- mé,
  Ma çiér' a^ -- me ra -- vir, kant i se trö -- ve -- ra
  "Pluÿ_" fôrt pùr me dé -- man -- "brér :"
  Mèsã nul pùr me ré -- kùr -- re d'ös.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.8 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.1 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.2 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #6.3 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001.ly"
  \header {
    filename =  "007enToyDieuBon.ly"
    title = "Psaume VII"
    subtitle = " "
    opus = " "
    composer = "Claude Le Jeune"
    poet = "Jean-Antoine de Baïf (1573)"
  }
}

%% Strophes 3-4

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    f,2^\markup \small "9" a g c4 bes a2 d c4 a bes2 a4 g2 r4
    f2^\markup \small "10" d f e4 d cis2 d8 [ \m e ] f4 \me g8 [ \m a ] \me bes4 a2 g4 a2 r4
    c2^\markup \small "11" bes c g4 a f2 e2 r4
    c2^\markup \small "12" f d c4 f f2 e4 f2 r
    f^\markup \small "13" g a g4 bes a2 c d4 c bes2 c4 c2 r4
    g2^\markup \small "14" a f g4 f e2 f c4 d f8 [ \m g ] a4 \me g a2 r4
    bes2^\markup \small "15" g a g4 c, f2 e r4
    e4^\markup \small "16" \m f \me g2 a g4 f f2 e4 f\longa*1/2^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ Séi -- ñör sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  Sìþ j'èã fèt se mé -- "fèt :" sìþ té -- le la^ -- çe -- té,
  Sìþ "tan_" gran -- de ma -- lur -- té,
  An "mè_" méins se trù -- vøt ja -- "mès :"
  Sìþ vèrz un kìÁ m'é -- tøt, jûint d'a -- li -- ans', a -- mi,
  J'èã ran -- du ma -- le -- mant kon -- tre de -- vør le "mal :"
  Mèsã, kant il m'a kù -- ru sus
  A tôrt, sìþ je ne l'è ré -- "kùs :"
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    c2 f e f4 d c2 bes c4 f g2 f4 e2 r4
    %10
    c2 bes c c4 a a2 a e'4 f f4. \m e8 \me d4 cis2 r4
    a'2 g e c4 c d2 g, r4
    a2 d bes g4 a d2 c4 a2 r
    d e f e4 d c2 c f4 f f4. \m g8 \me a4 g2 r4
    e2 f d d4 d cis2 d a4 bes c8 [ \m d16 e ] f4 \me d fis2 r4
    %15
    g2 e f c4 f,8 [ \m g ] \me a4 \m b \me c2 r4
    c2 bes a8 [ \m bes c d ] \me e4 c d2 c4 a\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ Séi -- ñör sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  Sìþ j'èã fèt se mé -- "fèt :" sìþ té -- le la^ -- çe -- té,
  Sìþ "tan_" gran -- de ma -- lur -- té,
  An "mè_" méins se trù -- vøt ja -- "mès :"
  Sìþ vèrz un kìÁ m'é -- tøt, jûint d'a -- li -- ans', a -- mi,
  J'èã ran -- du ma -- le -- mant kon -- tre de -- vør le "mal :"
  Mèsã, kant il m'a kù -- ru sus
  A tôrt, sìþ je ne l'è ré -- "kùs :"
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    a2 c c f,4 f f2 f4 \m g \me a c g8 [ \m a bes g ] \me c4 c2 r4
    %10
    a2 f a g4 f e2 f c'4 d c2 d4 e2 r4
    f2 d c c8 [ \m bes ] \me a4 bes \m a8 [ b ] \me c2 r4
    f,8 [ \m g ] a4 \me a2 g e4 c' \m bes8 [ a ] \me g4 g f2 r
    a c c c4 f, f2 a a4 c d2 f4 e2 r4 %do # dans l'original
    c2 c bes bes4 a a2 a a4 f8 [ \m g ] \me a [ \m bes ] c4 \me bes a2 r4 %Première note du vers est un ré dans l'original
    %15
    d2 c c c8 [ \m bes ] \me a [ \m g ] \me f2 g r4
    c,2 d4 \m e \me f2 g4 a bes8 [ \m a ] g4 \me g f\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ Séi -- ñör sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  Sìþ j'èã fèt se mé -- "fèt :" sìþ té -- le la^ -- çe -- té,
  Sìþ "tan_" gran -- de ma -- lur -- té,
  An "mè_" méins se trù -- vøt ja -- "mès :"
  Sìþ vèrz un kìÁ m'é -- tøt, jûint d'a -- li -- ans', a -- mi,
  J'èã ran -- du ma -- le -- mant kon -- tre de -- vør le "mal :"
  Mèsã, kant il m'a kù -- ru sus
  A tôrt, sìþ je ne l'è ré -- "kùs :"
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f2 f c a4 bes f2 bes f'4 f es2 f4 c2 r4
    f2 bes, f' c4 d a2 d \bar "" c4 bes f'8 [ \m g ] a4 \me bes a2 r4
    %10
    f2 g a4 \m g8 [ f ] \me e4 f d2 c r4
    f2 d g, c4 a bes2 c4 \bar "" f,2 r
    d' c f c4 bes f2 f' d4 a' bes2 f4 c'2 r4
    c,2 f bes, g4 d' a2 d f4 bes, f2 \bar "" g4 d'2 r4
    %15
    g2 c, f e4 f d2 c r4
    a2 g f c'4 f bes,2 c4 f,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  ÔÎ Séi -- ñör sù -- ve -- réin, mon se -- kù -- ra -- ble Diö,
  Sìþ j'èã fèt se mé -- "fèt :" sìþ té -- le la^ -- çe -- té,
  Sìþ "tan_" gran -- de ma -- lur -- té,
  An "mè_" méins se trù -- vøt ja -- "mès :"
  Sìþ vèrz un kìÁ m'é -- tøt, jûint d'a -- li -- ans', a -- mi,
  J'èã ran -- du ma -- le -- mant kon -- tre de -- vør le "mal :"
  Mèsã, kant il m'a kù -- ru sus
  A tôrt, sìþ je ne l'è ré -- "kùs :"
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 5-6

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    f,2^\markup \small "17" a g c4 bes a2 d c4 a bes2 a4 g2 r4
    f2^\markup \small "18" d f e4 d cis2 d8 [ \m e ] f4 \me g8 [ \m a ] \me bes4 a2 g4 a2 r4
    c2^\markup \small "19" bes c g4 a f2 e2 r4
    c2^\markup \small "20" f d c4 f f2 e4 f2 r
    f^\markup \small "21" g a g4 bes a2 c d4 c bes2 c4 c2 r4
    g2^\markup \small "22" a f g4 f e2 f c4 d f8 [ \m g ] a4 \me g a2 r4
    bes2^\markup \small "23" g a g4 c, f2 e r4
    e4^\markup \small "24" \m f \me g2 a g4 f f2 e4 f\longa*1/2^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  K'il pùr -- sui -- ve mon "a^m' :" a£ -- £e mon an -- ne -- mi
  Ôá pûiñ pran -- dre ma "vìî' :" L'a£ -- £e pi -- lér je -- té^
  Par "tèrr' :" a£ -- £e me plan -- tér
  Ôá pùs -- siér mon o -- nör je -- té.
  An ta gran -- de fu -- rör sus dre -- se tø, Si -- "ñör :"
  An kùr -- rùs le -- ve tø kon -- tre mez an -- ne -- "mis :"
  É t'é -- bran -- le de -- vèr mø
  Sur l'ar -- rè^t ke tu as ju -- jé.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    c2 f e f4 d c2 bes c4 f g2 f4 e2 r4
    c2 bes c c4 a a2 a e'4 f f4. \m e8 \me d4 cis2 r4
    a'2 g e c4 c d2 g, r4
    %20
    a2 d bes g4 a d2 c4 a2 r
    d e f e4 d c2 c f4 f f4. \m g8 \me a4 g2 r4
    e2 f d d4 d cis2 d a4 bes c8 [ \m d16 e ] f4 \me d fis2 r4
    g2 e f c4 f,8 [ \m g ] \me a4 \m b \me c2 r4
    c2 bes a8 [ \m bes c d ] \me e4 c d2 c4 a\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  K'il pùr -- sui -- ve mon "a^m' :" a£ -- £e mon an -- ne -- mi
  Ôá pûiñ pran -- dre ma "vìî' :" L'a£ -- £e pi -- lér je -- té^
  Par "tèrr' :" a£ -- £e me plan -- tér
  Ôá pùs -- siér mon o -- nör je -- té.
  An ta gran -- de fu -- rör sus dre -- se tø, Si -- "ñör :"
  An kùr -- rùs le -- ve tø kon -- tre mez an -- ne -- "mis :"
  É t'é -- bran -- le de -- vèr mø
  Sur l'ar -- rè^t ke tu as ju -- jé.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    a2 c c f,4 f f2 f4 \m g \me a c g8 [ \m a bes g ] \me c4 c2 r4
    a2 f a g4 f e2 f c'4 d c2 d4 e2 r4
    f2 d c c8 [ \m bes ] \me a4 bes \m a8 [ b ] \me c2 r4
    %20
    f,8 [ \m g ] a4 \me a2 g e4 c' \m bes8 [ a ] \me g4 g f2 r
    a c c c4 f, f2 a a4 c d2 f4 e2 r4 %do # dans l'original
    c2 c bes bes4 a a2 a a4 f8 [ \m g ] \me a [ \m bes ] c4 \me bes a2 r4 %Première note du vers est un ré dans l'original
    d2 c c c8 [ \m bes ] \me a [ \m g ] \me f2 g r4
    c,2 d4 \m e \me f2 g4 a bes8 [ \m a ] g4 \me g f\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  K'il pùr -- sui -- ve mon "a^m' :" a£ -- £e mon an -- ne -- mi
  Ôá pûiñ pran -- dre ma "vìî' :" L'a£ -- £e pi -- lér je -- té^
  Par "tèrr' :" a£ -- £e me plan -- tér
  Ôá pùs -- siér mon o -- nör je -- té.
  An ta gran -- de fu -- rör sus dre -- se tø, Si -- "ñör :"
  An kùr -- rùs le -- ve tø kon -- tre mez an -- ne -- "mis :"
  É t'é -- bran -- le de -- vèr mø
  Sur l'ar -- rè^t ke tu as ju -- jé.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f2 f c a4 bes f2 bes f'4 f es2 f4 c2 r4
    f2 bes, f' c4 d a2 d \bar "" c4 bes f'8 [ \m g ] a4 \me bes a2 r4
    f2 g a4 \m g8 [ f ] \me e4 f d2 c r4
    %20
    f2 d g, c4 a bes2 c4 \bar "" f,2 r
    d' c f c4 bes f2 f' d4 a' bes2 f4 c'2 r4
    c,2 f bes, g4 d' a2 d f4 bes, f2 \bar "" g4 d'2 r4
    g2 c, f e4 f d2 c r4
    a2 g f c'4 f bes,2 c4 f,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  K'il pùr -- sui -- ve mon "a^m' :" a£ -- £e mon an -- ne -- mi
  Ôá pûiñ pran -- dre ma "vìî' :" L'a£ -- £e pi -- lér je -- té^
  Par "tèrr' :" a£ -- £e me plan -- tér
  Ôá pùs -- siér mon o -- nör je -- té.
  An ta gran -- de fu -- rör sus dre -- se tø, Si -- "ñör :"
  An kùr -- rùs le -- ve tø kon -- tre mez an -- ne -- "mis :"
  É t'é -- bran -- le de -- vèr mø
  Sur l'ar -- rè^t ke tu as ju -- jé.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 7-8

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    f,2^\markup \small "25" a g c4 bes a2 d c4 a bes2 a4 g2 r4
    f2^\markup \small "26" d f e4 d cis2 d8 [ \m e ] f4 \me g8 [ \m a ] \me bes4 a2 g4 a2 r4
    c2^\markup \small "27" bes c g4 a f2 e2 r4
    c2^\markup \small "28" f d c4 f f2 e4 \bar "" f2 r
    f^\markup \small "29" g a g4 bes a2 c d4 c bes2 c4 c2 r4
    g2^\markup \small "30" a f g4 f e2 f c4 d f8 [ \m g ] a4 \me g a2 r4
    bes2^\markup \small "31" g a g4 c, f2 e r4
    e4^\markup \small "32" \m f \me g2 a g4 f f2 e4 f\longa*1/2^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar "dè_" pö -- plesÄ l'a -- mas an -- vi -- ro -- nér te viént.
  Pùr lör fèt re -- ju -- jér don -- ke re -- tùrn' an "hôÎt :"
  Kar "lè_" pö -- plez a -- san -- blés
  Il "lè_" døt le Si -- ñör ju -- jér.
  ÔÎ Séi -- ñör sù -- ve -- réin vién me ju -- jér se -- lon
  Ma jus -- tiss', é se -- lon l'in -- té -- gri -- té ki è^t
  An mø, "vién-" -- me juÂ -- jér, vién
  M'ap -- sùdr', éÿ ju -- jér in -- no -- sant.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    %25
    c2 f e f4 d c2 bes c4 f g2 f4 e2 r4
    c2 bes c c4 a a2 a e'4 f f4. \m e8 \me d4 cis2 r4
    a'2 g e c4 c d2 g, r4
    a2 d bes g4 a d2 c4 a2 r
    d e f e4 d c2 c f4 f f4. \m g8 \me a4 g2 r4
    %30
    e2 f d d4 d cis2 d a4 bes c8 [ \m d16 e ] f4 \me d fis2 r4
    g2 e f c4 f,8 [ \m g ] \me a4 \m b \me c2 r4
    c2 bes a8 [ \m bes c d ] \me e4 c d2 c4 a\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar "dè_" pö -- plesÄ l'a -- mas an -- vi -- ro -- nér te viént.
  Pùr lör fèt re -- ju -- jér don -- ke re -- tùrn' an "hôÎt :"
  Kar "lè_" pö -- plez a -- san -- blés
  Il "lè_" døt le Si -- ñör ju -- jér.
  ÔÎ Séi -- ñör sù -- ve -- réin vién me ju -- jér se -- lon
  Ma jus -- tiss', é se -- lon l'in -- té -- gri -- té ki è^t
  An mø, "vién-" -- me juÂ -- jér, vién
  M'ap -- sùdr', éÿ ju -- jér in -- no -- sant.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    %25
    a2 c c f,4 f f2 f4 \m g \me a c g8 [ \m a bes g ] \me c4 c2 r4
    a2 f a g4 f e2 f c'4 d c2 d4 e2 r4
    f2 d c c8 [ \m bes ] \me a4 bes \m a8 [ b ] \me c2 r4
    f,8 [ \m g ] a4 \me a2 g e4 c' \m bes8 [ a ] \me g4 g f2 r
    a c c c4 f, f2 a a4 c d2 f4 e2 r4 %do # dans l'original
    %30
    c2 c bes bes4 a a2 a a4 f8 [ \m g ] \me a [ \m bes ] c4 \me bes a2 r4 %Première note du vers est un ré dans l'original
    d2 c c c8 [ \m bes ] \me a [ \m g ] \me f2 g r4
    c,2 d4 \m e \me f2 g4 a bes8 [ \m a ] g4 \me g f\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar "dè_" pö -- plesÄ l'a -- mas an -- vi -- ro -- nér te viént.
  Pùr lör fèt re -- ju -- jér don -- ke re -- tùrn' an "hôÎt :"
  Kar "lè_" pö -- plez a -- san -- blés
  Il "lè_" døt le Si -- ñör ju -- jér.
  ÔÎ Séi -- ñör sù -- ve -- réin vién me ju -- jér se -- lon
  Ma jus -- tiss', é se -- lon l'in -- té -- gri -- té ki è^t
  An mø, "vién-" -- me juÂ -- jér, vién
  M'ap -- sùdr', éÿ ju -- jér in -- no -- sant.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    %25
    f2 f c a4 bes f2 bes f'4 f es2 f4 c2 r4
    f2 bes, f' c4 d a2 d \bar "" c4 bes f'8 [ \m g ] a4 \me bes a2 r4
    f2 g a4 \m g8 [ f ] \me e4 f d2 c r4
    f2 d g, c4 a bes2 c4 f,2 r
    d' c f c4 bes f2 f' d4 a' bes2 f4 c'2 r4
    %30
    c,2 f bes, g4 d' a2 d f4 bes, f2 \bar "" g4 d'2 r4
    g2 c, f e4 f d2 c r4
    a2 g f c'4 f bes,2 c4 f,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar "dè_" pö -- plesÄ l'a -- mas an -- vi -- ro -- nér te viént.
  Pùr lör fèt re -- ju -- jér don -- ke re -- tùrn' an "hôÎt :"
  Kar "lè_" pö -- plez a -- san -- blés
  Il "lè_" døt le Si -- ñör ju -- jér.
  ÔÎ Séi -- ñör sù -- ve -- réin vién me ju -- jér se -- lon
  Ma jus -- tiss', é se -- lon l'in -- té -- gri -- té ki è^t
  An mø, "vién-" -- me juÂ -- jér, vién
  M'ap -- sùdr', éÿ ju -- jér in -- no -- sant.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 9-10

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    f,2^\markup \small "33" a g c4 bes a2 d c4 a bes2 a4 g2 r4
    f2^\markup \small "34" d f e4 d cis2 d8 [ \m e ] f4 \me g8 [ \m a ] \me bes4 a2 g4 a2 r4
    c2^\markup \small "35" bes c g4 a f2 e2 r4
    c2^\markup \small "36" f d c4 f f2 e4 f2 r
    f^\markup \small "37" g a g4 bes a2 c d4 c bes2 c4 c2 r4
    g2^\markup \small "38" a f g4 f e2 f c4 d f8 [ \m g ] a4 \me g a2 r4
    bes2^\markup \small "39" g a g4 c, f2 e r4
    e4^\markup \small "40" \m f \me g2 a g4 f f2 e4 f\longa*1/2^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  "Dè_" mô -- vès je te pri søtã le mé -- fèt dé -- "fèt :"
  Mès tu ra -- dré -- se -- ras drøtã l'o -- me just' é drøt.
  Kar Diö jus -- te ko -- nøÎt bién
  "Lè_" körs éÿ le de -- dans de nùs.
  An Diö jìît ma dé -- "fans' :" Il gét' éÂ sôÎ -- ve sös
  Ki sont drøs de kù -- "raj' :" Éÿ juÂ -- je drøtã il è^t
  Diö, lui Diö ki tù -- lè^ -- jùrs
  Kant il fôÎt s'é -- mù -- vør s'é -- möt.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    c2 f e f4 d c2 bes c4 f g2 f4 e2 r4
    c2 bes c c4 a a2 a e'4 f f4. \m e8 \me d4 cis2 r4
    %35
    a'2 g e c4 c d2 g, r4
    a2 d bes g4 a d2 c4 a2 r
    d e f e4 d c2 c f4 f f4. \m g8 \me a4 g2 r4
    e2 f d d4 d cis2 d a4 bes c8 [ \m d16 e ] f4 \me d fis2 r4
    g2 e f c4 f,8 [ \m g ] \me a4 \m b \me c2 r4
    %40
    c2 bes a8 [ \m bes c d ] \me e4 c d2 c4 a\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  "Dè_" mô -- vès je te pri søtã le mé -- fèt dé -- "fèt :"
  Mès tu ra -- dré -- se -- ras drøtã l'o -- me just' é drøt.
  Kar Diö jus -- te ko -- nøÎt bién
  "Lè_" körs éÿ le de -- dans de nùs.
  An Diö jìît ma dé -- "fans' :" Il gét' éÂ sôÎ -- ve sös
  Ki sont drøs de kù -- "raj' :" Éÿ juÂ -- je drøtã il è^t
  Diö, lui Diö ki tù -- lè^ -- jùrs
  Kant il fôÎt s'é -- mù -- vør s'é -- möt.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    a2 c c f,4 f f2 f4 \m g \me a c g8 [ \m a bes g ] \me c4 c2 r4
    a2 f a g4 f e2 f c'4 d c2 d4 e2 r4
    %35
    f2 d c c8 [ \m bes ] \me a4 bes \m a8 [ b ] \me c2 r4
    f,8 [ \m g ] a4 \me a2 g e4 c' \m bes8 [ a ] \me g4 g f2 r
    a c c c4 f, f2 a a4 c d2 f4 e2 r4 %do # dans l'original
    c2 c bes bes4 a a2 a a4 f8 [ \m g ] \me a [ \m bes ] c4 \me bes a2 r4 %Première note du vers est un ré dans l'original
    d2 c c c8 [ \m bes ] \me a [ \m g ] \me f2 g r4
    %40
    c,2 d4 \m e \me f2 g4 a bes8 [ \m a ] g4 \me g f\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  "Dè_" mô -- vès je te pri søtã le mé -- fèt dé -- "fèt :"
  Mès tu ra -- dré -- se -- ras drøtã l'o -- me just' é drøt.
  Kar Diö jus -- te ko -- nøÎt bién
  "Lè_" körs éÿ le de -- dans de nùs.
  An Diö jìît ma dé -- "fans' :" Il gét' éÂ sôÎ -- ve sös
  Ki sont drøs de kù -- "raj' :" Éÿ juÂ -- je drøtã il è^t
  Diö, lui Diö ki tù -- lè^ -- jùrs
  Kant il fôÎt s'é -- mù -- vør s'é -- möt.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f2 f c a4 bes f2 bes f'4 f es2 f4 c2 r4
    f2 bes, f' c4 d a2 d c4 bes f'8 [ \m g ] a4 \me \bar "" bes a2 r4
    %35
    f2 g a4 \m g8 [ f ] \me e4 f d2 c r4
    f2 d g, c4 a bes2 c4 f,2 r
    \bar "" d' c f c4 bes f2 f' d4 a' bes2 f4 c'2 r4
    c,2 f bes, g4 d' a2 d f4 bes, f2 \bar "" g4 d'2 r4
    g2 c, f e4 f d2 c r4
    %40
    a2 g f c'4 f bes,2 c4 f,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  "Dè_" mô -- vès je te pri søtã le mé -- fèt dé -- "fèt :"
  Mès tu ra -- dré -- se -- ras drøtã l'o -- me just' é drøt.
  Kar Diö jus -- te ko -- nøÎt bién
  "Lè_" körs éÿ le de -- dans de nùs.
  An Diö jìît ma dé -- "fans' :" Il gét' éÂ sôÎ -- ve sös
  Ki sont drøs de kù -- "raj' :" Éÿ juÂ -- je drøtã il è^t
  Diö, lui Diö ki tù -- lè^ -- jùrs
  Kant il fôÎt s'é -- mù -- vør s'é -- möt.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 11-12

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    f,2^\markup \small "41" a g c4 bes a2 d c4 a bes2 a4 g2 r4
    f2^\markup \small "42" d f e4 d cis2 d8 [ \m e ] f4 \me g8 [ \m a ] \me bes4 a2 g4 a2 r4
    c2^\markup \small "43" bes c g4 a f2 e2 r4
    c2^\markup \small "44" f d c4 f f2 e4 f2 r
    f^\markup \small "45" g a g4 bes a2 c d4 c bes2 c4 c2 r4
    g2^\markup \small "46" a f g4 f e2 f c4 d f8 [ \m g ] a4 \me g a2 r4
    bes2^\markup \small "47" g a g4 c, f2 e r4
    e4^\markup \small "48" \m f \me g2 a g4 f f2 e4 f\longa*1/2^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  S'il ne çan -- je d'a -- vis, s'il ne re -- tùrn' aÂ "sø :"
  Mès si pèr -- sé -- vé -- rant an sa mé -- çan -- se -- té
  Fèt son glè^ -- ve ra -- gui -- zér,
  Son ark band' é le tiént tù -- prè^t.
  Kan -- bién pùr s'é -- ki -- pér d'ar -- mez, ù -- tìîs de môrt,
  Ôs siéns flè -- çezã a fö fôr -- jér i -- "røt :" Ve -- la
  K'il s'an -- çar -- je de fôr -- fèt,
  Kon -- søt mal, le mé -- fèt pro -- duit.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    c2 f e f4 d c2 bes c4 f g2 f4 e2 r4
    c2 bes c c4 a a2 a e'4 f f4. \m e8 \me d4 cis2 r4
    a'2 g e c4 c d2 g, r4
    a2 d bes g4 a d2 c4 a2 r
    %45
    d e f e4 d c2 c f4 f f4. \m g8 \me a4 g2 r4
    e2 f d d4 d cis2 d a4 bes c8 [ \m d16 e ] f4 \me d fis2 r4
    g2 e f c4 f,8 [ \m g ] \me a4 \m b \me c2 r4
    c2 bes a8 [ \m bes c d ] \me e4 c d2 c4 a\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  S'il ne çan -- je d'a -- vis, s'il ne re -- tùrn' aÂ "sø :"
  Mès si pèr -- sé -- vé -- rant an sa mé -- çan -- se -- té
  Fèt son glè^ -- ve ra -- gui -- zér,
  Son ark band' é le tiént tù -- prè^t.
  Kan -- bién pùr s'é -- ki -- pér d'ar -- mez, ù -- tìîs de môrt,
  Ôs siéns flè -- çezã a fö fôr -- jér i -- "røt :" Ve -- la
  K'il s'an -- çar -- je de fôr -- fèt,
  Kon -- søt mal, le mé -- fèt pro -- duit.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    a2 c c f,4 f f2 f4 \m g \me a c g8 [ \m a bes g ] \me c4 c2 r4
    a2 f a g4 f e2 f c'4 d c2 d4 e2 r4
    f2 d c c8 [ \m bes ] \me a4 bes \m a8 [ b ] \me c2 r4
    f,8 [ \m g ] a4 \me a2 g e4 c' \m bes8 [ a ] \me g4 g f2 r
    %45
    a c c c4 f, f2 a a4 c d2 f4 e2 r4 %do # dans l'original
    c2 c bes bes4 a a2 a a4 f8 [ \m g ] \me a [ \m bes ] c4 \me bes a2 r4 %Première note du vers est un ré dans l'original
    d2 c c c8 [ \m bes ] \me a [ \m g ] \me f2 g r4
    c,2 d4 \m e \me f2 g4 a bes8 [ \m a ] g4 \me g f\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  S'il ne çan -- je d'a -- vis, s'il ne re -- tùrn' aÂ "sø :"
  Mès si pèr -- sé -- vé -- rant an sa mé -- çan -- se -- té
  Fèt son glè^ -- ve ra -- gui -- zér,
  Son ark band' é le tiént tù -- prè^t.
  Kan -- bién pùr s'é -- ki -- pér d'ar -- mez, ù -- tìîs de môrt,
  Ôs siéns flè -- çezã a fö fôr -- jér i -- "røt :" Ve -- la
  K'il s'an -- çar -- je de fôr -- fèt,
  Kon -- søt mal, le mé -- fèt pro -- duit.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f2 f c a4 bes f2 bes f'4 f es2 f4 c2 r4
    f2 bes, f' c4 d a2 d c4 bes f'8 [ \m g ] a4 \me \bar "" bes a2 r4
    f2 g a4 \m g8 [ f ] \me e4 f d2 c r4
    f2 d g, c4 a bes2 c4 f,2 r
    %45
    d' c \bar "" f c4 bes f2 f' d4 a' bes2 f4 c'2 r4
    c,2 f bes, g4 d' a2 d f4 bes, f2 g4 d'2 r4
    \bar "" g2 c, f e4 f d2 c r4
    a2 g f c'4 f bes,2 c4 f,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  S'il ne çan -- je d'a -- vis, s'il ne re -- tùrn' aÂ "sø :"
  Mès si pèr -- sé -- vé -- rant an sa mé -- çan -- se -- té
  Fèt son glè^ -- ve ra -- gui -- zér,
  Son ark band' é le tiént tù -- prè^t.
  Kan -- bién pùr s'é -- ki -- pér d'ar -- mez, ù -- tìîs de môrt,
  Ôs siéns flè -- çezã a fö fôr -- jér i -- "røt :" Ve -- la
  K'il s'an -- çar -- je de fôr -- fèt,
  Kon -- søt mal, le mé -- fèt pro -- duit.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

% strophes 13-14

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    f,2^\markup \small "49" a g c4 bes a2 d c4 a bes2 a4 g2 r4
    f2^\markup \small "50" d f e4 d cis2 d8 [ \m e ] f4 \me g8 [ \m a ] \me bes4 a2 g4 a2 r4
    c2^\markup \small "51" bes c g4 a f2 e2 r4
    c2^\markup \small "52" f d c4 f f2 e4 f2 r
    f^\markup \small "53" g a g4 bes a2 c d4 c bes2 c4 c2 r4
    g2^\markup \small "54" a f g4 f e2 f c4 d f8 [ \m g ] a4 \me g a2 r4
    bes2^\markup \small "55" g a g4 c, f2 e r4
    e4^\markup \small "56" \m f \me g2 a g4 f f2 e4 f\longa*1/2^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Fètã é krö -- ze la fôÊss' ùÿ tre -- bu -- çé se pèrd.
  A -- prè -- té^ i l'a -- "vøtã :" mès se tra -- va£ re -- va
  Sur son "çèf :" é se fôr -- fèt
  Sur sa tè^ -- te re -- tun -- be -- ra.
  Ôá Séi -- ñör m'an i -- rè ran -- dre l'o -- nör ke dø
  Pùr la grand' é -- ki -- té k'an ma fa -- vör i "fèt :"
  É dès seôÎ -- mesÄ je çan -- trè
  Ôá séint nom du Si -- ñör tré -- hôÎt.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    c2 f e f4 d c2 bes c4 f g2 f4 e2 r4
    %50
    c2 bes c c4 a a2 a e'4 f f4. \m e8 \me d4 cis2 r4
    a'2 g e c4 c d2 g, r4
    a2 d bes g4 a d2 c4 a2 r
    d e f e4 d c2 c f4 f f4. \m g8 \me a4 g2 r4
    e2 f d d4 d cis2 d a4 bes c8 [ \m d16 e ] f4 \me d fis2 r4
    %55
    g2 e f c4 f,8 [ \m g ] \me a4 \m b \me c2 r4
    c2 bes a8 [ \m bes c d ] \me e4 c d2 c4 a\longa*1/2^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Fètã é krö -- ze la fôÊss' ùÿ tre -- bu -- çé se pèrd.
  A -- prè -- té^ i l'a -- "vøtã :" mès se tra -- va£ re -- va
  Sur son "çèf :" é se fôr -- fèt
  Sur sa tè^ -- te re -- tun -- be -- ra.
  Ôá Séi -- ñör m'an i -- rè ran -- dre l'o -- nör ke dø
  Pùr la grand' é -- ki -- té k'an ma fa -- vör i "fèt :"
  É dès seôÎ -- mesÄ je çan -- trè
  Ôá séint nom du Si -- ñör tré -- hôÎt.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    a2 c c f,4 f f2 f4 \m g \me a c g8 [ \m a bes g ] \me c4 c2 r4
    %50
    a2 f a g4 f e2 f c'4 d c2 d4 e2 r4
    f2 d c c8 [ \m bes ] \me a4 bes \m a8 [ b ] \me c2 r4
    f,8 [ \m g ] a4 \me a2 g e4 c' \m bes8 [ a ] \me g4 g f2 r
    a c c c4 f, f2 a a4 c d2 f4 e2 r4 %do # dans l'original
    c2 c bes bes4 a a2 a a4 f8 [ \m g ] \me a [ \m bes ] c4 \me bes a2 r4 %Première note du vers est un ré dans l'original
    %55
    d2 c c c8 [ \m bes ] \me a [ \m g ] \me f2 g r4
    c,2 d4 \m e \me f2 g4 a bes8 [ \m a ] g4 \me g f\longa*1/2^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Fètã é krö -- ze la fôÊss' ùÿ tre -- bu -- çé se pèrd.
  A -- prè -- té^ i l'a -- "vøtã :" mès se tra -- va£ re -- va
  Sur son "çèf :" é se fôr -- fèt
  Sur sa tè^ -- te re -- tun -- be -- ra.
  Ôá Séi -- ñör m'an i -- rè ran -- dre l'o -- nör ke dø
  Pùr la grand' é -- ki -- té k'an ma fa -- vör i "fèt :"
  É dès seôÎ -- mesÄ je çan -- trè
  Ôá séint nom du Si -- ñör tré -- hôÎt.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f2 f c a4 bes f2 bes f'4 f es2 f4 c2 r4
    %50
    f2 bes, f' c4 d a2 d c4 bes f'8 [ \m g ] a4 \me bes a2 r4
    f2 g \bar "" a4 \m g8 [ f ] \me e4 f d2 c r4
    f2 d g, c4 a bes2 c4 f,2 r
    d' c f c4 bes f2 f' d4 a' bes2 f4 c'2 r4
    c,2 f \bar "" bes, g4 d' a2 d f4 bes, f2 g4 d'2 r4
    %55
    g2 c, f e4 f d2 c r4
    a2 g f c'4 f bes,2 c4 f,\longa*1/2^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Fètã é krö -- ze la fôÊss' ùÿ tre -- bu -- çé se pèrd.
  A -- prè -- té^ i l'a -- "vøtã :" mès se tra -- va£ re -- va
  Sur son "çèf :" é se fôr -- fèt
  Sur sa tè^ -- te re -- tun -- be -- ra.
  Ôá Séi -- ñör m'an i -- rè ran -- dre l'o -- nör ke dø
  Pùr la grand' é -- ki -- té k'an ma fa -- vör i "fèt :"
  É dès seôÎ -- mesÄ je çan -- trè
  Ôá séint nom du Si -- ñör tré -- hôÎt.
}


\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}
