global = {
  #(set-accidental-style 'forget)
  \once \override Staff.Clef #'full-size-change = ##t
  \set Staff.forceClef = ##t
  \set Score.defaultBarType = "empty"
  \time 4/4
  \override Voice.NoteHead #'style = #'baroque
  \override Score.BarNumber #'padding = #3
}

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-g" 
      \key f \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d''4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    d4^\markup \small "1" a bes2 g f4 bes c2 d c4 d bes2 a r
    bes4^\markup \small "2" g d'2 bes c4 d es2 d c4 bes c2 bes r
    d4^\markup \small "3" g fis2 g g4 f e2 d es4 d c2 bes c4 bes a2 g r
    g4^\markup \small "4" d' bes2 a bes4 c d2 c d4 e f2 d r
    d4^\markup \small "5" es d2 g fis4 g es2 d g,4 c bes2 a r
    bes4^\markup \small "6" g a2 f g4 a bes2 a d4 c bes2 es d4 c d2 d r
    g4^\markup \small "7" d f2 e f4 c es2 d c4 g bes2 a r
    bes4^\markup \small "8" c d2 c d4 e f2 d e4 f g2 fis r
    \repeat volta 2 {
      g4^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "9"} e f2 d es4 c d2 bes c4 a bes2 g fis4 g d'2 b\longa*1/2^\fermata
    }
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pre -- te L'ô -- rè£' aÂ ma kon -- pléin -- te, Si -- ñör "Diö :"
  Vé -- £ez an -- tan -- dre le mur -- mur de ma pan -- sé^.
  Ma kla -- mör ø, ko -- me mon Rø, ko -- me mon Diö. Si te pri -- rè.
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis :"
}

quintusIncipit = <<
  \new MensuralVoice = "quintusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c1" 
      \key f \major \mark \markup{\hspace #8 \small "Cinquiesme"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


quintusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    g4 fis g8 [ \m f e d ] \me e2 c4 d a'2 bes a4 f8 [ \m d ] \me es [ \m d ] g4 \me fis2 r
    d4 e f2 g g8 [ \m a ] \me bes [ \m a ] \me c [ \m bes g a ] \me bes2 a4 bes a2 f r
    bes4 bes a2 c8 [ \m bes g a ] \me bes [ \m c ] \me d4 cis2 a4. \m g16 [ f ] \me g8 [ \m a ] \me bes4 a2 f4. \m e16 [ d ] \me e8  [ \m fis ] \me g4 fis2 g r
    d4 a' g2 fis g4 a g8 [ \m f ] g4 \me a2 bes4 bes c2 bes r
    %5
    f4 c' a \m bes \me bes \m c \me d d c2 g g4 a g2 fis r
    g4 e e2 d d8 [ \m e ] \me f [ \m e ] \me g2 c, g'4 e d2 g fis4 g a2 b r
    bes4 g d'2 cis d4 a c2 g e4 c g'2 fis r
    g4 a bes2 a f4 g a2 g4. \m a8 \me bes [ \m c ] \me d4 g,2 d' r
    \repeat volta 2 {
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" cis d2 bes c4 a bes2 g g4 fis g2 e d4 g fis2 g\longa*1/2^\fermata
    }
  }
}

quintusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pre -- te L'ô -- rè£' aÂ ma kon -- pléin -- te, Si -- ñör "Diö :"
  Vé -- £ez an -- tan -- dre le mur -- mur de ma pan -- sé^.
  Ma kla -- mör ø, ko -- me mon Rø, ko -- me mon Diö. Si te pri -- rè.
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis :"
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c2" 
      \set Staff.keySignature = #`(((-1 . 6) . ,FLAT)
                                   ((0 . 6) . ,FLAT))
      \mark \markup{\hspace #10.5 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      bes4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s r
    bes4 a d2 d d4 f f \m e8 [ d ] \me e2 g4 g a2 f r
    %5
    bes4 g f2 g a4 bes g2 g8 [ \m f e d ] \me e4 f d2 d r
    d4 c cis2 d8 [ \m e f d ] \me g4 c, d \m e \me f2 bes4 a f2 c'4. \m bes8 \me a4 g fis2 g r
    g4 bes a2 a a4 f g2 d g4 es d2 d r
    d4 f f2 f d4 c a2 bes g4 d' cis8 [ \m b ] cis4 \me d2 r
    \repeat volta 2 {
      bes'4^\markup \musicglyph #"scripts.usignumcongruentiae" a a2 g g4 f f \m e8 [ d ] \me es2 \saon es4 \saof d8 [ \m c ] \me bes [ \m a ] g4 \me g2 d'4 c d2 d\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis :"
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key f \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      b4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    b4 d g,2 c4. \m bes8 \me a4 g f2 bes8 [ \m c d e ] \me f4 bes,4 g2 d' r
    g,4 c bes2 \bar "" es \nr es4 \fo d c2 g'8 [ \m f d e ] \me f4 g f2 bes, r
    g4 g d'2 e4. \m f8 \me g4 d a'4. \m g8 \me f [ \m e ] d4 \bar "" \me c bes f'4. \m e8 \me d [ \m c ] bes4 \me a g d'2 g, r
    g4 fis g2 d'4. \m c8 \me bes4 a bes2 a g4 g' \bar "" f2 bes, r
    %5
    bes4 c d2 es d4 g c,2 b c4 f, g2 d r
    g4 c a2 bes \bar "" bes4 a g2 f g4 a bes2 c d4 es d2 g, r
    d'4 g f8 [ \m e ] d4 \me e2 d4 c c2 b c4 c bes8 [ \m a ] g4 \me a2 r
    g4 c bes2 c4. \m bes8 \me a4 g d'2 d4. \m c8 \me bes4 a g2 a2 r
    \repeat volta 2 {
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" a a8 [ \m bes16 c ] d4 \me d2 c4 c bes2 bes8 [ \m a ] g4 \me g d' d2 c4. \m bes8 \me a4 g a2 g\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pre -- te L'ô -- rè£' aÂ ma kon -- pléin -- te, Si -- ñör "Diö :"
  Vé -- £ez an -- tan -- dre le mur -- mur de ma pan -- sé^.
  Ma kla -- mör ø, ko -- me mon Rø, ko -- me mon Diö. Si te pri -- rè.
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis :"
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f3" 
      \set Staff.keySignature = #`(((-2 . 6) . ,FLAT)
                                   ((-1 . 6) . ,FLAT))
      \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      g4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    %5
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    g'4 g d2 a' d,4 f c2 g' \bar "" c,4 c g2 d' r
    g4 f bes,2 f' f4 e d2 g g4 f e2 d r
    \repeat volta 2 {
      g4^\markup \musicglyph #"scripts.usignumcongruentiae" a d,2 g c,4 f bes,2 es c4 d g2 c, d4 es d2 g,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis :"
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.7 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      quintusNotes << \global \incipit \quintusIncipit #5.2 \quintusNotes >>
    \new Lyrics =
      quintusLyrics \lyricsto quintusNotes { \quintusLyrics }    
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #6.0 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.2 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #5.5 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001.ly"
  \header {
    filename =  "005preteLoreille.ly"
    title = "Psaume V"
    subtitle = " "
    opus = " "
    composer = "Claude Le Jeune"
    poet = "Jean-Antoine de Baïf (1573)"
  }
}

%% Strophes 4-5-6

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    d4^\markup \small "10" a bes2 g f4 bes c2 d c4 d bes2 a r
    bes4^\markup \small "11" g d'2 bes c4 d es2 d c4 bes c2 bes r
    d4^\markup \small "12" g fis2 g g4 f e2 d es4 d c2 bes c4 bes a2 g r
    g4^\markup \small "13" d' bes2 a bes4 c d2 c d4 e f2 d r
    d4^\markup \small "14" es d2 g fis4 g es2 d g,4 c bes2 a r
    bes4^\markup \small "15" g a2 f g4 a bes2 a d4 c bes2 es d4 c d2 d r
    g4^\markup \small "16" d f2 e f4 c es2 d c4 g bes2 a r
    bes4^\markup \small "17" c d2 c d4 e f2 d e4 f g2 fis r
    \repeat volta 2 {
      g4^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "18"} e f2 d es4 c d2 bes c4 a bes2 g fis4 g d'2 b\longa*1/2^\fermata
    }
    \cadenzaOff
  }
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

quintusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Cinquiesme "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    %10
    g4 fis g8 [ \m f e d ] \me e2 c4 d a'2 bes a4 f8 [ \m d ] \me es [ \m d ] g4 \me fis2 r
    d4 e f2 g g8 [ \m a ] \me bes [ \m a ] \me c [ \m bes g a ] \me bes2 a4 bes a2 f r
    bes4 bes a2 c8 [ \m bes g a ] \me bes [ \m c ] \me d4 cis2 a4. \m g16 [ f ] \me g8 [ \m a ] \me bes4 a2 f4. \m e16 [ d ] \me e8 [ \m fis ] \me g4 fis2 g r
    d4 a' g2 fis g4 a g8 [ \m f ] g4 \me a2 bes4 bes c2 bes r
    f4 c' a \m bes \me bes \m c \me d d c2 g g4 a g2 fis r
    %15
    g4 e e2 d d8 [ \m e ] \me f [ \m e ] \me g2 c, g'4 e d2 g fis4 g a2 b r
    bes4 g d'2 cis d4 a c2 g e4 c g'2 fis r
    g4 a bes2 a f4 g a2 g4. \m a8 \me bes [ \m c ] \me d4 g,2 d' r
    \repeat volta 2 {
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" cis d2 bes c4 a bes2 g g4 fis g2 e d4 g fis2 g\longa*1/2^\fermata
    }
  }
}

quintusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    %10
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    bes4 a d2 d d4 f f \m e8 [ d ] \me e2 g4 g a2 f r
    bes4 g f2 g a4 bes g2 g8 [ \m f e d ] \me e4 f d2 d r
    %15
    d4 c cis2 d8 [ \m e f d ] \me g4 c, d \m e \me f2 bes4 a f2 c'4. \m bes8 \me a4 g fis2 g r
    g4 bes a2 a a4 f g2 d g4 es d2 d r
    d4 f f2 f d4 c a2 bes g4 d' cis8 [ \m b ] cis4 \me d2 r
    \repeat volta 2 {
      bes'4^\markup \musicglyph #"scripts.usignumcongruentiae" a a2 g g4 f f \m e8 d \me es2 \saon es4 \saof d8 [ \m c ] \me bes [ \m a ] g4 \me g2 d'4 c d2 d\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  %Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  %Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    %10
    b4 d g,2 c4. \m bes8 \me a4 g f2 bes8 [ \m c d e ] \me f4 bes,4 g2 d' r
    g,4 c bes2 es \nr es4 \fo d \bar "" c2 g'8 [ \m f d e ] \me f4 g f2 bes, r
    g4 g d'2 e4. \m f8 \me g4 d a'4. \m g8 \me f [ \m e ] d4 \me c bes f'4. \m e8 \me \bar "" d [ \m c ] bes4 \me a g d'2 g, r
    g4 fis g2 d'4. \m c8 \me bes4 a bes2 a g4 g' f2 bes, r
    bes4 c \bar "" d2 es d4 g c,2 b c4 f, g2 d r
    %15
    g4 c a2 bes bes4 a g2 \bar "" f g4 a bes2 c d4 es d2 g, r
    d'4 g f8 [ \m e ] d4 \me e2 d4 c c2 b c4 c bes8 [ \m a ] g4 \me a2 r
    g4 c bes2 c4. \m bes8 \me a4 g d'2 d4. \m c8 \me bes4 a g2 a2 r
    \repeat volta 2 {
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" a a8 [ \m bes16 c ] d4 \me d2 c4 c bes2 bes8 [ \m a ] g4 \me g d' d2 c4. \m bes8 \me a4 g a2 g\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    %10
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    %15
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    g'4 g d2 a' d,4 f c2 g' c,4 c g2 \bar "" d' r
    g4 f bes,2 f' f4 e d2 g g4 f e2 d r
    \repeat volta 2 {
      g4^\markup \musicglyph #"scripts.usignumcongruentiae" a d,2 g c,4 f bes,2 es c4 d g2 c, d4 es d2 g,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  %Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  %Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  %Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  %Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  %Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      quintusNotes << \global \quintusNotes >>
    \new Lyrics =
      quintusLyrics \lyricsto quintusNotes { \quintusLyrics }    
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 7-8-9

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    d4^\markup \small "19" a bes2 g f4 bes c2 d c4 d bes2 a r
    bes4^\markup \small "20" g d'2 bes c4 d es2 d c4 bes c2 bes r
    d4^\markup \small "21" g fis2 g g4 f e2 d es4 d c2 bes c4 bes a2 g r
    g4^\markup \small "22" d' bes2 a bes4 c d2 c d4 e f2 d r
    d4^\markup \small "23" es d2 g fis4 g es2 d g,4 c bes2 a r
    bes4^\markup \small "24" g a2 f g4 a bes2 a d4 c bes2 es d4 c d2 d r
    g4^\markup \small "25" d f2 e f4 c es2 d c4 g bes2 a r
    bes4^\markup \small "26" c d2 c d4 e f2 d e4 f g2 fis r
    \repeat volta 2 {
      g4^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "27"} e f2 d es4 c d2 bes c4 a bes2 g fis4 g d'2 b\longa*1/2^\fermata
    }
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

quintusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Cinquiesme "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    g4 fis g8 [ \m f e d ] \me e2 c4 d a'2 bes a4 f8 [ \m d ] \me es [ \m d ] g4 \me fis2 r
    %20
    d4 e f2 g g8 [ \m a ] \me bes [ \m a ] \me c [ \m bes g a ] \me bes2 a4 bes a2 f r
    bes4 bes a2 c8 [ \m bes g a ] \me bes [ \m c ] \me d4 cis2 a4. \m g16 [ f ] \me g8 [ \m a ] \me bes4 a2 f4. \m e16 [ d ] \me e8 [ \m fis ] \me g4 fis2 g r
    d4 a' g2 fis g4 a g8 [ \m f ] g4 \me a2 bes4 bes c2 bes r
    f4 c' a \m bes \me bes \m c \me d d c2 g g4 a g2 fis r
    g4 e e2 d d8 [ \m e ] \me f [ \m e ] \me g2 c, g'4 e d2 g fis4 g a2 b r
    %25
    bes4 g d'2 cis d4 a c2 g e4 c g'2 fis r
    g4 a bes2 a f4 g a2 g4. \m a8 \me bes [ \m c ] \me d4 g,2 d' r
    \repeat volta 2 {
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" cis d2 bes c4 a bes2 g g4 fis g2 e d4 g fis2 g\longa*1/2^\fermata
    }
  }
}

quintusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    s4 s s2 s s4 s s2 s s4 s s2 s s
    %20
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    bes4 a d2 d d4 f f \m e8 [ d ] \me e2 g4 g a2 f r
    bes4 g f2 g a4 bes g2 g8 [ \m f e d ] \me e4 f d2 d r
    d4 c cis2 d8 [ \m e f d ] \me g4 c, d \m e \me f2 bes4 a f2 c'4. \m bes8 \me a4 g fis2 g r
    %25
    g4 bes a2 a a4 f g2 d g4 es d2 d r
    d4 f f2 f d4 c a2 bes g4 d' cis8 [ \m b ] cis4 \me d2 r
    \repeat volta 2 {
      bes'4^\markup \musicglyph #"scripts.usignumcongruentiae" a a2 g g4 f f \m e8 [ d ] \me es2 \saon es4 \saof d8 [ \m c ] \me bes [ \m a ] g4 \me g2 d'4 c d2 d\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  %Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  %É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    b4 d g,2 c4. \m bes8 \me a4 g f2 bes8 [ \m c d e ] \me f4 bes,4 g2 d' r
    %20
    g,4 c bes2 \bar "" es \nr es4 \fo d c2 g'8 [ \m f d e ] \me f4 g f2 bes, r
    g4 g d'2 e4. \m f8 \me g4 d \bar "" a'4. \m g8 \me f [ \m e ] d4 \me c bes f'4. \m e8 \me d [ \m c ] bes4 \me a g d'2 g, r
    g4 fis g2 d'4. \m c8 \me \bar "" bes4 a bes2 a g4 g' f2 bes, r
    bes4 c d2 es d4 g c,2 \bar "" b c4 f, g2 d r
    g4 c a2 bes bes4 a g2 f g4 a \bar "" bes2 c d4 es d2 g, r
    %25
    d'4 g f8 [ \m  e ] d4 \me e2 d4 c c2 b c4 c bes8 [ \m a ] g4 \me a2 r
    g4 c bes2 c4. \m bes8 \me a4 g d'2 d4. \m c8 \me bes4 a g2 a2 r
    \repeat volta 2 {
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" a a8 [ \m bes16 c ] d4 \me d2 c4 c bes2 bes8 [ \m a ] g4 \me g d' d2 c4. \m bes8 \me a4 g a2 g\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    s4 s s2 s s4 s s2 s s4 s s2 s s
    %20
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    %25
    g'4 g d2 a' d,4 f c2 g' c,4 c g2 \bar "" d' r
    g4 f bes,2 f' f4 e d2 g g4 f e2 d r \noBreak
    \repeat volta 2 {
      g4^\markup \musicglyph #"scripts.usignumcongruentiae" a d,2 \bar ""  g c,4 f bes,2 es c4 d g2 c, d4 es d2 g,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  %Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  %É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  %Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  %Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  %UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      quintusNotes << \global \quintusNotes >>
    \new Lyrics =
      quintusLyrics \lyricsto quintusNotes { \quintusLyrics }    
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}

%% Strophes 10 - 11

discantusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Dessus "
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    g4^\markup \small "28" d' bes2 a bes4 c d2 c d4 e f2 d r
    \once \override TextScript #'padding = #1.5 d4^\markup \small "29" es d2 g fis4 g es2 d g,4 c bes2 a r
    bes4^\markup \small "30" g a2 f g4 a bes2 a d4 c bes2 es d4 c d2 d r
    g4^\markup \small "31" d f2 e f4 c es2 d c4 g bes2 a r
    bes4^\markup \small "32" c d2 c d4 e f2 d e4 f g2 fis r
    \repeat volta 2 {
      g4^\markup{\musicglyph #"scripts.usignumcongruentiae" \small "33"} e f2 d es4 c d2 bes c4 a bes2 g fis4 g d'2 b\longa*1/2^\fermata
    }
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

quintusNotes = {
  \relative c'' {
    %\set Staff.instrumentName = "Cinquiesme "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    d,4 a' g2 fis g4 a g8 [ \m f ] g4 \me a2 bes4 bes c2 bes r
    f4 c' a \m bes \me bes \m c \me d d c2 g g4 a g2 fis r
    %30
    g4 e e2 d d8 [ \m e ] \me f [ \m e ] \me g2 c, g'4 e d2 g fis4 g a2 b r
    bes4 g d'2 cis d4 a c2 g e4 c g'2 fis r
    g4 a bes2 a f4 g a2 g4. \m a8 \me bes [ \m c ] \me d4 g,2 d' r
    \repeat volta 2 {
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" cis d2 bes c4 a bes2 g g4 fis g2 e d4 g fis2 g\longa*1/2^\fermata
    }
  }
}

quintusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

altusNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Haute-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    bes4 a d2 d d4 f f \m e8 [d ] \me e2 g4 g a2 f r
    bes4 g f2 g a4 bes g2 g8 [ \m f e d ] \me e4 f d2 d r
    %30
    d4 c cis2 d8 [ \m e f d ] \me g4 c, d \m e \me f2 bes4 a f2 c'4. \m bes8 \me a4 g fis2 g r
    g4 bes a2 a a4 f g2 d g4 es d2 d r
    d4 f f2 f d4 c a2 bes g4 d' cis8 [ \m b ] cis4 \me d2 r
    \repeat volta 2 {
      bes'4^\markup \musicglyph #"scripts.usignumcongruentiae" a a2 g g4 f f \m e8 [ d ] \me es2 \saon es4 \saof d8 [ \m c ] \me bes [ \m a ] g4 \me g2 d'4 c d2 d\longa*1/2^\fermata
    }
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

tenorNotes = {
  \relative c' {
    %\set Staff.instrumentName = "Taille "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "G_8"
    g4 fis g2 d'4. \m c8 \me bes4 a bes2 a g4 g' f2 bes, r
    bes4 c d2 es d4 g \bar ""  c,2 b \noBreak c4 f, g2 d r
    %30
    g4 c a2 bes bes4 a g2 f g4 a bes2 \bar "" c d4 es d2 g, r
    d'4 g f8 [ \m  e ] d4 \me e2 d4 c c2 b c4 c bes8 [ \m a ] g4 \me a2 r
    g4 c bes2 c4. \m bes8 \me a4 g d'2 d4. \m c8 \me bes4 a g2 a2 r
    \repeat volta 2 { 
      d4^\markup \musicglyph #"scripts.usignumcongruentiae" a a8 [ \m bes16 c ] d4 \me d2 c4 c bes2 bes8 [ \m a ] g4 \me g d' d2 c4. \m bes8 \me a4 g a2 g\longa*1/2^\fermata
    }
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

bassusNotes = {
  \relative c {
    %\set Staff.instrumentName = "Basse-contre "
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    s4 s s2 s s4 s s2 s s4 s s2 s s
    s4 s s2 s s4 s s2 s s4 s s2 s s
    %30
    s4 s s2 s s4 s s2 s s4 s s2 s s4 s s2 s s
    g'4 g  d2 a' d,4 f c2 g' c,4 c g2 d' \bar "" r
    g4 f bes,2 f' f4 e d2 g g4 f e2 d  r
    \repeat volta 2 {
      g4^\markup \musicglyph #"scripts.usignumcongruentiae" a \bar "" d,2 g c,4 f bes,2 es c4 d g2 c, d4 es d2 g,\longa*1/2^\fermata
    }
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  %Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  %É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  %Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      quintusNotes << \global \quintusNotes >>
    \new Lyrics =
      quintusLyrics \lyricsto quintusNotes { \quintusLyrics }    
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
    }
  }
  \include "../include/layout001nr.ly"
}
