global = {
  #(set-accidental-style 'forget)
  
  \once \override Staff.Clef #'full-size-change = ##t
  \set Staff.forceClef = ##t
  \set Score.defaultBarType = "empty"
  \time 4/4
  \override Voice.NoteHead #'style = #'baroque
  \override Score.BarNumber #'padding = #3
 
}

discantusIncipit = <<
  \new MensuralVoice = "discantusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-g" 
      \key f \major \mark \markup{\hspace #3 \small "Dessus"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      a'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    a4^\markup \small "1" a bes2 a a4 d c2 bes a4 f g2 a r
    c4^\markup \small "2" d e2 f f4 d f2 e d4 d cis2 d r
    a4^\markup \small "3" a d2 c c4 a f'2 e c4 d bes2 a g4 f g2 a1 r2
    c4^\markup \small "4" c d2 d f4 f8 [ \m e ] \me d2 c f,4 f' f2 e r2
    c4^\markup \small "5" c8 [ \m bes ] \me a2 g f4 e a2 f g4 a g2 c
    c4^\markup \small "6" b c2 c f,4 f c'2 c d4 e f2 f, g4 a bes2 a1
    
    r2 d4^\markup \small "7" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "8" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "9" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d1
      
    r2 d4^\markup \small "7b" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "8b" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "9b" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d\longa*1/4^\fermata
   
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pre -- te L'ô -- rè£' aÂ ma kon -- pléin -- te, Si -- ñör "Diö :"
  Vé -- £ez an -- tan -- dre le mur -- mur de ma pan -- sé^.
  Ma kla -- mör ø, ko -- me mon Rø, ko -- me mon Diö. Si te pri -- rè.
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
}

altusIncipit = <<
  \new MensuralVoice = "altusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c2" 
      \set Staff.keySignature = #`(((-1 . 6) . ,FLAT)
                                   ((-0 . 6) . ,FLAT))
      \mark \markup{\hspace #9 \small "Haute-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      a'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>


altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    a'4 f d2 f f4 f f \m c \me g'2 c,4 d d \m e \me f2 r
    f4 f g2 a a4 bes a2 c a4 a a4. \m g8 \me fis2 r
    \nr \saon f4 \saof \fo f g2 a a4 c bes \m a \me c2 f,4 f g2 c,4 \m d \me e f e2 f1 r2
    a4 a d,2 bes' a4 c bes2 a c4 bes a \m b \me c2 r
    %5
    a4 g f2 e f4 c a2 a c4 c c2 c4. \m d8 \me 
    e4 f g2 a c4 bes a2 g4 \m a \me b c a2 bes bes4 a g2 c,1
    
    r2 g'4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis1
      
    r2 g4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis\longa*1/4^\fermata
    
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pre -- te L'ô -- rè£' aÂ ma kon -- pléin -- te, Si -- ñör "Diö :"
  Vé -- £ez an -- tan -- dre le mur -- mur de ma pan -- sé^.
  Ma kla -- mör ø, ko -- me mon Rø, ko -- me mon Diö. Si te pri -- rè.
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
}

tenorIncipit = <<
  \new MensuralVoice = "tenorIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-c3" 
      \key f \major \mark \markup{\hspace #2 \small "Taille"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    d4 d bes2 c d4 a a2 d4. \m e8 \me f4 f bes,2 c r
    a4 a c2 c d4 d d2 e4 \m a, \me d f e2 a, r
    c4 d d2 f f4 e d2 g a4 d, d2 f e4 a, c2 c1 r2
    c4 f f2 g f4 f f2 f c4 d f2 g r
    %5
    f4 c c2 c a4 g c2 d e4 f g2 a
    g4 f e2 f c4 d f2 e d4 c c2 d d4 f d \m e \me f1
    
    r2 bes,4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2 a1
      
    r2 bes4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2
    
    a\longa*1/4^\fermata
   
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pre -- te L'ô -- rè£' aÂ ma kon -- pléin -- te, Si -- ñör "Diö :"
  Vé -- £ez an -- tan -- dre le mur -- mur de ma pan -- sé^.
  Ma kla -- mör ø, ko -- me mon Rø, ko -- me mon Diö. Si te pri -- rè.
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
}

bassusIncipit = <<
  \new MensuralVoice = "bassusIncipit" <<
    \repeat unfold 2 { s1 \noBreak }
    {
      \clef "petrucci-f3" 
      \set Staff.keySignature = #`(((-2 . 6) . ,FLAT)
                                   ((-1 . 6) . ,FLAT))
      \mark \markup{\hspace #8 \small "Basse-contre"}
      \time 4/4 
      \override NoteHead  #'style = #'neomensural
      d'4
    }
  >>
  %\new Lyrics \lyricsto discantusIncipit {}
>>

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    d'4 d, g2 f d4 d f2 g a4 bes g2 f r
    f4 d c2 f d4 g \bar "" d2 a' f4 d a2 d r
    f4 d bes'2 f a4 a d2 c a4 bes g2 f c4 d \bar ""  c2 f1 r2
    f4 f bes2 g d'4 a bes2 f a4 bes d2 c r
    %5
    f,4 e f2 c d4  e \bar ""  f2 d c4 f e2 f
    c'4 d c2 f, a4 bes f2 c' g4 g f2 bes g4 d g2 f1
    
    \bar "" r2 g4 g  d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g f2 bes,2 f'4 f g2 a d,4 d8 [ \m c ] \me \bar "" bes2 f'  r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' g4 g a2 d,1
    
    \bar "" r2 g4 g  d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g f2 bes,2 f'4 f g2 a d,4 d8 [ \m c ] \me \bar "" bes2 f'  r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' g4 g a2
    
    d,\longa*1/4^\fermata \bar "|."
    
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Pre -- te L'ô -- rè£' aÂ ma kon -- pléin -- te, Si -- ñör "Diö :"
  Vé -- £ez an -- tan -- dre le mur -- mur de ma pan -- sé^.
  Ma kla -- mör ø, ko -- me mon Rø, ko -- me mon Diö. Si te pri -- rè.
  De ma -- tin don -- ke ma vøsã, Sìþ -- re, tu or -- "ras :"
  De ma -- tin don -- ke j'a -- prè -- trè mon o -- rè -- zon
  Tù -- te vèr tø, dùÂ re -- gar -- dant ma dé -- li -- vran -- se j'a -- tan -- drè.
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
  Si tu è^ Diö aÂ ki fôr -- fèt ne plé -- ra "pûint :"
  Si la mal -- fè -- tuÂ -- re çé^ tø ne se tiént "pas :"
  Si de tèz iös o da -- vant pûint ne vìå -- én -- dront lez é -- tùr -- "dis : "
}



\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \incipit \discantusIncipit #4.7 \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \incipit \altusIncipit #5.8 \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \incipit \tenorIncipit #5.2 \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \incipit \bassusIncipit #5.4 \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
  \include "../include/layout001.ly"
  \header {
    filename =  "005CPreteLoreille.ly"
    title = "Psaume V"
    subtitle = " "
    opus = " "
    composer = "Eustache Du Caurroy"
    poet = "Jean-Antoine de Baïf (1573)"
  }
}

% strophes 4-5-6


discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    a4^\markup \small "10" a bes2 a a4 d c2 bes a4 f g2 a r
    c4^\markup \small "11" d e2 f f4 d f2 e d4 d cis2 d r
    a4^\markup \small "12" a d2 c c4 a f'2 e c4 d bes2 a g4 f g2 a1 r2
    c4^\markup \small "13" c d2 d f4 f8 [ \m e ] \me d2 c f,4 f' f2 e r2
    c4^\markup \small "14" c8 [ \m bes ] \me a2 g f4 e a2 f g4 a g2 c
    c4^\markup \small "15" b c2 c f,4 f c'2 c d4 e f2 f, g4 a bes2 a1
    
    r2 d4^\markup \small "16" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "17" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "18" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d1
      
    r2 d4^\markup \small "16b" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "17b" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "18b" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d\longa*1/4^\fermata
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    %10
    a'4 f d2 f f4 f f \m c \me g'2 c,4 d d \m e \me f2 r
    f4 f g2 a a4 bes a2 c a4 a a4. \m g8 \me fis2 r
    \nr \saon f4 \saof \fo f g2 a a4 c bes \m a \me c2 f,4 f g2 c,4 \m d \me e f e2 f1 r2
    a4 a d,2 bes' a4 c bes2 a c4 bes a \m b \me c2 r
    a4 g f2 e f4 c a2 a c4 c c2 c4. \m d8 \me 
    %15
    e4 f g2 a c4 bes a2 g4 \m a \me b c a2 bes bes4 a g2 c,1
    
    r2 g'4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis1
      
    r2 g4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis\longa*1/4^\fermata
    
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    %10
    d4 d bes2 c d4 a a2 d4. \m e8 \me f4 f bes,2 c r
    a4 a c2 c d4 d d2 e4 \m a, \me d f e2 a, r
    c4 d d2 f f4 e d2 g a4 d, d2 f e4 a, c2 c1 r2
    c4 f f2 g f4 f f2 f c4 d f2 g r
    f4 c c2 c a4 g c2 d e4 f g2 a
    %15
    g4 f e2 f c4 d f2 e d4 c c2 d d4 f d \m e \me f1
    
    r2 bes,4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2 a1
      
    r2 bes4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2
    
    a\longa*1/4^\fermata
   
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    %10
    d'4 d, g2 f d4 d f2 g a4 bes g2 f r
    f4 d c2 f d4 g d2 a' f4 d a2 \bar ""  d r
    f4 d bes'2 f a4 a d2 c a4 bes g2 f c4 d c2 f1 r2
    f4 f bes2 g d'4 a \bar "" bes2 f  a4 bes d2 c r
    f,4 e f2 c d4 e f2 d c4 f e2 f
    %15
    c'4 d c2 f, a4 bes f2 \bar "" c' g4 g  f2 bes g4 d g2 f1
    
    r2 g4 g  d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g \bar "" f2 bes,2 f'4 f g2 a d,4 d8 [ \m c ] \me bes2 f'  r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' \bar "" g4 g a2 d,1
    
    r2 g4 g  d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g f2 bes,2 f'4 f g2 \bar "" a d,4 d8 [ \m c ] \me bes2 f'  r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' g4 g a2
    
    d,\longa*1/4^\fermata \bar "|."
    
    
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Kar an ôr -- rör tu lez "a^_" pris lez a -- bôr -- rant
  Tù -- lez ù -- vriérs de vén' èr -- "rör :" é dé -- trui -- ras
  Lez a -- van -- sörs de la man -- son -- je ki man -- törs ba -- vet an -- véin.
  Le dé -- tés -- tant le Si -- ñör hètã l'o -- me mô -- dit,
  Ki le sang çèrç', é de tréi -- zon le mé -- tiér fètã.
  Je me fìî mø kom' a -- sö -- ré de la gran -- dör de ta bon -- "té :"
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
  M'an a -- sö -- rant aã ta mè -- zon j'i -- rèÂ an -- "trér :"
  De se liö séint t'a -- do -- rant Diö ré -- vé -- ran -- mant,
  É de taÿ kréin -- te tù -- tù -- tré, lez o -- nörs dus je te ran -- drè.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}

%% Strophes 7-8-9

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    a4^\markup \small "19" a bes2 a a4 d c2 bes a4 f g2 a r
    c4^\markup \small "20" d e2 f f4 d f2 e d4 d cis2 d r
    a4^\markup \small "21" a d2 c c4 a f'2 e c4 d bes2 a g4 f g2 a1 r2
    c4^\markup \small "22" c d2 d f4 f8 [ \m e ] \me d2 c f,4 f' f2 e r2
    c4^\markup \small "23" c8 [ \m bes ] \me a2 g f4 e a2 f g4 a g2 c
    c4^\markup \small "24" b c2 c f,4 f c'2 c d4 e f2 f, g4 a bes2 a1
    
    r2 d4^\markup \small "25" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "26" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "27" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d1
      
    r2 d4^\markup \small "25b" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "26b" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "27b" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d\longa*1/4^\fermata
   
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    a'4 f d2 f f4 f f \m c \me g'2 c,4 d d \m e \me f2 r
    %20
    f4 f g2 a a4 bes a2 c a4 a a4. \m g8 \me fis2 r
    \nr \saon f4 \saof \fo f g2 a a4 c bes \m a \me c2 f,4 f g2 c,4 \m d \me e f e2 f1 r2
    a4 a d,2 bes' a4 c bes2 a c4 bes a \m b \me c2 r
    a4 g f2 e f4 c a2 a c4 c c2 c4. \m d8 \me 
    e4 f g2 a c4 bes a2 g4 \m a \me b c a2 bes bes4 a g2 c,1
    %25
    
    r2 g'4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis1
      
    r2 g4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis\longa*1/4^\fermata
    
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    d4 d bes2 c d4 a a2 d4. \m e8 \me f4 f bes,2 c r
    %20
    a4 a c2 c d4 d d2 e4 \m a, \me d f e2 a, r
    c4 d d2 f f4 e d2 g a4 d, d2 f e4 a, c2 c1 r2
    c4 f f2 g f4 f f2 f c4 d f2 g r
    f4 c c2 c a4 g c2 d e4 f g2 a
    g4 f e2 f c4 d f2 e d4 c c2 d d4 f d \m e \me f1
    %25
    
    r2 bes,4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2 a1
      
    r2 bes4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2
    
    a\longa*1/4^\fermata
    
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    d'4 d, g2 f d4 d f2 g a4 bes g2 f r
    %20
    f4 d c2 f d4 g d2 a'  f4 d a2 \bar "" d r
    f4 d bes'2 f a4 a d2 c a4 bes g2 f c4 d c2 f1  r2
    f4 f bes2 g d'4 a \bar "" bes2 f a4 bes d2 c r
    f,4 e f2 c d4 e  f2 d c4 f e2 f
    c'4 d c2 f, a4 bes f2 \bar "" c' g4 g f2 bes g4 d g2 f1
    %25
    
    r2 g4 g  d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g \bar "" f2 bes,2 f'4 f g2 a d,4 d8 [ \m c ] \me bes2 f'  r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' \bar "" g4 g a2 d,1
    
    r2 g4 g  d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g f2 bes,2 f'4 f g2 \bar "" a d,4 d8 [ \m c ] \me bes2 f'  r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' g4 g a2
    
    d,\longa*1/4^\fermata \bar "|."
   
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  De taÂ drø -- tuÿ -- re, Si -- ñör Diö, gi -- de "mè_" pa^s,
  Ke ne sø mis aã la mèr -- sìþ de mon héi -- "nös :"
  É da -- vant mø dré -- se tù^ -- jùrs le çe -- min séint de ta bon -- té.
  Nu -- le jus -- tis -- se de saÿ bùÿ -- çe ne sùr -- "dra :"
  Le de -- dans d'ös, dé -- loæ -- iô -- "tés :" é le gô -- ziér,
  UÀn' ù -- vèr -- tuÿ -- re de tun -- "beô :" é de lör lan -- ge fla -- törs sont.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
  Dé -- zo -- lés søÎt, sa -- ka -- jés "søÎt :" é Si -- ñör Diö
  Tù -- te l'an -- prìî -- ze k'il ont fè -- teã, dé -- "fè_" la.
  Jé -- "te-" -- lèz an -- tre le gran non -- bre de lö^ frôÎ -- dez é fôr -- fèsã.
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}

%% Strophes 10-11

discantusNotes = {
  \relative c'' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "trombone"
    \key f \major
    \clef "treble"
    \cadenzaOn
    c4^\markup \small "28" c d2 d f4 f8 [ \m e ] \me d2 c f,4 f' f2 e r2
    c4^\markup \small "29" c8 [ \m bes ] \me a2 g f4 e a2 f g4 a g2 c
    c4^\markup \small "30" b c2 c f,4 f c'2 c d4 e f2 f, g4 a bes2 a1
    
    r2 d4^\markup \small "31" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "32" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "33" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d1
      
    r2 d4^\markup \small "31b" d f2 e a,4 a a2 bes a4 g a2 a r
    fis4^\markup \small "32b" g a2 d a4 c bes2 a a4 a d2 c r2
    a4^\markup \small "33b" a c2 f, g4 a bes2 a a4 c bes2 a d,4 d' cis2 d\longa*1/4^\fermata
    
  }
  \cadenzaOff
}

discantusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

altusNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "treble"
    a'4 a d,2 bes' a4 c bes2 a c4 bes a \m b \me c2 r
    a4 g f2 e f4 c a2 a c4 c c2 c4. \m d8 \me 
    %30
    e4 f g2 a c4 bes a2 g4 \m a \me b c a2 bes bes4 a g2 c,1
    
    r2 g'4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis1
      
    r2 g4 d d2 g f4 f e2 g f4 d d2 cis r
    a'4 d, f2 f f4 c g'2 e f4 f bes2 a r
    f4 f e \m f \me d2 bes'4 a g2 c, d4 c f2 f4 \m c \me g' g e2 fis\longa*1/4^\fermata
  }
}

altusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

tenorNotes = {
  \relative c' {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f  \major
    \clef "G_8"
    c4 f f2 g f4 f f2 f c4 d f2 g r
    f4 c c2 c a4 g c2 d e4 f g2 a
    %30
    g4 f e2 f c4 d f2 e d4 c c2 d d4 f d \m e \me f1
   
    r2 bes,4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2 a1
      
    r2 bes4 bes a2 c c4 d c2 d d4 d f2 e r
    d4 bes c2 bes c4 a d2 cis d4 a f'2 f r2
    c4 d c2 bes8 [ \m c ] d4 \me d f d \m e \me f2 f4 f d2 c bes4 bes a2
    
    a\longa*1/4^\fermata
  }
}

tenorLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra.
}

bassusNotes = {
  \relative c {
    \set Staff.instrumentName = ""
    \set Staff.midiInstrument = "voice oohs"
    \key f \major
    \clef "bass"
    f4 f bes2 g d'4 a bes2 f a4 bes d2 c r
    f,4 e f2 c d4 e f2 d  \bar "" c4 f e2 f
    %30
    c'4 d c2 f, a4 bes f2 c' g4 g f2 bes g4 d g2 f1
  
    r2 g4 g  \bar "" d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g f2 bes,2 f'4 f g2 a d,4 d8 [ \m c ] \me bes2 f'  \bar "" r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' g4 g a2 d,1
    
    r2 g4 g \bar ""  d2 c f4 d a'2 g d4 bes'4 a2 a r
    d,4 g f2 bes,2 f'4 f g2 a d,4 d8 [ \m c ] \me \bar "" bes2 f'  r
    f4 d a'2 bes4. \m a8 \me g4 d g2 f4. \m e8 \me d4 a bes2 f' g4 g a2
    
    d,\longa*1/4^\fermata \bar "|."
  }
}

bassusLyrics = \lyricmode {
  \override LyricText #'font-name = "baifB"
  Jé -- "te-" -- lèz, ös ki se sont prins aÂ ta gran -- "dör :"
  É ke tùs sös ki dé -- vôÎs és -- pé -- ret an tø,
  Ré -- jù -- ìås søÎt. I fe -- ront fè^t' a -- ja -- mès, kand lez aÂ -- brìî -- ras.
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra. 
  Ki ta gran -- dör é -- met, an tø se ré -- kré^ -- "ront :"
  A l'om' an -- tiér ta fa -- vör, Sìþ -- re, tu don -- "ras :"
  É le bù -- kliér de ta bon -- té le kù -- vrant tùt, le dé -- fan -- dra. 
}

\score {
  \new StaffGroup = choirStaff <<
    \new Voice =
      discantusNotes << \global \discantusNotes >>
    \new Lyrics =
      discantusLyrics \lyricsto discantusNotes { \discantusLyrics }
    \new Voice =
      altusNotes << \global \altusNotes >>
    \new Lyrics =
      altusLyrics \lyricsto altusNotes { \altusLyrics }
    \new Voice =
      tenorNotes << \global \tenorNotes >>
    \new Lyrics =
      tenorLyrics \lyricsto tenorNotes { \tenorLyrics }
    \new Voice =
      bassusNotes << \global \bassusNotes >>
    \new Lyrics =
      bassusLyrics \lyricsto bassusNotes { \bassusLyrics }
  >>
  \midi {
    \context {
       \Score
       tempoWholesPerMinute = #(ly:make-moment 60 2)
     }
   }
   \include "../include/layout001nr.ly"
}